/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.interfaces.base;

import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.MarkupLocator;
import com.epam.jdi.tools.map.MapArray;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public interface ICoreElement
extends IBaseElement {
    public UIElement core();

    default public UIElement iCore() {
        return this.core();
    }

    default public <T> T with(Class<T> cl) {
        return this.core().with(cl);
    }

    @JDIAction(value="Hover to '{name}'")
    default public void hover() {
        this.iCore().hover();
    }

    @JDIAction(value="Check that '{name}' is enabled", timeout=0)
    default public boolean isEnabled() {
        return this.iCore().isEnabled();
    }

    @JDIAction(value="Check that '{name}' is disabled", timeout=0)
    default public boolean isDisabled() {
        return !this.isEnabled();
    }

    @JDIAction(value="Check that '{name}' is displayed", timeout=0)
    default public boolean isDisplayed() {
        return this.iCore().isDisplayed();
    }

    @JDIAction(value="Check that '{name}' is visible for user", timeout=0)
    default public boolean isVisible() {
        return this.iCore().isVisible();
    }

    @JDIAction(value="Check that '{name}' is not visible by user", timeout=0)
    default public boolean isNotVisible() {
        return this.iCore().isNotVisible();
    }

    @JDIAction(value="Check that '{name}' is hidden", timeout=0)
    default public boolean isHidden() {
        return !this.isDisplayed();
    }

    @JDIAction(value="Check that '{name}' is exist on the page", timeout=0)
    default public boolean isExist() {
        return this.iCore().isExist();
    }

    @JDIAction(value="Check that '{name}' is missed on the page", timeout=0)
    default public boolean isNotExist() {
        return this.iCore().isNotExist();
    }

    default public void highlight(String color) {
        this.iCore().highlight();
    }

    default public void highlight() {
        this.iCore().highlight();
    }

    default public Point getLocation() {
        return this.iCore().getLocation();
    }

    default public Dimension getSize() {
        return this.iCore().getSize();
    }

    default public void show() {
        this.iCore().show();
    }

    default public void setAttribute(String name, String value) {
        this.iCore().setAttribute(name, value);
    }

    default public String attr(String name) {
        return this.iCore().attr(name);
    }

    default public MapArray<String, String> attrs() {
        return this.iCore().attrs();
    }

    default public String css(String prop) {
        return this.iCore().css(prop);
    }

    default public boolean hasClass(String className) {
        return this.iCore().hasClass(className);
    }

    default public boolean hasAttribute(String attrName) {
        return this.iCore().hasAttribute(attrName);
    }

    default public String printHtml() {
        return this.iCore().printHtml();
    }

    default public List<String> classes() {
        return this.iCore().classes();
    }

    default public UIElement find(@MarkupLocator String by) {
        return this.iCore().find(by);
    }

    default public UIElement find(@MarkupLocator By by) {
        return this.iCore().find(by);
    }

    default public WebList finds(@MarkupLocator String by) {
        return this.iCore().finds(by);
    }

    default public WebList finds(@MarkupLocator By by) {
        return this.iCore().finds(by);
    }

    default public UIElement firstChild() {
        return this.iCore().firstChild();
    }

    default public WebList children() {
        return this.iCore().children();
    }

    default public String getTagName() {
        return this.iCore().getTagName();
    }

    default public void visualValidation(String tag) {
        this.iCore().visualValidation(tag);
    }

    default public void visualValidation(UIElement element) {
        this.iCore().visualValidation(element);
    }

    default public void dragAndDropTo(WebElement element) {
        this.iCore().dragAndDropTo(element);
    }

    default public void dragAndDropTo(int x, int y) {
        this.iCore().dragAndDropTo(x, y);
    }

    default public void rightClick() {
        this.iCore().rightClick();
    }

    default public void doubleClick() {
        this.iCore().doubleClick();
    }

    default public void press(Keys key) {
        this.iCore().press(key);
    }

    default public void command(String sequence) {
        this.iCore().command(sequence);
    }

    default public void commands(String ... commands) {
        this.iCore().commands(commands);
    }

    default public void pasteText(String text) {
        this.iCore().pasteText(text);
    }

    default public void pasteText(String text, long timeToWaitMSec) {
        this.iCore().pasteText(text, timeToWaitMSec);
    }
}

