/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.init.entities.collection;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.elements.base.UIListBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.JsonUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.PropertyReader;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntitiesCollection {
    public static MapArray<String, WebPage> PAGES = new MapArray();
    public static MapArray<String, List<Object>> ELEMENTS = new MapArray();
    static MapArray<String, String> jsonPages;
    static MapArray<String, String> jsonElements;

    private EntitiesCollection() {
    }

    public static void addPage(WebPage page) {
        PAGES.update((Object)page.getName(), (Object)page);
    }

    public static void updatePage(WebPage page) {
        String className = page.getClass().getSimpleName();
        if (PAGES.keys().contains(className)) {
            PAGES.removeByKey((Object)className);
        }
        PAGES.update((Object)page.getName(), (Object)page);
    }

    static void readPagesFromJson() {
        jsonPages = JsonUtils.getMapFromJson((String)"pages", (String)"json.page.objects");
    }

    public static WebPage getPage(String pageName) {
        WebSettings.init();
        WebPage page = (WebPage)PAGES.get((Object)pageName);
        if (page == null) {
            page = (WebPage)PAGES.get((Object)(pageName + " Page"));
        }
        if (page == null) {
            if (jsonPages == null) {
                EntitiesCollection.readPagesFromJson();
            }
            if (jsonPages == null) {
                throw Exceptions.exception("Can't find page with name %s. Available pages: %s", pageName, PrintUtils.print((Collection)PAGES.keys()));
            }
            page = new WebPage((String)jsonPages.get((Object)pageName));
        }
        return page;
    }

    public static WebPage getPageByUrl(String url) {
        Pair result = PAGES.first((k, v) -> v.isOnPage(url));
        return result != null ? (WebPage)result.value : null;
    }

    public static void addElement(Object jdi) {
        if (ReflectionUtils.isInterface(jdi.getClass(), ICoreElement.class)) {
            ICoreElement element = (ICoreElement)jdi;
            if (ELEMENTS.has((Object)element.getName())) {
                ((List)ELEMENTS.get((Object)element.getName())).add(jdi);
            } else {
                ArrayList<ICoreElement> newList = new ArrayList<ICoreElement>();
                newList.add(element);
                ELEMENTS.add((Object)element.getName(), newList);
            }
        }
    }

    public static <T extends UIListBase> WebList getList(String name, Class<T> type) {
        Object element = EntitiesCollection.getElement(name);
        if (element != null) {
            if (ReflectionUtils.isClass(element.getClass(), type)) {
                return ((UIListBase)element).list();
            }
            if (ReflectionUtils.isClass(element.getClass(), WebList.class)) {
                return (WebList)element;
            }
        }
        throw Exceptions.exception("Can't cast element '%s' to '%s'", name, type.getSimpleName());
    }

    public static <T> T getUI(String name, Class<T> type) {
        Object element = EntitiesCollection.getElement(name);
        if (element != null && ReflectionUtils.isClass(element.getClass(), type)) {
            return (T)element;
        }
        throw Exceptions.exception("Can't cast element '%s' to '%s'", name, type.getSimpleName());
    }

    public static <T> T getByType(ICoreElement element, Class<T> type) {
        try {
            ICoreElement core = ReflectionUtils.isClass(element.getClass(), type) ? element : element.core();
            return (T)core;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get element '%s' of type '%s'", element.getName(), type.getSimpleName());
        }
    }

    public static ICoreElement getUI(String name) {
        Object element = EntitiesCollection.getElement(name);
        if (element != null && ReflectionUtils.isInterface(element.getClass(), ICoreElement.class)) {
            return (ICoreElement)element;
        }
        throw Exceptions.exception("Can't find '%s' element", name);
    }

    static void readElementsFromJson() {
        List filePaths = JsonUtils.scanFolder((String)("src/test/resources" + PropertyReader.getProperty((String)"json.page.objects")));
        jsonElements = new MapArray();
        for (String filePath : filePaths) {
            try {
                jsonElements.addAll((Map)new ObjectMapper().readValue(new File(filePath), HashMap.class));
            }
            catch (IOException e) {
                throw new RuntimeException("Can't read elements from json");
            }
        }
    }

    static Object getElement(String name) {
        if (!name.matches("[A-Z].*")) {
            return UIFactory.$(name);
        }
        String[] split = name.split("\\.");
        if (split.length == 2) {
            return EntitiesCollection.getElementInSection(split[1], split[0]);
        }
        if (ELEMENTS.has((Object)name)) {
            Object element;
            List elements = (List)ELEMENTS.get((Object)name);
            if (elements.size() > 1 && (element = LinqUtils.first((Collection)elements, el -> {
                WebPage page = ((ICoreElement)el).base().getPage();
                return page != null && page.getName().equals(WebPage.getCurrentPage());
            })) != null) {
                return element;
            }
            return elements.get(0);
        }
        if (jsonElements == null) {
            EntitiesCollection.readElementsFromJson();
        }
        return jsonElements.keys().contains(name) ? UIFactory.$((String)jsonElements.get((Object)name)) : new UIElement().setName(name);
    }

    static Object getElementInSection(String name, String section) {
        if (ELEMENTS.has((Object)name)) {
            List els = (List)ELEMENTS.get((Object)name);
            Object result = LinqUtils.first((Collection)els, el -> ReflectionUtils.isInterface(el.getClass(), IBaseElement.class) && ((IBaseElement)el).base().hasParent(section));
            if (result == null) {
                throw Exceptions.exception("Can't find '%s' element at '%s'", name, section);
            }
            return result;
        }
        throw Exceptions.exception("Can't find '%s' element", name);
    }
}

