/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.init;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.base.UIListBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.DataList;
import com.epam.jdi.light.elements.complex.JList;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.init.InitActions;
import com.epam.jdi.light.elements.init.SiteInfo;
import com.epam.jdi.light.elements.init.entities.collection.EntitiesCollection;
import com.epam.jdi.light.elements.init.rules.InitRule;
import com.epam.jdi.light.elements.init.rules.SetupRule;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.light.elements.pageobjects.annotations.Title;
import com.epam.jdi.light.elements.pageobjects.annotations.Url;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class PageFactory {
    public static List<Class<?>> STOP_INIT_CLASSES = Arrays.asList(Object.class, WebPage.class, PageObject.class, UIElement.class, UIBaseElement.class, UIListBase.class, DataList.class, JList.class, WebList.class);

    public static void initSite(Class<?> site) {
        WebSettings.init();
        PageFactory.initSite(site, JDISettings.DRIVER.name);
    }

    public static void initSite(Class<?> site, String driverName) {
        WebSettings.init();
        SiteInfo info = (SiteInfo)((Object)new SiteInfo(driverName).set(s -> {
            s.parentClass = site;
        }));
        PageFactory.initialize(site, info);
    }

    private static void initialize(Class<?> site, SiteInfo info) {
        WebAnnotationsUtil.setDomain(site);
        for (Field pageField : PageFactory.getSiteFields(site)) {
            try {
                info.field = pageField;
                PageFactory.setFieldWithInstance(info, null);
            }
            catch (Throwable ex) {
                throw Exceptions.exception(ex, PageFactory.initException(pageField, site), new Object[0]);
            }
        }
    }

    private static void setFieldWithInstance(SiteInfo info, Object obj) throws IllegalAccessException {
        WebSettings.logger.debug("setFieldWithInstance(info:%s)", new Object[]{info});
        Object instance = PageFactory.getElementInstance(info);
        if (instance != null) {
            EntitiesCollection.addElement(instance);
            info.field.set(obj, instance);
        }
    }

    private static Object getElementInstance(SiteInfo info) {
        info.instance = ReflectionUtils.getValueField((Field)info.field, (Object)info.parent);
        if (info.instance == null) {
            PageFactory.initJdiField(info);
        }
        if (info.instance != null) {
            PageFactory.setupFieldUsingRules(info);
        }
        return info.instance;
    }

    public static void initJdiField(SiteInfo info) {
        WebSettings.logger.debug("initJdiField", new Object[0]);
        if (info.type().isInterface()) {
            PageFactory.initUsingRules(info);
        } else {
            PageFactory.initWithConstructor(info);
        }
    }

    public static void setupFieldUsingRules(SiteInfo info) {
        WebSettings.logger.debug("setupFieldUsingRules", new Object[0]);
        MapArray setupRules = InitActions.SETUP_RULES.filter((k, r) -> (Boolean)r.condition.execute((Object)info));
        if (setupRules.size() == 0) {
            return;
        }
        String ruleName = "UNDEFINED";
        WebSettings.logger.debug("SETUP_RULES.count=" + setupRules.size(), new Object[0]);
        try {
            for (Pair rule : setupRules) {
                ruleName = (String)rule.key;
                WebSettings.logger.debug("Use setupRule '%s'", ruleName);
                ((SetupRule)rule.value).action.execute((Object)info);
            }
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "Setup rule '%s' failed. Can't setup field '%s' on page '%s'", ruleName, info.name(), info.parentName());
        }
    }

    private static String initException(Field field, Class<?> parent) {
        return String.format("Can't init '%s' '%s' on '%s'", PageFactory.getSafe((JFunc<String>)((JFunc)() -> ReflectionUtils.isClass(field.getType(), WebPage.class) ? "page" : "element"), "Element Type"), PageFactory.getSafe((JFunc<String>)((JFunc)() -> field.getName()), "Field Name"), PageFactory.getSafe((JFunc<String>)((JFunc)() -> parent.getSimpleName()), "Parent Type"));
    }

    private static String getSafe(JFunc<String> value, String defaultValue) {
        try {
            return (String)value.execute();
        }
        catch (Throwable ignore) {
            return "Error " + defaultValue;
        }
    }

    private static List<Field> getSiteFields(Class<?> site) {
        Object[] pages = site.getDeclaredFields();
        return LinqUtils.filter((Object[])pages, p -> Modifier.isStatic(p.getModifiers()));
    }

    private static void setField(Field field, SiteInfo pageInfo, SiteInfo info) {
        pageInfo.field = field;
        try {
            Object obj = Modifier.isStatic(field.getModifiers()) ? null : info.instance;
            PageFactory.setFieldWithInstance(pageInfo, obj);
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, PageFactory.initException(field, info.type()), new Object[0]);
        }
    }

    private static <T> T initUsingRules(SiteInfo info) {
        WebSettings.logger.debug("initUsingRules", new Object[0]);
        Pair firstRule = InitActions.INIT_RULES.first((k, r) -> (Boolean)r.condition.execute((Object)info.field));
        if (firstRule != null) {
            WebSettings.logger.debug("Use initRule: " + (String)firstRule.key, new Object[0]);
            try {
                info.instance = ((InitRule)firstRule.value).func.execute((Object)info);
                return (T)info.instance;
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Init rule '%s' failed. Can't init field '%s' on page '%s'", firstRule.key, info.name(), info.parentName());
            }
        }
        WebSettings.logger.debug("No initRules found", new Object[0]);
        throw Exceptions.exception("No init rules found for '%s' (you can add appropriate rule in InitActions.INIT_RULES)" + StringUtils.LINE_BREAK + "Maybe you can solve you problem by adding WebSettings.init() in your @BeforeSuite setUp() method" + StringUtils.LINE_BREAK + "or by adding corresponded mapping in InitActions.INTERFACES using add(...) method", info.name());
    }

    private static void initWithConstructor(SiteInfo info) {
        try {
            WebSettings.logger.debug("initWithConstructor", new Object[0]);
            info.instance = ReflectionUtils.create(info.type());
            WebSettings.logger.debug("new %s() success", info.type().getSimpleName());
        }
        catch (Throwable exception) {
            try {
                String msg = Exceptions.safeException(exception);
                if (msg.contains("has no empty constructors") || msg.contains("Can't init class. Class Type is null")) {
                    info.instance = ReflectionUtils.create(info.type(), (Object[])new Object[]{WebDriverFactory.getDriver(info.driverName)});
                }
                throw Exceptions.exception(msg, new Object[0]);
            }
            catch (Throwable ex) {
                throw Exceptions.exception(ex, "Can't create field '%s' instance of type '%s'. Try new %s() to get more details", info.name(), info.type(), info.type());
            }
        }
    }

    private static void initWebPage(WebPage webPage) {
        webPage.driverName = JDISettings.DRIVER.name;
        webPage.updatePageData(webPage.getClass().getAnnotation(Url.class), webPage.getClass().getAnnotation(Title.class));
        EntitiesCollection.addPage(webPage);
    }

    private static <T> T getPageObject(WebDriver driver, Class<T> pageClassToProxy) {
        try {
            return (T)ReflectionUtils.create(pageClassToProxy, (Object[])new Object[]{driver});
        }
        catch (Exception ignore) {
            try {
                return (T)ReflectionUtils.create(pageClassToProxy);
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, pageClassToProxy + " class should has constructor with WebDriver parameter", new Object[0]);
            }
        }
    }

    public static void initElements(SiteInfo info) {
        List poFields = ReflectionUtils.recursion(info.instance.getClass(), t -> !STOP_INIT_CLASSES.contains(t), t -> Arrays.asList(t.getDeclaredFields()));
        List fields = LinqUtils.filter((Collection)poFields, f -> InitActions.isJDIField(f) || InitActions.isPageObject(f.getType()));
        SiteInfo pageInfo = new SiteInfo(info);
        pageInfo.parent = info.instance;
        for (Field field : fields) {
            PageFactory.setField(field, pageInfo, info);
        }
    }

    private static void initPage(Object page) {
        SiteInfo info = new SiteInfo(JDISettings.DRIVER.name, page);
        if (ReflectionUtils.isClass(page.getClass(), WebPage.class)) {
            PageFactory.initWebPage((WebPage)page);
        }
        PageFactory.initElements(info);
    }

    public static void initElements(JFunc<WebDriver> driver, Object ... pages) {
        WebSettings.init();
        WebDriverFactory.useDriver(driver);
        PageFactory.initElements(pages);
    }

    public static void initElements(Class<?> site) {
        PageFactory.initSite(site);
    }

    public static void initElements(Object page) {
        WebSettings.init();
        PageFactory.initPage(page);
    }

    public static void initElements(Object ... pages) {
        WebSettings.init();
        for (Object page : pages) {
            PageFactory.initPage(page);
        }
    }

    public static void initElements(Class<?> ... pages) {
        List pageList = LinqUtils.map(Arrays.asList(pages), p -> PageFactory.getPageObject(WebDriverFactory.getDriver(), p));
        PageFactory.initElements(pageList.toArray(new Object[pageList.size()]));
    }

    public static <T> T initElements(WebDriver driver, Class<T> pageClassToProxy) {
        T page = PageFactory.getPageObject(driver, pageClassToProxy);
        String pageName = StringUtils.splitCamelCase((String)pageClassToProxy.getSimpleName());
        WebPage webPage = new WebPage();
        webPage.updatePageData(webPage.getClass().getAnnotation(Url.class), webPage.getClass().getAnnotation(Title.class));
        webPage.setName(pageName);
        EntitiesCollection.PAGES.update((Object)pageName, (Object)webPage);
        PageFactory.initElements(driver, page);
        return page;
    }

    public static void initElements(WebDriver driver, Object page) {
        PageFactory.initElements((JFunc<WebDriver>)((JFunc)() -> driver), page);
    }

    public static void initElements(ElementLocatorFactory factory, Object page) {
        PageFactory.initElements(page);
    }

    public static void initElements(FieldDecorator decorator, Object page) {
        PageFactory.initElements(page);
    }
}

