/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.composite;

import com.epam.jdi.light.common.CheckTypes;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.OutputTemplates;
import com.epam.jdi.light.common.PageChecks;
import com.epam.jdi.light.common.VisualCheckPage;
import com.epam.jdi.light.driver.ScreenshotMaker;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.base.DriverBase;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.WindowsManager;
import com.epam.jdi.light.elements.composite.Form;
import com.epam.jdi.light.elements.init.PageFactory;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.light.elements.pageobjects.annotations.Title;
import com.epam.jdi.light.elements.pageobjects.annotations.Url;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.light.logger.AllureLogger;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.logger.Strategy;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.JsonUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PathUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.switcher.CaseR;
import com.epam.jdi.tools.switcher.SwitchActions;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntry;

public class WebPage
extends DriverBase
implements PageObject {
    public String url = "";
    public String title = "";
    public String checkUrl;
    public CheckTypes checkUrlType = CheckTypes.CONTAINS;
    public CheckTypes checkTitleType = CheckTypes.NONE;
    public static PageChecks CHECK_AFTER_OPEN = PageChecks.NONE;
    private static Safe<String> currentPage = new Safe((Object)"Undefined Page");

    public <T> Form<T> asForm() {
        return new Form().setPageObject(this).setup(Form.class, (JAction1<JDIBase>)((JAction1)e -> e.setName(this.getName() + " Form").setParent(this)));
    }

    public static String getCurrentPage() {
        return (String)currentPage.get();
    }

    public static void setCurrentPage(WebPage page) {
        String newPage;
        String oldPage = (String)currentPage.get();
        if (!oldPage.equals(newPage = page.getName())) {
            JDISettings.PAGE.beforeNewPage.execute((Object)page);
            currentPage.set((Object)newPage);
        }
    }

    public WebPage() {
        PageFactory.initElements((Object)this);
    }

    public WebPage(String url) {
        this.setUrl(url, url, CheckTypes.CONTAINS);
    }

    public WebPage(String url, String title) {
        this(url);
        this.title = title;
    }

    public static void openUrl(String url, String pageName) {
        WebPage page = new WebPage(url);
        page.setName(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pageName) ? pageName : "");
        page.open(new Object[0]);
    }

    public static void openUrl(String url) {
        WebSettings.init();
        if (!WebSettings.hasDomain() && url.contains("://")) {
            JDISettings.DRIVER.domain = url;
        }
        new WebPage(url).open(new Object[0]);
    }

    public static void checkUrl(String url) {
        WebSettings.init();
        new WebPage(url).checkOpened();
    }

    @JDIAction
    public static boolean verifyUrl(String url) {
        WebSettings.init();
        return WebPage.getUrl().contains(url);
    }

    @JDIAction
    public static boolean verifyTitle(String title) {
        WebSettings.init();
        return WebPage.getTitle().contains(title);
    }

    public static void checkTitle(String title) {
        WebSettings.init();
        new WebPage("", title).checkOpened();
    }

    public static void checkPage(String url, String title) {
        WebSettings.init();
        new WebPage(url, title).checkOpened();
    }

    public static void openSite() {
        WebSettings.init();
        new WebPage(WebSettings.getDomain()).open(new Object[0]);
    }

    public static void openSite(Class<?> site) {
        PageFactory.initSite(site);
        WebPage page = new WebPage(WebSettings.getDomain());
        page.setName(site.getSimpleName());
        page.open(new Object[0]);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String getUrl() {
        return WebDriverFactory.getDriver().getCurrentUrl();
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String getTitle() {
        return WebDriverFactory.getDriver().getTitle();
    }

    void setUrl(String uri) {
        this.setUrl(uri, "", CheckTypes.CONTAINS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setUrl(String uri, String template, CheckTypes validate) {
        this.url = uri;
        this.checkUrl = template;
        this.checkUrlType = validate;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)template)) {
            if (validate == CheckTypes.MATCH) throw Exceptions.exception("In order to validate MATCH for page '%s', please specify 'template' in @Url", this.getName());
            this.checkUrl = uri;
        } else if (validate == null) {
            this.checkUrlType = CheckTypes.MATCH;
        }
        if (!uri.contains("://")) {
            this.url = WebAnnotationsUtil.getUrlFromUri(uri);
            return;
        } else {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)uri)) return;
            this.url = WebSettings.getDomain();
        }
    }

    public void updatePageData(Url urlAnnotation, Title titleAnnotation) {
        if (urlAnnotation != null) {
            this.setUrl(urlAnnotation.value(), urlAnnotation.template(), urlAnnotation.validate());
        } else {
            this.setUrl(WebSettings.getDomain());
        }
        if (titleAnnotation != null) {
            this.title = titleAnnotation.value();
            this.checkTitleType = titleAnnotation.validate();
        }
    }

    public StringCheckType url() {
        return new StringCheckType(() -> ((WebDriver)this.driver()).getCurrentUrl(), this.checkUrl, "url");
    }

    public StringCheckType title() {
        return new StringCheckType(() -> ((WebDriver)this.driver()).getTitle(), this.title, "title");
    }

    @JDIAction(value="Open '{name}'(url={0})", timeout=0)
    private void open(String url) {
        WebSettings.init();
        CacheValue.reset();
        this.driver().navigate().to(url);
        WindowsManager.getWindows();
        WebPage.setCurrentPage(this);
    }

    public void open(Object ... params) {
        this.open(this.getUrlWithParams(params));
    }

    private String getUrlWithParams(Object ... params) {
        if (params == null || params.length == 0) {
            return this.url;
        }
        if (this.url.contains("%s")) {
            return String.format(this.url, params);
        }
        return this.url.contains("{0}") ? MessageFormat.format(this.url, params) : this.url + "?" + PrintUtils.print((Collection)LinqUtils.map((Object[])params, Object::toString), (String)"&");
    }

    @JDIAction(value="Check that '{name}' is opened (url {checkUrlType} '{checkUrl}'; title {checkTitleType} '{title}') in new window")
    public void checkOpenedInNewWindow() {
        WindowsManager.checkNewWindowIsOpened();
        this.checkOpened();
    }

    @JDIAction(value="Check that '{name}' is opened (url {checkUrlType} '{checkUrl}'; title {checkTitleType} '{title}')")
    public void checkOpened() {
        if (WebDriverFactory.noRunDrivers()) {
            throw Exceptions.exception("Page '%s' is not opened: Driver is not run", this.toString());
        }
        String result = (String)SwitchActions.Switch((Object)((Object)this.checkUrlType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), (Object)""), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> !this.url().check() ? "Url '%s' doesn't equal to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> !this.url().match() ? "Url '%s' doesn't match to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> !this.url().contains() ? "Url '%s' doesn't contains '%s'" : "")});
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)result)) {
            throw Exceptions.exception("Page '%s' is not opened: %s", this.getName(), String.format(result, this.driver().getCurrentUrl(), this.checkUrl));
        }
        result = (String)SwitchActions.Switch((Object)((Object)this.checkTitleType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), (Object)""), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> !this.title().check() ? "Title '%s' doesn't equal to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> !this.title().match() ? "Title '%s' doesn't match to '%s'" : ""), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> !this.title().contains() ? "Title '%s' doesn't contains '%s'" : "")});
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)result)) {
            throw Exceptions.exception("Page '%s' is not opened: %s", this.getName(), String.format(result, this.driver().getTitle(), this.title));
        }
        WebPage.setCurrentPage(this);
        if (WebSettings.VISUAL_PAGE_STRATEGY == VisualCheckPage.CHECK_PAGE) {
            WebPage.visualWindowCheck();
        }
    }

    public boolean isOnPage(String url) {
        switch (this.checkUrlType) {
            case NONE: 
            case EQUALS: {
                return url.equals(this.checkUrl);
            }
            case MATCH: {
                return url.matches(this.checkUrl);
            }
            case CONTAINS: {
                return url.contains(this.checkUrl);
            }
        }
        return false;
    }

    @JDIAction(value="Check that '{name}' is opened (url {checkUrlType} '{checkUrl}'; title {checkTitleType} '{title}')")
    public static void visualWindowCheck() {
    }

    @JDIAction(level=LogLevels.DEBUG)
    public boolean isOpened() {
        if (WebDriverFactory.noRunDrivers()) {
            return false;
        }
        boolean result = (Boolean)SwitchActions.Switch((Object)((Object)this.checkUrlType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), t -> true), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> this.url().check()), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> this.url().match()), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> this.url().contains()), SwitchActions.Else((Object)false)});
        if (!result) {
            return false;
        }
        result = (Boolean)SwitchActions.Switch((Object)((Object)this.checkTitleType)).get(new CaseR[]{SwitchActions.Value((Object)((Object)CheckTypes.NONE), t -> true), SwitchActions.Value((Object)((Object)CheckTypes.EQUALS), t -> this.title().check()), SwitchActions.Value((Object)((Object)CheckTypes.MATCH), t -> this.title().match()), SwitchActions.Value((Object)((Object)CheckTypes.CONTAINS), t -> this.title().contains()), SwitchActions.Else((Object)false)});
        if (result) {
            WebPage.setCurrentPage(this);
        }
        return result;
    }

    public void shouldBeOpened() {
        this.openedPage(this.url);
    }

    public void shouldBeOpened(Object ... params) {
        this.openedPage(this.getUrlWithParams(params));
    }

    @JDIAction(value="'{name}'(url={0}) should be opened")
    private void openedPage(String url) {
        if (this.isOpened()) {
            return;
        }
        this.open(url);
        this.checkOpened();
    }

    @JDIAction(value="Reload current page", isAssert=true)
    public static void refresh() {
        WebDriverFactory.getDriver().navigate().refresh();
    }

    public static void reload() {
        WebPage.refresh();
    }

    @JDIAction(value="Go back to previous page")
    public static void back() {
        WebDriverFactory.getDriver().navigate().back();
    }

    @JDIAction(value="Go forward to next page")
    public static void forward() {
        WebDriverFactory.getDriver().navigate().forward();
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static void zoom(double factor) {
        WebDriverFactory.jsExecute("document.body.style.transform = 'scale(' + arguments[0] + ')';document.body.style.transformOrigin = '0 0';", factor);
    }

    @JDIAction
    public static String getHtml() {
        return WebDriverFactory.getDriver().getPageSource();
    }

    public static List<LogEntry> getHttpRequests() {
        return WebDriverFactory.getDriver().manage().logs().get("performance").getAll();
    }

    @JDIAction(level=LogLevels.DEBUG)
    private static void scroll(int x, int y) {
        WebDriverFactory.jsExecute("window.scrollBy(" + x + "," + y + ")", new Object[0]);
    }

    public static boolean isBottomOfThePage() {
        return (Boolean)WebDriverFactory.jsExecute("return ((window.innerHeight + window.scrollY) >= document.body.scrollHeight);", new Object[0]);
    }

    public static boolean isTopOfThePage() {
        return (Boolean)WebDriverFactory.jsExecute("return window.scrollX == window.scrollY;", new Object[0]);
    }

    @JDIAction
    public static void scrollToTop() {
        WebDriverFactory.jsExecute("window.scrollTo(0,0)", new Object[0]);
    }

    @JDIAction
    public static void scrollToBottom() {
        WebDriverFactory.jsExecute("window.scrollTo(0,document.body.scrollHeight)", new Object[0]);
    }

    @JDIAction(value="Scroll screen down on '{0}'")
    public static void scrollDown(int value) {
        WebPage.scroll(0, value);
    }

    @JDIAction(value="Scroll screen up on '{0}'")
    public static void scrollUp(int value) {
        WebPage.scroll(0, -value);
    }

    @JDIAction(value="Scroll screen to the right on '{0}'")
    public static void scrollRight(int value) {
        WebPage.scroll(value, 0);
    }

    @JDIAction(value="Scroll screen to the left on '{0}'")
    public static void scrollLeft(int value) {
        WebPage.scroll(-value, 0);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static double zoomLevel() {
        return JsonUtils.getDouble(WebDriverFactory.jsExecute("return window.devicePixelRatio;", new Object[0]));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static long xOffset() {
        return (Long)WebDriverFactory.jsExecute("return window.pageXOffset;", new Object[0]);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static long yOffset() {
        return (Long)WebDriverFactory.jsExecute("return window.pageYOffset;", new Object[0]);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String windowScreenshot() {
        try {
            File screenshot = (File)((TakesScreenshot)WebDriverFactory.getDriver()).getScreenshotAs(OutputType.FILE);
            String path = PathUtils.mergePath((String)ScreenshotMaker.getPath(), (String[])new String[]{WebPage.getCurrentPage() + ".png"});
            File imageFile = new File(path);
            FileUtils.copyFile((File)screenshot, (File)imageFile);
            return path;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't take screenshot", new Object[0]);
        }
    }

    @JDIAction(level=LogLevels.DEBUG)
    public static String windowScreenshot(int x, int y, int w, int h, String name) {
        File imageFile;
        String path;
        File screenshot;
        try {
            screenshot = (File)((TakesScreenshot)WebDriverFactory.getDriver()).getScreenshotAs(OutputType.FILE);
            path = PathUtils.mergePath((String)ScreenshotMaker.getPath(), (String[])new String[]{name});
            imageFile = new File(path);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't take windowScreenshot", new Object[0]);
        }
        try {
            BufferedImage fullImg = ImageIO.read(screenshot);
            BufferedImage crop = fullImg.getSubimage(x, y, w, h);
            ImageIO.write((RenderedImage)crop, "png", screenshot);
            FileUtils.copyFile((File)screenshot, (File)imageFile);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't crop windowScreenshot", new Object[0]);
        }
        return path;
    }

    public String toString() {
        return (String)SwitchActions.Switch((Object)((Object)JDISettings.LOGS.logLevel)).get(new CaseR[]{SwitchActions.Case(l -> l == LogLevels.STEP, l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_PAGE_STEP, (Object)this)), SwitchActions.Case(l -> l == LogLevels.INFO, l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_PAGE_INFO, (Object)this)), SwitchActions.Default((Object)StringUtils.msgFormat((String)OutputTemplates.PRINT_PAGE_DEBUG, (Object)this))});
    }

    public static void beforeNewPage(WebPage page) {
        if (WebSettings.VISUAL_PAGE_STRATEGY == VisualCheckPage.CHECK_NEW_PAGE) {
            WebPage.visualWindowCheck();
        }
        if (JDISettings.LOGS.screenStrategy.contains((Object)Strategy.NEW_PAGE)) {
            AllureLogger.createAttachment(page.getName(), false);
        }
        WebSettings.logger.toLog("Page '" + page.getName() + "' opened");
        JDISettings.TIMEOUTS.element.set(JDISettings.TIMEOUTS.page.get());
    }

    public static void beforeEachPage(WebPage page) {
        if (JDISettings.PAGE.checkPageOpen != PageChecks.NONE) {
            page.checkOpened();
        }
    }

    public static class StringCheckType {
        private Supplier<String> actual;
        private String equals;
        private String what;

        StringCheckType(Supplier<String> actual, String equals, String what) {
            this.actual = actual;
            this.equals = equals;
            this.what = what;
        }

        public boolean check() {
            String value = this.actual.get();
            return this.equals == null || this.equals.equals("") || value.equals(this.equals);
        }

        public boolean match() {
            String value = this.actual.get();
            return this.equals == null || this.equals.equals("") || value.matches(this.equals);
        }

        public boolean contains() {
            String value = this.actual.get();
            return this.equals == null || this.equals.equals("") || value.contains(this.equals);
        }
    }
}

