/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.composite;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.FormFilters;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.UIUtils;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.composite.Section;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.base.IClickable;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.elements.interfaces.base.SetValue;
import com.epam.jdi.light.elements.pageobjects.annotations.Mandatory;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JAction4;
import com.epam.jdi.tools.func.JFunc3;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Form<T>
extends Section {
    public static JAction4<Field, Object, Object, String> FILL_ACTION = (field, element, parent, setValue) -> ((SetValue)element).setValue((String)setValue);
    public static JFunc3<Field, Object, Object, String> GET_ACTION = (field, element, parent) -> ((HasValue)element).getValue().trim();
    private FormFilters filter = FormFilters.ALL;
    private Object pageObject = this;

    public void fillAction(Field field, Object element, Object parent, String setValue) {
        WebSettings.logger.debug("Fill element '%s' with value '%s'", this.getFieldName(field, element), setValue);
        FILL_ACTION.execute((Object)field, element, parent, (Object)setValue);
    }

    public String getAction(Field field, Object element, Object parent) {
        WebSettings.logger.debug("Try to get element '%s' value", this.getFieldName(field, element));
        return (String)GET_ACTION.execute((Object)field, element, parent);
    }

    private String getFieldName(Field field, Object element) {
        return field != null ? field.getName() : (element != null ? element.toString() : "");
    }

    public FormFilters getFilter() {
        return this.filter;
    }

    public void setFilterAll() {
        this.filter = FormFilters.ALL;
    }

    public void setFilter(FormFilters filter) {
        this.filter = filter;
    }

    private String elementLocator(UIElement element) {
        try {
            return element.locator.toString();
        }
        catch (Exception ex) {
            return "Failed get locator";
        }
    }

    public void fill(MapArray<String, String> map) {
        List<Field> allFields = this.allFields();
        if (allFields.size() == 0) {
            for (Pair pair : map) {
                UIElement element = new UIElement();
                try {
                    element = new UIElement().setup((JAction1<JDIBase>)((JAction1)e -> e.setName((String)pair.key).setParent(this)));
                    this.fillAction(null, element, this.pageObject, (String)pair.value);
                }
                catch (Exception ex) {
                    throw Exceptions.exception(ex, "Failed to fill element '%s' (locator: %s) with value '%s'", pair.key, this.elementLocator(element), pair.value);
                }
            }
            return;
        }
        for (Pair pair : map) {
            Field setField = null;
            try {
                setField = (Field)LinqUtils.first(allFields, f -> StringUtils.namesEqual((String)((String)pair.key), (String)WebAnnotationsUtil.getElementName(f)));
                if (setField == null) continue;
                this.fillAction(setField, ReflectionUtils.getValueField((Field)setField, (Object)this.pageObject), this.pageObject, (String)pair.value);
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Can't fill element '%s' with value '%s'", pair.key, pair.value);
            }
        }
        this.setFilterAll();
    }

    public Form<T> setPageObject(Object obj) {
        this.pageObject = obj;
        return this;
    }

    public List<Field> allFields() {
        return this.allFields(this.pageObject);
    }

    public List<Field> allFields(Object obj) {
        switch (this.getFilter()) {
            case MANDATORY: {
                return LinqUtils.where((Collection)ReflectionUtils.getFields((Object)obj, (Class[])new Class[]{SetValue.class}), field -> WebAnnotationsUtil.hasAnnotation(field, Mandatory.class));
            }
            case OPTIONAL: {
                return LinqUtils.where((Collection)ReflectionUtils.getFields((Object)obj, (Class[])new Class[]{SetValue.class}), field -> !WebAnnotationsUtil.hasAnnotation(field, Mandatory.class));
            }
        }
        return ReflectionUtils.getFieldsInterfaceOf((Object)obj, (Class[])new Class[]{SetValue.class});
    }

    public Form<T> onlyMandatory() {
        this.setFilter(FormFilters.MANDATORY);
        return this;
    }

    public Form<T> onlyOptional() {
        this.setFilter(FormFilters.OPTIONAL);
        return this;
    }

    @JDIAction(value="Fill '{name}' with {0}")
    public void fill(T entity) {
        this.fill((T)UIUtils.getMapFromObject(entity));
    }

    protected List<String> verify(MapArray<String, String> map) {
        ArrayList<String> compareFalse = new ArrayList<String>();
        for (Field field : this.allFields()) {
            String actual;
            String fieldValue = (String)map.firstValue((name, value) -> StringUtils.namesEqual((String)name, (String)WebAnnotationsUtil.getElementName(field)));
            if (fieldValue == null || (actual = this.getAction(field, ReflectionUtils.getValueField((Field)field, (Object)this.pageObject), this.pageObject)).equals(fieldValue)) continue;
            compareFalse.add(String.format("Field '%s' (Actual: '%s' <> Expected: '%s')", field.getName(), actual, fieldValue));
        }
        this.setFilterAll();
        return compareFalse;
    }

    @JDIAction(value="Verify that '{name}' values are: {0}", timeout=0)
    public List<String> verify(T entity) {
        return this.verify((T)UIUtils.getMapFromObject(entity));
    }

    @JDIAction(value="Check that '{name}' values are: {0}", timeout=0, isAssert=true)
    public void check(MapArray<String, String> map) {
        List<String> result = this.verify((T)map);
        if (result.size() != 0) {
            throw Exceptions.exception("Check form failed:" + StringUtils.LINE_BREAK + PrintUtils.print(result, (String)StringUtils.LINE_BREAK), new Object[0]);
        }
    }

    public void check(T entity) {
        this.check((T)UIUtils.getMapFromObject(entity));
    }

    @JDIAction(value="Submit '{name}' with value '{0}'", timeout=0)
    public void submit(String text) {
        this.submit(text, "submit");
    }

    @JDIAction(value="Submit '{name}' with value '{0}' and press '{1}' button", timeout=0)
    public void submit(String text, String buttonName) {
        List fields = ReflectionUtils.getFields((Object)this.pageObject, (Class[])new Class[]{SetValue.class});
        if (fields.isEmpty()) {
            throw Exceptions.exception("Can't submit '%s' in form %s", text, this);
        }
        Field field = (Field)fields.get(0);
        FILL_ACTION.execute((Object)field, ReflectionUtils.getValueField((Field)field, (Object)this.pageObject), this.pageObject, (Object)text);
        this.pressButton(buttonName);
    }

    @JDIAction(value="Submit '{name}' and press '{0}' button", timeout=0)
    public void pressButton(String buttonName) {
        IClickable button = (IClickable)UIUtils.GET_BUTTON.execute(this.pageObject, (Object)buttonName);
        button.click();
    }

    public void submit() {
        this.pressButton("submit");
    }

    @JDIAction(value="Submit '{name}' with {0}", timeout=0)
    public void submit(T entity) {
        this.submit(entity, "submit");
    }

    @JDIAction(value="Fill '{name}' with {0} and press '{1}'", timeout=0)
    public void submit(T entity, String buttonName) {
        this.submit(UIUtils.getMapFromObject(entity), buttonName);
    }

    protected void submit(MapArray<String, String> objStrings, String name) {
        this.fill((T)objStrings);
        this.pressButton(name);
    }

    @JDIAction(value="Submit '{name}' with {0}", timeout=0)
    public void submit(MapArray<String, String> objStrings) {
        this.submit(objStrings, "submit");
    }

    @JDIAction(value="Login as {0}", timeout=0)
    public void login(T entity) {
        this.submit(entity, "login");
    }

    @JDIAction(value="Login")
    public void login() {
        this.pressButton("login");
    }

    @JDIAction(value="Login as {0}", timeout=0)
    public void loginAs(T entity) {
        this.login(entity);
    }

    @JDIAction(value="Send {0} in '{name}'", timeout=0)
    public void send(T entity) {
        this.submit(entity, "send");
    }

    @JDIAction(value="Send '{name}'", timeout=0)
    public void send() {
        this.pressButton("send");
    }

    @JDIAction(value="Add {0} in '{name}'", timeout=0)
    public void add(T entity) {
        this.submit(entity, "add");
    }

    @JDIAction(value="Publish {0} for '{name}'", timeout=0)
    public void publish(T entity) {
        this.submit(entity, "publish");
    }

    @JDIAction(value="Save {0} in '{name}'", timeout=0)
    public void save(T entity) {
        this.submit(entity, "save");
    }

    @JDIAction(value="Update {0} in '{name}'", timeout=0)
    public void update(T entity) {
        this.submit(entity, "update");
    }

    @JDIAction(value="Fill {0} and cancel '{name}'", timeout=0)
    public void cancel(T entity) {
        this.submit(entity, "cancel");
    }

    @JDIAction(value="Fill {0} and close '{name}'", timeout=0)
    public void close(T entity) {
        this.submit(entity, "close");
    }

    @JDIAction(value="Fill '{name}' with {0} and go back", timeout=0)
    public void back(T entity) {
        this.submit(entity, "back");
    }

    @JDIAction(value="Select {0} for '{name}'", timeout=0)
    public void select(T entity) {
        this.submit(entity, "select");
    }

    @JDIAction(value="Fill '{name}' with {0} and go to next", timeout=0)
    public void next(T entity) {
        this.submit(entity, "next");
    }

    @JDIAction(value="Search for {0} in '{name}'", timeout=0)
    public void search(T entity) {
        this.submit(entity, "search");
    }

    @JDIAction(value="Create {0} in '{name}'", timeout=0)
    public void create(T entity) {
        this.submit(entity, "create");
    }

    @Override
    public boolean isDisplayed() {
        try {
            if (this.core().isDisplayed()) {
                return true;
            }
            if (this.base().locator.isNull()) {
                List fields = ReflectionUtils.getFieldsInterfaceOf((Object)this.pageObject, (Class[])new Class[]{HasValue.class});
                if (fields.isEmpty()) {
                    return false;
                }
                Object po = ((Field)fields.get(0)).get(this.pageObject);
                return ReflectionUtils.isInterface(po.getClass(), ICoreElement.class) && ((ICoreElement)po).core().isDisplayed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @JDIAction(value="Return if form valid")
    public boolean isValid() {
        Object res = this.core().js().executeScript("return arguments[0].checkValidity()", new Object[]{this.core().get()});
        return (Boolean)res;
    }
}

