/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.IList;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.Timer;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.map.MultiMap;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.WebElement;

public class Line
implements IList<String>,
IBaseElement {
    private JFunc<MultiMap<String, String>> dataMap;
    private WebList elements;
    private List<String> headers;
    private MultiMap<String, String> data;
    private List<String> list;

    @Override
    public JDIBase base() {
        return this.elements.base();
    }

    public Line() {
    }

    public Line(List<String> headers, WebList elements) {
        this.elements = elements;
        this.headers = headers;
        List<String> values = elements.values();
        this.dataMap = () -> new MultiMap(headers, values).ignoreKeyCase();
    }

    public static Line initLine(List<String> list, List<String> headers) {
        Line line = new Line();
        line.list = new ArrayList<String>(list);
        line.headers = new ArrayList<String>(headers);
        return line;
    }

    private List<String> getList(int minAmount) {
        if (this.list == null || this.list.size() < minAmount) {
            this.list = this.getData(minAmount).values();
        }
        return this.list;
    }

    @Override
    public String get(String value) {
        int index = this.headers.indexOf(value);
        return this.getList(index + 1).get(index);
    }

    private MultiMap<String, String> getData(int minAmount) {
        if (this.data == null || this.data.size() < minAmount) {
            this.data = (MultiMap)this.dataMap.execute();
        }
        return this.data;
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public List<String> elements(int minAmount) {
        return this.getData(minAmount).values();
    }

    public MultiMap<String, UIElement> uiElements() {
        return new MultiMap(this.headers, (List)this.elements.indexFromZero()).ignoreKeyCase();
    }

    public void saveCellsImages() {
        String unique = Timer.nowMSecs();
        ArrayList<UIElement> result = new ArrayList<UIElement>();
        for (int i = 0; i < this.elements.size(); ++i) {
            UIElement cell = this.elements.get(i + 1);
            cell.show();
            cell.varName = this.headers.get(i) + unique;
            cell.makePhoto();
            result.add(cell);
        }
        this.elements = new WebList(this.headers, result);
    }

    public boolean visualCompareTo(Line line) {
        for (Pair cell : this.uiElements()) {
            try {
                ((UIElement)cell.value).visualValidation((UIElement)line.uiElements().get((Object)((String)cell.key)));
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getValue() {
        return PrintUtils.print(this.getList(0), (String)";");
    }

    public String print() {
        return this.getValue();
    }

    @Override
    public void clear() {
        this.data = null;
    }

    private <T> T getType(String methodName, Class<T> cl, JFunc1<T, T> setupInstance) {
        Object instance;
        try {
            instance = ReflectionUtils.create(cl);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, methodName + ": Can't convert row to Entity (%s)", cl.getSimpleName());
        }
        return (T)setupInstance.execute(instance);
    }

    public <D> D asData(Class<D> data) {
        return this.getType("asData", data, instance -> Line.getInstance(this, data, this.headers, instance));
    }

    public <D> D asData(Class<D> data, MapArray<String, String> line) {
        return this.getType("asDataLine", data, instance -> Line.getLineInstance(instance, line));
    }

    protected static <D> D getInstance(Line line, Class<D> data, List<String> headers, D instance) {
        int i = 0;
        List<Field> fields = Arrays.asList(data.getDeclaredFields());
        for (String name : headers) {
            Field field = (Field)LinqUtils.first(fields, f -> StringUtils.namesEqual((String)WebAnnotationsUtil.getElementName(f), (String)name));
            if (field != null) {
                try {
                    StringUtils.setPrimitiveField((Field)field, instance, (String)line.getList(i).get(i));
                }
                catch (Exception ex) {
                    throw Exceptions.exception(ex, "Can't set table value '%s' to field '%s'", line.getData(i).get(i), field.getName());
                }
            }
            ++i;
        }
        return instance;
    }

    protected static <D> D getLineInstance(D instance, MapArray<String, String> line) {
        for (Pair cell : line) {
            Field field = (Field)LinqUtils.first((Object[])instance.getClass().getDeclaredFields(), f -> StringUtils.namesEqual((String)WebAnnotationsUtil.getElementName(f), (String)((String)cell.key)));
            if (field == null) continue;
            try {
                StringUtils.setPrimitiveField((Field)field, instance, (String)((String)cell.value));
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "asDataLine: Can't set table entity to field '%s'", field.getName());
            }
        }
        return instance;
    }

    public <T> T asLine(Class<T> cl) {
        return this.getType("asLine", cl, instance -> {
            for (int i = 1; i <= this.headers.size(); ++i) {
                String header = this.headers.get(i - 1);
                Field field = (Field)LinqUtils.first((Object[])instance.getClass().getDeclaredFields(), f -> StringUtils.namesEqual((String)WebAnnotationsUtil.getElementName(f), (String)header));
                if (field == null) continue;
                try {
                    IBaseElement ui = (IBaseElement)field.get(instance);
                    UIElement listElement = this.elements.get(i);
                    WebElement element = ui.base().hasLocator() ? listElement.findElement(ui.base().getLocator(new Object[0])) : listElement.getWebElement();
                    ui.base().setWebElement(element);
                    continue;
                }
                catch (Exception ex) {
                    throw Exceptions.exception(ex, "asLine: Can't set table entity to field '%s'", field.getName());
                }
            }
            return instance;
        });
    }

    public String toString() {
        return this.print();
    }

    @Override
    public boolean isUseCache() {
        return this.elements.isUseCache();
    }
}

