/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.table.DataTableAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.BaseTable;
import com.epam.jdi.light.elements.complex.table.CacheAll;
import com.epam.jdi.light.elements.complex.table.Column;
import com.epam.jdi.light.elements.complex.table.TableMatcher;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class DataTable<L extends PageObject, D>
extends BaseTable<DataTable<L, D>, DataTableAssert<L, D>> {
    protected Class<L> lineClass;
    protected Class<D> dataClass;
    protected CacheAll<MapArray<String, L>> lines = new CacheAll(MapArray::new);
    protected CacheAll<MapArray<String, D>> datas = new CacheAll(MapArray::new);

    protected void hasLineClass() {
        if (this.lineClass == null || !ReflectionUtils.isClass(this.lineClass, PageObject.class)) {
            throw Exceptions.exception("In order to use this method you must specify LineClass that extends PageObject for '%s' DataTable<LineClass, ?>", this.getName());
        }
    }

    protected void hasDataClass() {
        if (this.dataClass == null) {
            throw Exceptions.exception("In order to use this method you must specify DataClass for '%s' DataTable<?, DataClass>", this.getName());
        }
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public D dataRow(int rowNum) {
        this.hasDataClass();
        if (((MapArray)this.datas.get()).has((Object)(rowNum + ""))) {
            return (D)((MapArray)this.datas.get()).get((Object)(rowNum + ""));
        }
        D data = this.lineClass != null ? this.lineToData(this.line(rowNum)) : this.row(rowNum).asData(this.dataClass);
        ((MapArray)this.datas.get()).update((Object)(rowNum + ""), data);
        return data;
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public L line(int rowNum) {
        this.hasLineClass();
        if (((MapArray)this.lines.get()).has((Object)(rowNum + ""))) {
            return (L)((PageObject)((MapArray)this.lines.get()).get((Object)(rowNum + "")));
        }
        PageObject value = (PageObject)this.row(rowNum).asLine(this.lineClass);
        ((MapArray)this.lines.get()).update((Object)(rowNum + ""), (Object)value);
        return (L)value;
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public D dataRow(String rowName) {
        this.hasDataClass();
        return this.dataRow(this.getRowIndexByName(rowName));
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public L line(String rowName) {
        this.hasLineClass();
        return this.line(this.getRowIndexByName(rowName));
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public D dataRow(Enum rowName) {
        this.hasDataClass();
        return this.dataRow(EnumUtils.getEnumValue((Enum)rowName));
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public L line(Enum rowName) {
        this.hasLineClass();
        return this.line(EnumUtils.getEnumValue((Enum)rowName));
    }

    @JDIAction(value="Get first '{name}' table row that match criteria")
    public D dataRow(TableMatcher ... matchers) {
        this.hasDataClass();
        return this.row(matchers).asData(this.dataClass);
    }

    @JDIAction(value="Get first '{name}' table row that match criteria")
    public L line(TableMatcher ... matchers) {
        this.hasLineClass();
        return (L)((PageObject)this.row(matchers).asLine(this.lineClass));
    }

    @JDIAction(value="Get first '{name}' table row that match criteria")
    public D dataRow(JFunc1<D, Boolean> matcher) {
        this.hasDataClass();
        for (int i = 1; i <= this.count(); ++i) {
            D data = this.dataRow(i);
            if (!((Boolean)matcher.execute(data)).booleanValue()) continue;
            return data;
        }
        return null;
    }

    @JDIAction(value="Get first '{name}' table row that match criteria")
    public L line(JFunc1<D, Boolean> matcher) {
        this.hasLineClass();
        for (int i = 1; i <= this.count(); ++i) {
            if (!((Boolean)matcher.execute(this.dataRow(i))).booleanValue()) continue;
            return this.line(i);
        }
        return null;
    }

    @JDIAction(value="Get all '{name}' table rows that match criteria")
    public List<D> dataRows(JFunc1<D, Boolean> matcher) {
        this.hasDataClass();
        return LinqUtils.filter(this.allData(), arg_0 -> matcher.execute(arg_0));
    }

    @JDIAction(value="Get at least {1} '{name}' table rows that match criteria")
    public List<D> dataRows(JFunc1<D, Boolean> matcher, int amount) {
        this.hasDataClass();
        ArrayList<D> result = new ArrayList<D>();
        for (int i = 1; i <= this.count(); ++i) {
            if (((Boolean)matcher.execute(this.dataRow(i))).booleanValue()) {
                result.add(this.dataRow(i));
            }
            if (result.size() != amount) continue;
            return result;
        }
        return result;
    }

    @JDIAction(value="Get first '{name}' table row that match criteria")
    public List<L> lines(JFunc1<D, Boolean> matcher) {
        this.hasLineClass();
        return LinqUtils.ifSelect(this.rows(), r -> (Boolean)matcher.execute(r.asData(this.dataClass)), r -> (PageObject)r.asLine(this.lineClass));
    }

    @JDIAction(value="Get all '{name}' table rows that match criteria")
    public List<D> dataRows(TableMatcher ... matchers) {
        this.hasDataClass();
        if (matchers.length == 0) {
            return this.allData();
        }
        return LinqUtils.map(this.rows(matchers), r -> r.asData(this.dataClass));
    }

    @JDIAction(value="Get all '{name}' table rows that match criteria")
    public List<L> lines(TableMatcher ... matchers) {
        this.hasLineClass();
        return LinqUtils.map(this.rows(matchers), l -> (PageObject)l.asLine(this.lineClass));
    }

    @JDIAction(value="Get all '{name}' rows")
    public List<D> allData() {
        this.hasDataClass();
        if (this.datas.isGotAll()) {
            return ((MapArray)this.datas.get()).values();
        }
        MapArray result = new MapArray();
        for (int i = 1; i <= this.count(); ++i) {
            result.update((Object)(i + ""), this.dataRow(i));
        }
        this.datas.gotAll();
        return ((MapArray)this.datas.set(result)).values();
    }

    @JDIAction(value="Get all '{name}' rows")
    public List<L> allLines() {
        this.hasLineClass();
        if (this.lines.isGotAll()) {
            return ((MapArray)this.lines.get()).values();
        }
        MapArray result = new MapArray();
        for (int i = 1; i <= this.count(); ++i) {
            result.add((Object)(i + ""), this.line(i));
        }
        this.lines.gotAll();
        return ((MapArray)this.lines.set(result)).values();
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria in column '{1}'")
    public List<D> filterData(Matcher<String> matcher, Column column) {
        this.hasDataClass();
        return LinqUtils.map(this.filterRows(matcher, column), r -> r.asData(this.dataClass));
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria in column '{1}'")
    public List<L> filterLines(Matcher<String> matcher, Column column) {
        this.hasLineClass();
        return LinqUtils.map(this.filterRows(matcher, column), l -> (PageObject)l.asLine(this.lineClass));
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria")
    public List<D> filterDatas(Pair<Matcher<String>, Column> ... matchers) {
        this.hasDataClass();
        return LinqUtils.map(this.filterRows(matchers), r -> r.asData(this.dataClass));
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria")
    public List<L> filterLines(Pair<Matcher<String>, Column> ... matchers) {
        this.hasLineClass();
        return LinqUtils.map(this.filterRows(matchers), l -> (PageObject)l.asLine(this.lineClass));
    }

    @JDIAction(value="Get '{name}' table row that match criteria in column '{1}'")
    public D dataRow(Matcher<String> matcher, Column column) {
        this.hasDataClass();
        return this.row(matcher, column).asData(this.dataClass);
    }

    @JDIAction(value="Get '{name}' table row that match criteria in column '{1}'")
    public L line(Matcher<String> matcher, Column column) {
        this.hasLineClass();
        return (L)((PageObject)this.row(matcher, column).asLine(this.lineClass));
    }

    @JDIAction(value="Get '{name}' table row that match criteria")
    public D dataRow(Pair<Matcher<String>, Column> ... matchers) {
        this.hasDataClass();
        return this.row(matchers).asData(this.dataClass);
    }

    @JDIAction(value="Get '{name}' table row that match criteria")
    public L line(Pair<Matcher<String>, Column> ... matchers) {
        this.hasLineClass();
        return (L)((PageObject)this.row(matchers).asLine(this.lineClass));
    }

    public <C extends HasValue> List<C> columnValues(String columnName, Class<C> cl) {
        WebList column = this.webColumn(columnName);
        List result = column.map(el -> (HasValue)el.asEntity(cl));
        return result;
    }

    @Override
    @JDIAction(value="Get '{name}' table value")
    public String getValue() {
        if (this.dataClass == null && this.lineClass == null) {
            super.getValue();
        }
        this.getTable();
        String value = "||X||" + PrintUtils.print((Collection)((Collection)this.header.get()), (String)"|") + "||" + StringUtils.LINE_BREAK;
        List rows = this.dataClass != null ? LinqUtils.map(this.allData(), l -> l) : LinqUtils.map(this.allLines(), l -> l);
        List fields = LinqUtils.map((Collection)rows, d -> ReflectionUtils.getFieldsExact(d.getClass()));
        for (int i = 1; i <= this.count(); ++i) {
            ArrayList<String> list = new ArrayList<String>();
            for (String h : this.header()) {
                Field field = (Field)LinqUtils.first((Collection)((Collection)fields.get(i - 1)), f -> ((String)this.SIMPLIFY.execute((Object)h)).equals(this.SIMPLIFY.execute((Object)f.getName())));
                if (field == null) continue;
                try {
                    Object fieldObj = field.get(rows.get(i - 1));
                    String val = ReflectionUtils.isInterface(field.getType(), HasValue.class) ? ((HasValue)fieldObj).getValue() : fieldObj.toString();
                    list.add(val);
                }
                catch (Exception ex) {
                    throw Exceptions.exception(ex, "Can't get field %s", field.getName());
                }
            }
            value = value + "||" + i + "||" + PrintUtils.print((Collection)LinqUtils.map(list, arg_0 -> ((JFunc1)TRIM_VALUE).execute(arg_0)), (String)"|") + "||" + StringUtils.LINE_BREAK;
        }
        return value;
    }

    protected D lineToData(L line) {
        Field[] lineFields;
        Object instance;
        try {
            instance = ReflectionUtils.create(this.dataClass);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't create %s instance in lineToData(line)", this.dataClass.getSimpleName());
        }
        Field[] dataFields = instance.getClass().getDeclaredFields();
        for (Field lineField : lineFields = line.getClass().getDeclaredFields()) {
            for (Field dataField : dataFields) {
                Object lineFieldValue;
                if (!StringUtils.namesEqual((String)WebAnnotationsUtil.getElementName(lineField), (String)WebAnnotationsUtil.getElementName(dataField))) continue;
                try {
                    lineFieldValue = lineField.get(line);
                }
                catch (Exception ex) {
                    throw Exceptions.exception(ex, "Can't get lineField '%s' value", lineField.getName());
                }
                String value = ReflectionUtils.isInterface(lineField.getType(), HasValue.class) ? ((HasValue)lineFieldValue).getValue() : lineFieldValue.toString();
                try {
                    StringUtils.setPrimitiveField((Field)dataField, (Object)instance, (String)value);
                }
                catch (Exception ex) {
                    throw Exceptions.exception(ex, "Can't set table value '%s' to field '%s'", value, dataField.getName());
                }
            }
        }
        return (D)instance;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.datas.clear();
        this.lines.clear();
    }

    @Override
    public void offCache() {
        super.offCache();
        this.datas.useCache(false);
        this.lines.useCache(false);
    }

    protected void setupGenericFields(Field field) {
        Type[] types = ReflectionUtils.getGenericTypes((Field)field);
        if (types.length != 2) {
            return;
        }
        try {
            this.lineClass = types[0].toString().equals("?") ? null : (Class)types[0];
            this.dataClass = types[1].toString().equals("?") ? null : (Class)types[1];
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get DataTable %s data or entity class", this.getName());
        }
    }

    @Override
    public void setup(Field field) {
        super.setup(field);
        try {
            this.setupGenericFields(field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.header.hasValue()) {
            return;
        }
        ArrayList<Field> entityFields = new ArrayList<Field>();
        if (this.lineClass != null) {
            entityFields.addAll(ReflectionUtils.getFieldsExact(this.lineClass, f -> ReflectionUtils.isInterface((Field)f, HasValue.class)));
        }
        if (this.dataClass != null) {
            entityFields.addAll(Arrays.asList(this.dataClass.getDeclaredFields()));
        }
        if (entityFields.size() > 0) {
            List headers = LinqUtils.map(entityFields, field1 -> StringUtils.splitCamelCase((String)field1.getName())).stream().distinct().collect(Collectors.toList());
            this.header.setFinal(headers);
            if (!this.size.hasValue()) {
                this.size.setFinal((Object)headers.size());
            }
        }
    }

    @Override
    public DataTableAssert<L, D> is() {
        return (DataTableAssert)new DataTableAssert().set(this);
    }

    public DataTableAssert<L, D> is(Matcher<? super List<D>> condition) {
        MatcherAssert.assertThat(this.allData(), condition);
        return this.is();
    }

    public DataTableAssert<L, D> assertThat(Matcher<? super List<D>> condition) {
        return this.is(condition);
    }

    public DataTableAssert<L, D> verify(Matcher<? super List<D>> condition) {
        SoftAssert.assertSoft();
        return this.is(condition);
    }
}

