/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table;

import com.epam.jdi.light.asserts.generic.HasAssert;
import com.epam.jdi.light.asserts.generic.table.BaseTableAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.IHasSize;
import com.epam.jdi.light.elements.complex.ISetup;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.CacheAll;
import com.epam.jdi.light.elements.complex.table.Column;
import com.epam.jdi.light.elements.complex.table.Line;
import com.epam.jdi.light.elements.complex.table.TableMatcher;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.HasRefresh;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.common.IsText;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.JTable;
import com.epam.jdi.light.elements.pageobjects.annotations.objects.FillFromAnnotationRules;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class BaseTable<T extends BaseTable<?, ?>, A extends BaseTableAssert<?, ?>>
extends UIBaseElement<A>
implements ISetup,
HasValue,
HasAssert<A>,
IHasSize,
IsText,
HasRefresh {
    protected By rowLocator = By.xpath((String)"//tr[%s]/td");
    protected By columnLocator = By.xpath((String)"//tr/td[%s]");
    protected By cellLocator = By.xpath((String)"//tr[{1}]/td[{0}]");
    protected By allCellsLocator = By.cssSelector((String)"td");
    protected By jsRow = By.cssSelector((String)"tr");
    protected By jsColumn = By.cssSelector((String)"td");
    protected By headerLocator = By.cssSelector((String)"th");
    protected By footer = By.cssSelector((String)"tfoot");
    protected By fromCellToRow = By.xpath((String)"../td");
    protected By filterLocator = By.cssSelector((String)"th input[type=search],th input[type=text]");
    protected int rowHeaderIndex = -1;
    protected int firstColumnIndex = -1;
    protected int firstRowIndex = -1;
    protected int[] columnsMapping = new int[0];
    protected String rowHeaderName = "";
    protected CacheAll<MapArray<String, WebList>> rows = new CacheAll(MapArray::new);
    protected CacheAll<MapArray<String, WebList>> columns = new CacheAll(MapArray::new);
    protected CacheAll<MapArray<String, MapArray<String, UIElement>>> cells = new CacheAll(MapArray::new);
    protected CacheAll<MapArray<String, MapArray<String, String>>> cellsValues = new CacheAll(MapArray::new);
    protected CacheValue<Integer> count = new CacheValue(this::getCount);
    protected CacheValue<List<String>> header = new CacheValue(this::getHeader);
    protected CacheValue<List<String>> rowHeader = new CacheValue(this::getRowHeader);
    protected CacheValue<Integer> size = new CacheValue(this::getTableSize);
    public JFunc1<String, String> SIMPLIFY = JDIBase.STRING_SIMPLIFY;
    protected Boolean headerIsRow = null;
    public static JFunc1<String, String> TRIM_VALUE = el -> el.trim().replaceAll("\n", "\\\\n").replaceAll(" +", " ");
    public static JFunc1<String, String> TRIM_PREVIEW = el -> el.trim().replaceAll("\n", " ").replaceAll(" +", " ");

    protected int getRowHeaderIndex() {
        if (this.rowHeaderIndex == -1 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.rowHeaderName)) {
            int index = LinqUtils.firstIndex(this.header(), h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)this.rowHeaderName)));
            if (index > -1) {
                this.rowHeaderIndex = index + 1;
            } else {
                throw Exceptions.exception("Can't find rowHeader '%s' in 'header' [%s]. Please correct JTable params", this.rowHeaderName, PrintUtils.print(this.header()));
            }
        }
        return this.rowHeaderIndex;
    }

    public void setHeader(List<String> header) {
        this.header.setFinal(header);
    }

    public WebList headerUI() {
        WebList header = UIFactory.$$(this.headerLocator, (Object)this).setName(this.getName() + " header");
        if (header.size() == 0) {
            header = this.getRowByIndex(1);
            if (header.size() > 0) {
                this.header.setRule(() -> this.getRowByIndex(1).values());
                this.size.setRule(() -> this.getRowByIndex(1).size());
            } else {
                throw Exceptions.exception("Can't find header using locator '%s'. Please specify JTable.headers locator or set JTable.header list", new Object[0]);
            }
        }
        return header.setName(this.getName() + " header");
    }

    public WebList footerUI() {
        WebList footer = UIFactory.$$(this.footer, (Object)this).setName(this.getName() + " footer");
        if (footer.size() == 0 && (footer = this.getRowByIndex(1)).size() == 0) {
            throw Exceptions.exception("Can't find footer using locator '%s'. Please specify JTable.footer locator", new Object[0]);
        }
        return footer.setName(this.getName() + " header");
    }

    protected List<String> getHeader() {
        return this.headerUI().values();
    }

    @JDIAction(value="Get {name} header")
    public List<String> header() {
        return (List)this.header.get();
    }

    protected List<String> getRowHeader() {
        int index = this.getRowHeaderIndex();
        return index != -1 ? this.namedHeader(index) : this.namedHeader(1);
    }

    protected List<String> namedHeader(int index) {
        return this.webColumn(index).values();
    }

    public List<String> rowHeader() {
        return (List)this.rowHeader.get();
    }

    protected int getCount() {
        if (((MapArray)this.columns.get()).any()) {
            return ((WebList)((MapArray)this.columns.get()).get((int)0).value).size();
        }
        int rowsCount = UIFactory.$$(WebDriverByUtils.fillByTemplate(this.columnLocator, this.getRowIndex()), (Object)this).getListFast().size();
        return this.headerSameAsFirstRow() ? rowsCount - 1 : rowsCount;
    }

    @JDIAction(value="Get {name} rows count")
    public int count() {
        return (Integer)this.count.get();
    }

    protected int getTableSize() {
        if (this.header.hasValue()) {
            return ((List)this.header.get()).size();
        }
        WebList header = this.headerUI().noValidation();
        return header.size();
    }

    @Override
    public int size() {
        return (Integer)this.size.get();
    }

    public WebList webRow(int rowNum) {
        this.validateRowIndex(rowNum);
        if (((MapArray)this.rows.get()).has((Object)(rowNum + ""))) {
            return (WebList)((MapArray)this.rows.get()).get((Object)(rowNum + ""));
        }
        WebList result = this.cells.isGotAll() ? new WebList(LinqUtils.select((Collection)((Collection)this.cells.get()), c -> (WebElement)((MapArray)c.value).get((Object)(rowNum + "")))) : this.getRow(rowNum);
        ((MapArray)this.rows.get()).update((Object)(rowNum + ""), (Object)result);
        return result;
    }

    protected void validateRowIndex(int rowNum) {
        if (rowNum < 1) {
            throw Exceptions.exception("Rows numeration starts from 1 (but requested index is %s)", rowNum);
        }
        if (rowNum > this.count()) {
            boolean gotAll = this.cells.isGotAll();
            ((BaseTableAssert)this.waitFor()).size((Matcher<Integer>)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(rowNum)));
            if (rowNum > this.count()) {
                throw Exceptions.exception("Table has %s rows (but requested index is %s)", this.count(), rowNum);
            }
            if (gotAll) {
                this.cells.clear();
            }
        }
    }

    public WebList webRow(int columnIndex, String rowName) {
        return this.webColumn(columnIndex).get(this.jsRowIndexByName(rowName)).finds(this.fromCellToRow);
    }

    public WebList webRow(String rowName) {
        return this.webRow(this.getRowIndex(), rowName);
    }

    protected int getRowIndex() {
        int headerIndex = this.getRowHeaderIndex();
        return headerIndex == -1 ? 1 : headerIndex;
    }

    public WebList webRow(Enum rowName) {
        return this.webRow(EnumUtils.getEnumValue((Enum)rowName));
    }

    public WebList webColumn(int colNum) {
        this.validateColumnIndex(colNum);
        if (((MapArray)this.columns.get()).has((Object)(colNum + ""))) {
            return (WebList)((MapArray)this.columns.get()).get((Object)(colNum + ""));
        }
        WebList result = this.cells.isGotAll() ? WebList.newList(((MapArray)((MapArray)this.cells.get()).get((Object)(colNum + ""))).values()) : this.getColumn(colNum);
        ((MapArray)this.columns.get()).update((Object)(colNum + ""), (Object)result);
        return result;
    }

    protected List<String> getJSValues(String locator) {
        List values = (List)this.core().js().executeScript("return Array.from(document.querySelectorAll(\"" + locator + "\")).map(el=>el.innerText)", new Object[0]);
        return LinqUtils.map((Collection)values, String::trim);
    }

    public List<String> jsCells() {
        return this.getJSValues(String.format("%s %s", WebDriverByUtils.getByLocator(this.base().getLocator(new Object[0])), WebDriverByUtils.getByLocator(this.jsColumn)));
    }

    public List<String> jsColumn(int columnIndex) {
        return this.getJSValues(String.format("%s %s:nth-child(%s)", WebDriverByUtils.getByLocator(this.base().getLocator(new Object[0])), WebDriverByUtils.getByLocator(this.jsColumn), this.getColumnIndex(columnIndex)));
    }

    public List<String> jsColumn(String columnName) {
        return this.jsColumn(this.getColIndexByName(columnName));
    }

    public List<String> jsRow(int rowIndex) {
        return this.getJSValues(String.format("%s %s:nth-child(%s) %s", WebDriverByUtils.getByLocator(this.base().getLocator(new Object[0])), WebDriverByUtils.getByLocator(this.jsRow), this.getRowIndex(rowIndex), WebDriverByUtils.getByLocator(this.jsColumn)));
    }

    public List<String> jsRow(String rowName) {
        return this.jsRow(this.jsRowIndexByName(rowName));
    }

    public int jsRowIndexByName(String rowName) {
        List<String> rowHeader;
        int index = this.getRowHeaderIndex();
        if (index == -1) {
            index = 1;
        }
        try {
            rowHeader = this.jsColumn(index);
            if (rowHeader.size() == 0) {
                throw new IllegalStateException();
            }
        }
        catch (Exception ex) {
            rowHeader = this.webColumn(index).values();
        }
        int rowIndex = LinqUtils.firstIndex(rowHeader, h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)rowName)));
        if (rowIndex == -1) {
            throw Exceptions.exception("Can't find row '%s'", rowName);
        }
        return rowIndex + 1;
    }

    protected void validateColumnIndex(int colNum) {
        if (colNum < 1) {
            throw Exceptions.exception("Columns numeration starts from 1 (but requested index is %s)", colNum);
        }
        if (colNum > this.size()) {
            throw Exceptions.exception("Table has %s columns (but requested index is %s)", this.size(), colNum);
        }
    }

    public WebList webColumn(String colName) {
        return this.webColumn(this.getColIndexByName(colName));
    }

    public WebList webColumn(Enum colName) {
        return this.webRow(EnumUtils.getEnumValue((Enum)colName));
    }

    protected int getColIndexByName(String colName) {
        int colIndex = LinqUtils.firstIndex((List)((List)this.header.get()), h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)colName)));
        if (colIndex == -1) {
            throw Exceptions.exception("Can't find column '%s'", colName);
        }
        return colIndex + 1;
    }

    public int getRowIndexByName(String rowName) {
        List<String> rowHeader = this.rowHeader();
        int rowIndex = LinqUtils.firstIndex(rowHeader, h -> ((String)this.SIMPLIFY.execute(h)).equals(this.SIMPLIFY.execute((Object)rowName)));
        if (rowIndex == -1) {
            throw Exceptions.exception("Can't find row '%s'", rowName);
        }
        return rowIndex + 1;
    }

    public UIElement webCell(int colNum, int rowNum) {
        this.validateColumnIndex(colNum);
        this.validateRowIndex(rowNum);
        if (this.cells.isGotAll()) {
            return (UIElement)((MapArray)((MapArray)this.cells.get()).get((Object)(colNum + ""))).get((Object)(rowNum + ""));
        }
        if (((MapArray)this.rows.get()).has((Object)(rowNum + ""))) {
            return ((WebList)((MapArray)this.rows.get()).get((Object)(rowNum + ""))).get(colNum);
        }
        if (((MapArray)this.columns.get()).has((Object)(colNum + ""))) {
            return ((WebList)((MapArray)this.columns.get()).get((Object)(colNum + ""))).get(rowNum);
        }
        if (((MapArray)this.cells.get()).has((Object)(colNum + "")) && ((MapArray)((MapArray)this.cells.get()).get((Object)(colNum + ""))).has((Object)(rowNum + ""))) {
            return (UIElement)((MapArray)((MapArray)this.cells.get()).get((Object)(colNum + ""))).get((Object)(rowNum + ""));
        }
        UIElement cell = this.getCell(colNum, rowNum);
        ((MapArray)this.cells.get()).update((Object)(colNum + ""), (Object)new MapArray((Object)(rowNum + ""), (Object)cell));
        return cell;
    }

    protected MapArray<String, WebList> getRows() {
        if (this.rows.isGotAll()) {
            return (MapArray)this.rows.get();
        }
        MapArray result = new MapArray();
        for (int i = 1; i <= this.count(); ++i) {
            result.add((Object)(i + ""), (Object)this.webRow(i));
        }
        this.rows.gotAll();
        return (MapArray)this.rows.set(result);
    }

    protected WebList getRowByIndex(int rowNum) {
        WebList row = UIFactory.$$(WebDriverByUtils.fillByTemplate(this.rowLocator, rowNum), (Object)this);
        row.searchVisible();
        return row;
    }

    public WebList getRow(int rowNum) {
        WebList row = this.getRowByIndex(this.getRowIndex(rowNum));
        return this.firstColumnIndex > 1 || this.columnsMapping.length > 0 ? this.getMappedRow(row) : row;
    }

    protected WebList getMappedRow(WebList row) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        for (int i = 1; i <= this.header().size(); ++i) {
            result.add(row.get(this.getColumnIndex(i) - 1));
        }
        return new WebList(result);
    }

    protected MapArray<String, WebList> getColumns() {
        if (this.columns.isGotAll()) {
            return (MapArray)this.columns.get();
        }
        MapArray result = new MapArray();
        for (int i = 1; i <= this.size(); ++i) {
            result.add((Object)(i + ""), (Object)this.webColumn(i));
        }
        this.columns.gotAll();
        return (MapArray)this.columns.set(result);
    }

    protected int getColumnIndex(int index) {
        if (this.firstColumnIndex > 1) {
            return index + this.firstColumnIndex - 1;
        }
        if (this.columnsMapping.length > 0) {
            return this.columnsMapping[index - 1];
        }
        return index;
    }

    public WebList getColumn(int colNum) {
        return UIFactory.$$(WebDriverByUtils.fillByTemplate(this.columnLocator, this.getColumnIndex(colNum)), (Object)this).noValidation();
    }

    public UIElement getCell(int colNum, int rowNum) {
        return UIFactory.$(WebDriverByUtils.fillByMsgTemplate(this.cellLocator, this.getColumnIndex(colNum), this.getRowIndex(rowNum)), (Object)this);
    }

    protected int getRowIndex(int rowNum) {
        if (this.firstRowIndex > 1) {
            return rowNum + this.firstRowIndex - 1;
        }
        if (this.headerIsRow == null) {
            this.headerIsRow = this.headerIsRow();
        }
        return this.headerIsRow != false ? rowNum + 1 : rowNum;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean headerIsRow() {
        void var1_3;
        ArrayList arrayList = new ArrayList();
        try {
            List list = (List)this.getRowByIndex(1).noWait(WebList::values, WebList.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (var1_3.isEmpty()) return true;
        if (!LinqUtils.any(this.header(), ((List)var1_3)::contains)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean headerSameAsFirstRow() {
        void var1_3;
        ArrayList arrayList = new ArrayList();
        try {
            List list = (List)this.getRowByIndex(1).noWait(WebList::values, WebList.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (var1_3.isEmpty()) return false;
        if (!LinqUtils.any(this.header(), ((List)var1_3)::contains)) return false;
        return true;
    }

    public WebList filter() {
        return UIFactory.$$(this.filterLocator).setup((JAction1<JDIBase>)((JAction1)b -> {
            b.setParent(this);
            b.setName(this.getName() + " filter");
        }));
    }

    public UIElement filterBy(String filterName) {
        return this.searchBy(filterName);
    }

    @JDIAction(value="Filter {name} by column {0}")
    public UIElement searchBy(String filterName) {
        int index = this.header().indexOf(filterName);
        return this.filter().get(index + 1);
    }

    @JDIAction(value="Get first '{name}' table row that match criteria")
    public Line row(TableMatcher ... matchers) {
        WebList lines = (WebList)TableMatcher.TABLE_MATCHER.execute((Object)this, (Object)matchers);
        if (lines == null || lines.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= this.header().size(); ++i) {
            result.add(lines.get(i).getText());
        }
        return Line.initLine(result, this.header());
    }

    @JDIAction(value="Get all '{name}' table rows that match criteria")
    public List<Line> rows(TableMatcher ... matchers) {
        List<String> lines = ((WebList)TableMatcher.TABLE_MATCHER.execute((Object)this, (Object)matchers)).values();
        if (lines == null || lines.size() < this.header().size()) {
            return null;
        }
        ArrayList<Line> listOfLines = new ArrayList<Line>();
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line);
            if (result.size() != this.header().size()) continue;
            listOfLines.add(Line.initLine(result, this.header()));
            result.clear();
        }
        return listOfLines;
    }

    @Override
    @JDIAction(value="Is '{name}' table empty")
    public boolean isEmpty() {
        try {
            return this.count() == 0;
        }
        catch (Exception ex) {
            return true;
        }
    }

    @Override
    @JDIAction(value="Is '{name}' table not empty")
    public boolean isNotEmpty() {
        try {
            return this.count() != 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public Line row(int rowNum) {
        return new Line(this.header(), this.webRow(rowNum));
    }

    @JDIAction(value="Get row '{0}' for '{name}' table")
    public Line row(String rowName) {
        return new Line(this.header(), this.webRow(rowName));
    }

    public Line row(Enum rowName) {
        return this.row(EnumUtils.getEnumValue((Enum)rowName));
    }

    @JDIAction(value="Get all '{name}' rows")
    public List<Line> rows() {
        return LinqUtils.map(this.getRows(), row -> new Line(this.header(), (WebList)row.value));
    }

    @JDIAction(value="Get all '{name}' rows")
    public List<Line> rowsImages() {
        MapArray<String, WebList> rows = this.getRows();
        return LinqUtils.map(rows, this::toLineSaveImages);
    }

    private Line toLineSaveImages(Pair<String, WebList> row) {
        Line line = new Line(this.header(), (WebList)row.value);
        line.saveCellsImages();
        return line;
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria in column '{1}'")
    public List<Line> filterRows(Matcher<String> matcher, Column column) {
        return LinqUtils.filter(this.rows(), line -> matcher.matches(line.get(column.getIndex(this.header()))));
    }

    @JDIAction(value="Filter '{name}' table rows that match criteria")
    public List<Line> filterRows(Pair<Matcher<String>, Column> ... matchers) {
        return LinqUtils.filter(this.rows(), line -> LinqUtils.all((Object[])matchers, m -> ((Matcher)m.key).matches(line.get(((Column)((Object)((Object)((Object)m.value)))).getIndex(this.header())))));
    }

    @JDIAction(value="Get '{name}' table row that match criteria in column '{1}'")
    public Line row(Matcher<String> matcher, Column column) {
        return (Line)LinqUtils.first(this.rows(), line -> matcher.matches(line.get(column.getIndex(this.header()))));
    }

    @JDIAction(value="Get '{name}' table row that match criteria")
    public Line row(Pair<Matcher<String>, Column> ... matchers) {
        return (Line)LinqUtils.first(this.rows(), line -> LinqUtils.all((Object[])matchers, m -> ((Matcher)m.key).matches(line.get(((Column)((Object)((Object)((Object)m.value)))).getIndex(this.header())))));
    }

    @JDIAction(value="Get column '{0}' of '{name}' table")
    public Line column(int colNum) {
        return new Line(this.rowHeader(), this.webColumn(colNum));
    }

    @JDIAction(value="Get column '{0}' of '{name}' table")
    public Line column(String colName) {
        return new Line(this.rowHeader(), this.webColumn(colName));
    }

    public Line column(Enum colName) {
        return this.column(EnumUtils.getEnumValue((Enum)colName));
    }

    @JDIAction(value="Get all '{name}' columns")
    public List<Line> columns() {
        return LinqUtils.map(this.getColumns(), row -> new Line(this.rowHeader(), (WebList)row.value));
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(int colNum, int rowNum) {
        return this.webCell(colNum, rowNum).getText();
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(String colName, int rowNum) {
        return this.cell(this.getColIndexByName(colName), rowNum);
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(int colNum, String rowName) {
        this.validateColumnIndex(colNum);
        return this.webRow(rowName).get(colNum).getText();
    }

    @JDIAction(value="Get cell({0}, {1}) from '{name}' table")
    public String cell(String colName, String rowName) {
        return this.cell(this.getColIndexByName(colName), rowName);
    }

    @JDIAction(value="Preview '{name}' table")
    public String preview() {
        return (String)TRIM_PREVIEW.execute((Object)this.core().getText());
    }

    @Override
    @JDIAction(value="Get '{name}' table value")
    public String getValue() {
        this.getTableJs();
        String value = "||X||" + PrintUtils.print((Collection)((Collection)this.header.get()), (String)"|") + "||" + StringUtils.LINE_BREAK;
        for (int i = 1; i <= this.count(); ++i) {
            List row = ((MapArray)((MapArray)this.cellsValues.get()).get((Object)(i + ""))).values();
            value = value + "||" + i + "||" + PrintUtils.print((Collection)LinqUtils.map((Collection)row, arg_0 -> TRIM_VALUE.execute(arg_0)), (String)"|") + "||" + StringUtils.LINE_BREAK;
        }
        return value;
    }

    protected MapArray<String, String> getLineMap(Line row) {
        return new MapArray(this.header(), (Collection)row);
    }

    @Override
    public void setup(Field field) {
        if (!FillFromAnnotationRules.fieldHasAnnotation(field, JTable.class, BaseTable.class)) {
            return;
        }
        JTable j = field.getAnnotation(JTable.class);
        String rowHeader = j.rowHeader();
        List<String> header = Arrays.asList(j.header());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)j.root())) {
            this.core().setLocator(WebDriverByUtils.defineLocator(j.root()));
        }
        if (!j.row().equals("//tr[%s]/td") || !WebDriverByUtils.getByLocator(this.rowLocator).equals("//tr[%s]/td")) {
            this.rowLocator = WebDriverByUtils.defineLocator(j.row());
        }
        if (!j.column().equals("//tr/td[%s]") || !WebDriverByUtils.getByLocator(this.columnLocator).equals("//tr/td[%s]")) {
            this.columnLocator = WebDriverByUtils.defineLocator(j.column());
        }
        if (!j.cell().equals("//tr[{1}]/td[{0}]") || !WebDriverByUtils.getByLocator(this.cellLocator).equals("//tr[{1}]/td[{0}]")) {
            this.cellLocator = WebDriverByUtils.defineLocator(j.cell());
        }
        if (!j.allCells().equals("td") || !WebDriverByUtils.getByLocator(this.allCellsLocator).equals("td")) {
            this.allCellsLocator = WebDriverByUtils.defineLocator(j.allCells());
        }
        if (!j.headers().equals("th") || !WebDriverByUtils.getByLocator(this.headerLocator).equals("th")) {
            this.headerLocator = WebDriverByUtils.defineLocator(j.headers());
        }
        if (!j.filter().equals("th input[type=search],th input[type=text]") || !WebDriverByUtils.getByLocator(this.filterLocator).equals("th input[type=search],th input[type=text]")) {
            this.filterLocator = WebDriverByUtils.defineLocator(j.filter());
        }
        if (!j.fromCellToRow().equals("../td") || !WebDriverByUtils.getByLocator(this.fromCellToRow).equals("../td")) {
            this.fromCellToRow = WebDriverByUtils.defineLocator(j.fromCellToRow());
        }
        if (!j.footer().equals("tfoot") || !WebDriverByUtils.getByLocator(this.fromCellToRow).equals("tfoot")) {
            this.footer = WebDriverByUtils.defineLocator(j.footer());
        }
        if (!j.jsRow().equals("tr") || !WebDriverByUtils.getByLocator(this.jsRow).equals("tr")) {
            this.jsRow = WebDriverByUtils.defineLocator(j.jsRow());
        }
        if (!j.jsColumn().equals("td") || !WebDriverByUtils.getByLocator(this.jsColumn).equals("td")) {
            this.jsColumn = WebDriverByUtils.defineLocator(j.jsColumn());
        }
        if (header.size() > 0) {
            this.header.setFinal(header);
        }
        if (j.columnsMapping().length > 0) {
            this.columnsMapping = j.columnsMapping();
        }
        if (j.size() != -1) {
            this.size.setFinal((Object)j.size());
        }
        if (j.count() != -1) {
            this.count.setFinal((Object)j.count());
        }
        if (j.firstColumnIndex() != -1) {
            this.firstColumnIndex = j.firstColumnIndex();
        }
        if (j.firstColumnIndex() != -1) {
            this.firstRowIndex = j.firstColumnIndex();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)rowHeader)) {
            this.rowHeaderName = rowHeader;
        }
    }

    public T getTableJs() {
        try {
            List<String> listOfCells = this.jsCells();
            this.cellsValues.set(new MapArray());
            int k = 0;
            int j = 1;
            while (k < listOfCells.size()) {
                MapArray newRow = new MapArray();
                for (int i = 1; i <= this.size(); ++i) {
                    newRow.add((Object)(i + ""), (Object)listOfCells.get(k++));
                }
                ((MapArray)this.cellsValues.get()).update((Object)(j + ""), (Object)newRow);
                ++j;
            }
            this.cellsValues.gotAll();
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get all cells", new Object[0]);
        }
        return (T)this;
    }

    protected T getTable() {
        if (!this.cells.isGotAll()) {
            try {
                int i;
                List<WebElement> listOfCells = UIFactory.$$(this.allCellsLocator, (Object)this).core().noValidation().getAllElements(new Object[0]);
                this.cells.set(new MapArray());
                int k = 0;
                int j = 1;
                for (i = 1; i <= this.size(); ++i) {
                    ((MapArray)this.cells.get()).update((Object)(i + ""), (Object)new MapArray());
                }
                while (k < listOfCells.size()) {
                    for (i = 1; i <= this.size(); ++i) {
                        ((MapArray)((MapArray)this.cells.get()).get((Object)(i + ""))).update((Object)(j + ""), (Object)new UIElement(listOfCells.get(k++)));
                    }
                    ++j;
                }
                this.cells.gotAll();
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Can't get all cells", new Object[0]);
            }
        }
        return (T)this;
    }

    public void clear() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.rows.clear();
        this.columns.clear();
        this.cells.clear();
        this.count.clear();
        this.size.clear();
        this.header.clear();
        this.rowHeader.clear();
    }

    @Override
    public void offCache() {
        this.rows.useCache(false);
        this.columns.useCache(false);
        this.cells.useCache(false);
        this.count.useCache(false);
        this.size.useCache(false);
        this.header.useCache(false);
        this.rowHeader.useCache(false);
    }
}

