/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.dropdown;

import com.epam.jdi.light.asserts.complex.DropdownAssert;
import com.epam.jdi.light.asserts.generic.HasAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.ISelector;
import com.epam.jdi.light.elements.complex.ISetup;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.interfaces.complex.IsDropdown;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.JDropdown;
import com.epam.jdi.light.elements.pageobjects.annotations.objects.FillFromAnnotationRules;
import com.epam.jdi.light.logger.LogLevels;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;

public class DropdownExpand
extends UIBaseElement<DropdownAssert>
implements IsDropdown,
ISetup,
ISelector,
HasAssert<DropdownAssert> {
    public String expandLocator = ".caret";
    public String valueLocator = "input span:not(.caret),button span:not(.caret)";
    public String listLocator = "li";
    public boolean autoClose = false;
    protected boolean setupDone = false;

    public UIElement expander() {
        return this.linked(this.expandLocator, "expand");
    }

    @Override
    public UIElement value() {
        return this.linked(this.valueLocator, "value");
    }

    @Override
    public UIElement iCore() {
        return this.value();
    }

    @Override
    public WebList list() {
        return this.linkedList(this.listLocator, "list").setUIElementName(TextTypes.INNER);
    }

    public void toggle() {
        this.expander().click();
    }

    @Override
    @JDIAction(value="Is '{name}' expanded", level=LogLevels.DEBUG, timeout=0)
    public boolean isExpanded() {
        try {
            return (Boolean)this.list().noWait(WebList::isDisplayed, WebList.class);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @JDIAction(level=LogLevels.DEBUG, timeout=0)
    public void expand() {
        if (!this.isExpanded()) {
            this.toggle();
        }
    }

    @JDIAction(level=LogLevels.DEBUG, timeout=0)
    public void close() {
        if (this.isExpanded()) {
            this.toggle();
        }
    }

    @Override
    @JDIAction(value="Select '{0}' in '{name}'")
    public void select(String value) {
        this.expand();
        this.list().select(value);
        if (this.autoClose) {
            this.toggle();
        }
    }

    @Override
    @JDIAction(value="Select '{0}' in '{name}'")
    public void select(int index) {
        if (index < 1) {
            throw Exceptions.exception("Can't get element with index '%s'. Index should be 1 or more", index);
        }
        this.expand();
        this.list().select(index);
        if (this.autoClose) {
            this.close();
        }
    }

    @Override
    @JDIAction(value="Get selected value")
    public String selected() {
        return this.value().getText();
    }

    @Override
    @JDIAction(value="Is '{0}' selected")
    public boolean selected(String value) {
        return this.selected().equals(value);
    }

    @Override
    public String getText() {
        return this.value().getText();
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public int size() {
        WebList list = this.list();
        return (Integer)list.noValidation(list::size);
    }

    public IsDropdown setup(String root, String value, String list, String expand) {
        if (StringUtils.isNotBlank((CharSequence)root)) {
            this.base().setLocator(root);
        } else if (StringUtils.isNotBlank((CharSequence)value)) {
            this.base().setLocator(value);
            this.thisParent = true;
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.valueLocator = value;
            this.expandLocator = StringUtils.isNotBlank((CharSequence)expand) ? expand : value;
        } else if (StringUtils.isNotBlank((CharSequence)expand)) {
            this.expandLocator = expand;
        }
        if (StringUtils.isNotBlank((CharSequence)list)) {
            this.listLocator = list;
        }
        this.setupDone = true;
        return this;
    }

    @Override
    public void setup(Field field) {
        if (!FillFromAnnotationRules.fieldHasAnnotation(field, JDropdown.class, IsDropdown.class)) {
            return;
        }
        JDropdown j = field.getAnnotation(JDropdown.class);
        this.setup(j.root(), j.value(), j.list(), j.expand());
        this.autoClose = j.autoClose();
    }

    @Override
    @JDIAction(value="Check that '{name}' is displayed")
    public boolean isDisplayed() {
        return this.value().isDisplayed();
    }

    @Override
    public DropdownAssert is() {
        return (DropdownAssert)new DropdownAssert().set(this);
    }
}

