/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.asserts.generic.HasAssert;
import com.epam.jdi.light.asserts.generic.UISelectAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.JDILocator;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.CanBeSelected;
import com.epam.jdi.light.elements.complex.IList;
import com.epam.jdi.light.elements.complex.ISelector;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.init.entities.collection.EntitiesCollection;
import com.epam.jdi.light.elements.interfaces.base.HasUIList;
import com.epam.jdi.light.elements.interfaces.base.SetValue;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.MarkupLocator;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.func.JFunc2;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import com.google.common.primitives.Ints;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class WebList
extends JDIBase
implements IList<UIElement>,
SetValue,
ISelector,
HasUIList,
HasAssert<UISelectAssert<UISelectAssert<?, ?>, WebList>> {
    protected int startIndex;
    protected CacheValue<MapArray<String, UIElement>> map;
    private JFunc1<UIElement, String> UIELEMENT_NAME;
    private boolean nameIndex;

    public WebList indexFromZero() {
        return this.startIndex(0);
    }

    public WebList startIndex(int index) {
        this.startIndex = index;
        return this;
    }

    @Override
    public WebList list() {
        return this;
    }

    @Override
    public UIElement core() {
        return new UIElement(this.base());
    }

    public WebList setup(JAction1<JDIBase> setup) {
        return this.setup(WebList.class, setup);
    }

    public List<WebElement> webElements() {
        if (this.isUseCache()) {
            if (this.map.hasValue()) {
                return LinqUtils.select((Collection)((MapArray)this.map.get()).values(), el -> el.get());
            }
            if (this.webElements.hasValue()) {
                return (List)this.webElements.get();
            }
        }
        return this.elements(1).webElements();
    }

    @Override
    public WebList setCore(JDIBase base) {
        super.setCore(base);
        return this;
    }

    public WebList() {
        this.startIndex = JDISettings.ELEMENT.startIndex;
        this.map = new CacheValue(MapArray::new);
        this.nameIndex = false;
        this.webElements.useCache(true);
        this.webElement.useCache(true);
        this.textType = TextTypes.SMART_LIST;
    }

    public WebList(@MarkupLocator By locator) {
        this();
        this.setLocator(locator);
    }

    public WebList(List<WebElement> elements) {
        this();
        this.setWebElements(elements);
    }

    public static WebList newList(List<UIElement> elements) {
        return new WebList(LinqUtils.map(elements, JDIBase::get));
    }

    public WebList(MapArray<String, UIElement> map) {
        this.startIndex = JDISettings.ELEMENT.startIndex;
        this.map = new CacheValue(MapArray::new);
        this.nameIndex = false;
        this.map.set(map);
    }

    public WebList(List<String> header, List<UIElement> elements) {
        this((MapArray<String, UIElement>)new MapArray(header, elements));
    }

    public WebList(JDIBase base) {
        super(base);
        this.startIndex = JDISettings.ELEMENT.startIndex;
        this.map = new CacheValue(MapArray::new);
        this.nameIndex = false;
    }

    public WebList(JDIBase base, String locator, String name, Object parent) {
        super(base);
        this.startIndex = JDISettings.ELEMENT.startIndex;
        this.map = new CacheValue(MapArray::new);
        this.nameIndex = false;
        this.setLocator(locator);
        this.setName(name);
        this.setParent(parent);
    }

    @Override
    public WebList noValidation() {
        super.noValidation();
        return this;
    }

    @Override
    public WebList setName(String name) {
        super.setName(name);
        return this;
    }

    protected String nameFromIndex(int i) {
        return this.nameFromValue(i + 1 + "");
    }

    protected String nameFromValue(String value) {
        return String.format("%s[%s]", this.getName(), value);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public WebList elements(int minAmount) {
        return new WebList(this.uiElements(minAmount));
    }

    protected List<WebElement> uiElements(int minAmount) {
        if (minAmount < 0) {
            throw Exceptions.exception("uiElements failed. minAmount should be more than 0, but " + minAmount, new Object[0]);
        }
        if (this.isUseCache()) {
            if (this.map.hasValue() && ((MapArray)this.map.get()).size() > 0 && ((MapArray)this.map.get()).size() >= minAmount && this.isActualMap()) {
                return LinqUtils.select((Collection)((MapArray)this.map.get()).values(), el -> el.get());
            }
            if (this.webElements.hasValue() && ((List)this.webElements.get()).size() > 0 && ((List)this.webElements.get()).size() >= minAmount && this.isActual((WebElement)((List)this.webElements.get()).get(0))) {
                return (List)this.webElements.get();
            }
        }
        if (this.locator.isTemplate()) {
            throw Exceptions.exception("You call method that can't be used with template locator. Please correct %s locator to get List<WebElement> in order to use this method", WebDriverByUtils.shortBy(this.getLocator(new Object[0]), this));
        }
        return this.getListElements(minAmount);
    }

    @Override
    public Iterator<UIElement> iterator() {
        return LinqUtils.map(this.uiElements(0), el -> UIFactory.$(el)).iterator();
    }

    protected List<WebElement> getListElements(int minAmount) {
        return this.getList(minAmount);
    }

    @Override
    public UIElement first() {
        return this.get(this.startIndex);
    }

    @Override
    public UIElement last() {
        return this.get(this.size() - this.startIndex + 1);
    }

    protected String getElementName(int i, UIElement element) {
        return this.nameIndex ? this.nameFromIndex(i) : this.getElementName(element);
    }

    protected String getElementName(UIElement element) {
        try {
            return (String)this.nameFunc().execute((Object)element);
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected JFunc1<UIElement, String> nameFunc() {
        return this.UIELEMENT_NAME != null ? this.UIELEMENT_NAME : this.textType.func;
    }

    protected boolean hasKey(String value) {
        if (this.map.hasValue() && LinqUtils.any((Collection)((MapArray)this.map.get()).keys(), key -> StringUtils.namesEqual((String)key, (String)value))) {
            return this.isActual(this.getByKey(value));
        }
        return false;
    }

    protected UIElement getByKey(String value) {
        return (UIElement)((MapArray)this.map.get()).first((JFunc2)(JFunc2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getByKey$4(java.lang.String java.lang.String com.epam.jdi.light.elements.common.UIElement ), (Ljava/lang/String;Lcom/epam/jdi/light/elements/common/UIElement;)Ljava/lang/Boolean;)((String)value)).value;
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public UIElement get(String value) {
        return this.hasKey(value) ? this.getByKey(value) : this.getUIElement(value);
    }

    public UIElement getFast(String value) {
        return this.get(value).noValidation();
    }

    public UIElement getUIElement(String value) {
        UIElement element = this.locator.isTemplate() ? new UIElement(this.base(), this.getLocator(value), this.nameFromValue(value)) : this.getNewElementByValue(value);
        ((MapArray)this.map.get()).update((Object)value, (Object)element);
        return element;
    }

    protected UIElement getNewElementByValue(String value) {
        this.refresh();
        if (this.locator.isXPath()) {
            return new UIElement(this.base(), this.locator.addText(value), this.nameFromValue(value), this.parent);
        }
        UIElement result = this.firstUIElement(value);
        if (result == null) {
            throw Exceptions.exception("Failed to get '%s' in list '%s'. No elements with this name found", value, this.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UIElement firstUIElement(String value) {
        MapArray nameElement = new MapArray();
        try {
            for (UIElement element : this.elements(1)) {
                String name2 = this.getElementName(element);
                nameElement.add((Object)name2, (Object)element);
                if (!StringUtils.namesEqual((String)name2, (String)value)) continue;
                UIElement uIElement = element;
                return uIElement;
            }
            Iterator<UIElement> iterator = null;
            return iterator;
        }
        finally {
            if (this.map.hasValue()) {
                for (Pair pair : (MapArray)this.map.get()) {
                    if (LinqUtils.any((Collection)nameElement.keys(), name -> StringUtils.namesEqual((String)name, (String)((String)pair.key)))) continue;
                    nameElement.add(pair);
                }
            }
            this.map.set((Object)nameElement);
        }
    }

    public WebList setUIElementName(JFunc1<UIElement, String> func) {
        this.UIELEMENT_NAME = func;
        return this;
    }

    public WebList setUIElementName(TextTypes type) {
        if (type.equals((Object)TextTypes.INDEX)) {
            this.nameIndex = true;
            return this;
        }
        this.textType = type;
        return this.setUIElementName(type.func);
    }

    @Override
    public boolean isUseCache() {
        return this.webElements.isUseCache();
    }

    @Override
    public UIElement get(int index) {
        if (index < this.startIndex) {
            throw Exceptions.exception("Can't get element with index '%s'. Index should be %s or more", index, this.startIndex);
        }
        return this.getByIndex(index);
    }

    public UIElement getFast(int index) {
        return this.get(index).noValidation();
    }

    @JDIAction(level=LogLevels.DEBUG)
    private UIElement getByIndex(int index) {
        if (index < this.startIndex) {
            throw Exceptions.exception("Can't get element with index '%s'. Index should be %s or more", index, this.startIndex);
        }
        int getIndex = index - this.startIndex;
        if (this.locator.isNull() && this.isUseCache()) {
            if (this.map.hasValue() && ((MapArray)this.map.get()).size() > 0 && ((MapArray)this.map.get()).size() >= getIndex && this.isActualMap()) {
                return (UIElement)((MapArray)this.map.get()).values().get(getIndex);
            }
            if (this.webElements.hasValue() && ((List)this.webElements.get()).size() > 0 && ((List)this.webElements.get()).size() >= getIndex && this.isActual((WebElement)((List)this.webElements.get()).get(0))) {
                return UIFactory.$((WebElement)((List)this.webElements.get()).get(getIndex));
            }
        }
        UIElement element = this.locator.isTemplate() ? this.tryGetByIndex(index) : this.getElementByLocator(getIndex, index);
        return element.setName(this.nameFromIndex(index));
    }

    private UIElement getElementByLocator(int getIndex, int index) {
        return this.locator.isXPath() ? new UIElement(this.base(), this.locator.addIndex(index), index + "", this.parent) : this.initElement((JFunc<WebElement>)((JFunc)() -> this.getList(getIndex + 1).get(getIndex)));
    }

    protected UIElement tryGetByIndex(int index) {
        try {
            return new UIElement(this.base(), this.getLocator(index), this.nameFromIndex(index));
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get element with index '%s' for template locator. Maybe locator is wrong or you need to get element by name", index);
        }
    }

    @Override
    @JDIAction(value="Select '{0}' for '{name}'")
    public void select(String value) {
        this.clickOnElement(this.get(value), value);
    }

    private void clickOnElement(UIElement element, String value) {
        if (element == null) {
            throw Exceptions.exception("Can't get element '%s'", value);
        }
        if (this.textType == TextTypes.LABEL) {
            if (element.isDisabled()) {
                throw Exceptions.exception("Can't perform click. Element is disabled", new Object[0]);
            }
            element.label().click();
        } else {
            element.click();
        }
    }

    @Override
    @JDIAction(value="Select ({0}) for '{name}'")
    public void select(String ... values) {
        for (String value : values) {
            this.select(value);
        }
    }

    @JDIAction(value="Check all '{name}' unchecked options")
    public void checkAll() {
        for (UIElement checkbox : this.elements(1)) {
            if (!checkbox.isEnabled() || this.selected(checkbox)) continue;
            checkbox.click();
        }
    }

    @JDIAction(value="Uncheck all '{name}' checked options")
    public void uncheckAll() {
        for (UIElement checkbox : this.elements(1)) {
            if (!checkbox.isEnabled() || !this.selected(checkbox)) continue;
            checkbox.click();
        }
    }

    @JDIAction(value="Check only '{0}' in '{name}' list")
    public void check(String ... names) {
        List<String> listNames = Arrays.asList(names);
        for (UIElement value : this.elements(names.length)) {
            if (value.isDisabled() || (!this.selected(value) || listNames.contains(value.labelText().trim())) && (this.selected(value) || !listNames.contains(value.labelText().trim()))) continue;
            value.click();
        }
    }

    @JDIAction(value="Uncheck '{0}' checkboxes in '{name}' checklist")
    public void uncheck(String ... names) {
        List<String> listNames = Arrays.asList(names);
        for (UIElement value : this.elements(names.length)) {
            if (value.isDisabled() || (!this.selected(value) || !listNames.contains(value.labelText().trim())) && (this.selected(value) || listNames.contains(value.labelText().trim()))) continue;
            value.click();
        }
    }

    @JDIAction(value="Check '{0}' checkboxes in '{name}' checklist")
    public void check(int ... indexes) {
        List listIndexes = LinqUtils.toList((int[])indexes);
        int max = (Integer)Collections.max(Ints.asList((int[])indexes));
        WebList elements = this.elements(max - this.startIndex + 1);
        int i = this.startIndex;
        for (UIElement element : elements) {
            if (element.isDisabled()) continue;
            if (this.selected(element) && !listIndexes.contains(i) || !this.selected(element) && listIndexes.contains(i)) {
                element.click();
            }
            ++i;
        }
    }

    @JDIAction(value="Uncheck '{0}' checkboxes in '{name}' checklist")
    public void uncheck(int ... indexes) {
        List listIndexes = LinqUtils.toList((int[])indexes);
        int max = (Integer)Collections.max(Ints.asList((int[])indexes));
        WebList elements = this.elements(max - this.startIndex + 1);
        int i = this.startIndex;
        for (UIElement element : elements) {
            if (element.isDisabled()) continue;
            if (this.selected(element) && listIndexes.contains(i) || !this.selected(element) && !listIndexes.contains(i)) {
                element.click();
            }
            ++i;
        }
    }

    public <TEnum extends Enum<?>> void check(TEnum ... values) {
        this.check(EnumUtils.getEnumValues(values));
    }

    public <TEnum extends Enum<?>> void uncheck(TEnum ... values) {
        this.uncheck(EnumUtils.getEnumValues(values));
    }

    protected boolean selected(UIElement value) {
        return value.isSelected();
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    public void hoverAndClick(String ... values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            throw Exceptions.exception("Nothing to select in %s", this.getName());
        }
        if (values.length < 2) {
            throw Exceptions.exception("Hover and click method should have at list 2 parameters", new Object[0]);
        }
        int length = values.length;
        for (int i = 0; i < length - 1; ++i) {
            this.get(values[i]).hover();
        }
        this.get(values[length - 1]).click();
    }

    @Override
    public <TEnum extends Enum<?>> void select(TEnum value) {
        this.select(EnumUtils.getEnumValue(value));
    }

    @Override
    @JDIAction(value="Select ({0}) for '{name}'")
    public <TEnum extends Enum<?>> void select(TEnum ... values) {
        for (TEnum value : values) {
            this.select(value);
        }
    }

    @Override
    @JDIAction(value="Select '{0}' for '{name}'")
    public void select(int index) {
        this.clickOnElement(this.get(index), index + "");
    }

    @Override
    @JDIAction(value="Select ({0}) for '{name}'")
    public void select(int ... indexes) {
        for (int index : indexes) {
            this.select(index);
        }
    }

    @Override
    @JDIAction(value="Get '{name}' selected value")
    public String selected() {
        this.refresh();
        UIElement first = (UIElement)WebSettings.logger.logOff(() -> (UIElement)this.first(UIElement::isSelected));
        return first != null ? this.getElementName(first) : "";
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void refresh() {
        this.webElements.clear();
        this.map.clear();
        this.webElement.clear();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void clear() {
        this.refresh();
    }

    @Override
    public void setValue(String value) {
        this.select(value);
    }

    @Override
    public String getValue() {
        return PrintUtils.print(this.values());
    }

    @JDIAction
    public void showAll() {
        int size;
        do {
            size = this.size();
            this.get(size - 1).show();
            this.clear();
        } while (size < this.size());
    }

    @Override
    public int size() {
        try {
            if (this.isUseCache()) {
                if (this.map.hasValue() && ((MapArray)this.map.get()).size() > 0) {
                    return ((MapArray)this.map.get()).size();
                }
                if (this.webElements.hasValue() && ((List)this.webElements.get()).size() > 0) {
                    return ((List)this.webElements.get()).size();
                }
            }
            return IList.super.size();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    @JDIAction(value="Check that '{option}' is selected in '{name}'")
    public boolean selected(String option) {
        return this.get(option).isSelected();
    }

    @JDIAction(value="Get '{name}' checked values")
    public List<String> checked() {
        return this.ifSelect(ui -> EntitiesCollection.getByType(ui, CanBeSelected.class).isSelected(), this::getElementName);
    }

    @Override
    @JDIAction(value="Get '{name}' values")
    public List<String> values() {
        if (this.isUseCache()) {
            if (this.map.hasValue() && ((MapArray)this.map.get()).size() > 0 && this.isActualMap()) {
                return ((MapArray)this.map.get()).keys();
            }
            if (this.webElements.hasValue() && ((List)this.webElements.get()).size() > 0 && this.isActual((WebElement)((List)this.webElements.get()).get(0))) {
                List values = LinqUtils.map((Collection)((Collection)this.webElements.get()), element -> UIFactory.$(element).text(this.textType));
                HashSet unique = new HashSet(values);
                if (unique.size() == values.size()) {
                    this.map.set((Object)new MapArray((Collection)values, (Collection)LinqUtils.map((Collection)((Collection)this.webElements.get()), el -> UIFactory.$(el))));
                }
                return values;
            }
        }
        this.refresh();
        WebList elements = (WebList)this.noValidation(() -> this.elements(0));
        if (elements == null || elements.isEmpty()) {
            return new ArrayList<String>();
        }
        List values = LinqUtils.map((Collection)elements, el -> (String)el.noValidation(() -> el.text(this.textType)));
        HashSet unique = new HashSet(values);
        if (unique.size() == values.size()) {
            this.map.set((Object)new MapArray((Collection)values, (Collection)elements));
        }
        return values;
    }

    @JDIAction(value="Get '{name}' values")
    public List<String> getValuesFast() {
        return this.getListFast().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    @Override
    @JDIAction(value="Get '{name}' values")
    public List<String> values(TextTypes type) {
        this.setUIElementName(type);
        return this.values();
    }

    @Override
    @JDIAction(value="Get list of attributes for '{name}'")
    public List<String> attrs(String value) {
        return (List)this.noValidation(() -> this.map(e -> e.attr(value)));
    }

    @Override
    @JDIAction(value="Get list of enabled values for '{name}'")
    public List<String> listEnabled() {
        return (List)this.noValidation(() -> this.ifSelect(UIElement::isEnabled, this::getElementName));
    }

    @Override
    @JDIAction(value="Get list of disabled values for '{name}'")
    public List<String> listDisabled() {
        return (List)this.noValidation(() -> this.ifSelect(UIElement::isDisabled, this::getElementName));
    }

    @Override
    @JDIAction(value="Check that '{name}' is displayed", timeout=0)
    public boolean isDisplayed() {
        this.refresh();
        return this.isNotEmpty();
    }

    @Override
    @JDIAction(value="Check that '{name}' is hidden", timeout=0)
    public boolean isHidden() {
        return !this.isDisplayed();
    }

    @Override
    @JDIAction(value="Check that '{name}' is enabled", timeout=0)
    public boolean isEnabled() {
        return this.isNotEmpty() && this.first().isEnabled();
    }

    @Override
    @JDIAction(value="Check that '{name}' is disabled", timeout=0)
    public boolean isDisabled() {
        return !this.isEnabled();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void highlight(String color) {
        this.foreach(el -> el.highlight(color));
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void highlight() {
        this.foreach(UIElement::highlight);
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void hover() {
        this.first().hover();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void show() {
        this.first().show();
    }

    @Override
    public UISelectAssert<UISelectAssert<?, ?>, WebList> is() {
        this.refresh();
        UISelectAssert is = new UISelectAssert();
        is.set(this);
        return is;
    }

    @JDIAction(value="Assert that {name} list meet condition")
    public UISelectAssert<UISelectAssert<?, ?>, WebList> is(Matcher<? super List<UIElement>> condition) {
        MatcherAssert.assertThat((Object)this, condition);
        return this.is();
    }

    public UISelectAssert<UISelectAssert<?, ?>, WebList> assertThat(Matcher<? super List<UIElement>> condition) {
        return this.is(condition);
    }

    public boolean isActualMap() {
        return this.isActual((WebElement)((MapArray)this.map.get()).values().get(0));
    }

    protected boolean isActual(WebElement element) {
        try {
            if (ReflectionUtils.isClass(element.getClass(), UIElement.class)) {
                return (Boolean)((UIElement)element).noWait(() -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)element.getTagName()));
            }
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)element.getTagName());
        }
        catch (Exception ex) {
            this.map.clear();
            return false;
        }
    }

    protected UIElement initElement(JFunc<WebElement> func) {
        return this.initElement((WebElement)func.execute(), func);
    }

    protected UIElement initElement(WebElement el, JFunc<WebElement> func) {
        try {
            UIElement element = new UIElement(this.base(), el, func);
            element.locator = new JDILocator(element);
            return element;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't init func new element for list", new Object[0]);
        }
    }

    public UIElement initElement(WebElement el, JFunc<WebElement> func, int i) {
        return this.initElement(el, func, this.nameFromIndex(i));
    }

    private UIElement initElement(WebElement el, JFunc<WebElement> func, String name) {
        return this.initElement(el, func).setName(name);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.size() > 0;
    }

    @Override
    public Point getLocation() {
        return this.first().getLocation();
    }

    @Override
    public Dimension getSize() {
        Point firstPoint = this.first().getLocation();
        Point lastPoint = this.last().getLocation();
        Dimension dLast = this.last().getSize();
        return new Dimension(lastPoint.x + dLast.width - firstPoint.x, lastPoint.y + dLast.height - firstPoint.y);
    }

    @Override
    public void offCache() {
        super.offCache();
        this.map.useCache(false);
    }

    @Override
    public WebList finds(By locator) {
        List<WebElement> els = this.elements(1).selectMany(el -> el.finds(locator).webElements());
        return UIFactory.$$(els, this.context + ">" + locator);
    }

    private static /* synthetic */ Boolean lambda$getByKey$4(String value, String key, UIElement v) throws Exception {
        return StringUtils.namesEqual((String)key, (String)value);
    }
}

