/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.asserts.generic.UIMSelectAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.IMultiSelector;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.HasPlaceholder;
import com.epam.jdi.light.elements.interfaces.base.SetValue;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.util.Strings;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class Selector
extends UIBaseElement<UIMSelectAssert<?, ?>>
implements IMultiSelector,
SetValue,
HasPlaceholder {
    public static By LABEL_LOCATOR = By.xpath((String)".//label[text()='%s']");

    protected Select asSelect() {
        return this.core().asSelect();
    }

    @Override
    public WebList list() {
        return UIFactory.$$(this.asSelect().getOptions(), this.getName());
    }

    @Override
    @JDIAction(value="Select '{0}' in '{name}'")
    public void select(String value) {
        this.asSelect().selectByVisibleText(value);
    }

    @Override
    @JDIAction(value="Select '{0}' in '{name}'")
    public void select(int index) {
        if (index < 1) {
            throw Exceptions.exception("Can't get element with index '%s'. Index should be 1 or more", index);
        }
        this.asSelect().selectByIndex(index - 1);
    }

    @JDIAction(value="Check '{0}' for '{name}'")
    public void check(String ... values) {
        this.unckeckAll();
        for (String value : values) {
            this.asSelect().selectByVisibleText(value);
        }
    }

    @JDIAction(value="Check '{0}' for '{name}'")
    public void check(String values) {
        if (Strings.isEmpty((CharSequence)values)) {
            return;
        }
        this.check(values.split(","));
    }

    @JDIAction(value="Uncheck '{0}' for '{name}'")
    public void uncheck(String ... values) {
        for (WebElement opt : this.asSelect().getOptions()) {
            if ((!opt.isSelected() || !Arrays.asList(values).contains(opt.getText())) && (opt.isSelected() || Arrays.asList(values).contains(opt.getText()))) continue;
            opt.click();
        }
    }

    public <TEnum extends Enum<?>> void check(TEnum ... values) {
        this.check(EnumUtils.getEnumValues(values));
    }

    public <TEnum extends Enum<?>> void uncheck(TEnum ... values) {
        this.uncheck(EnumUtils.getEnumValues(values));
    }

    @JDIAction(value="Check '{0}' for '{name}'")
    public void check(int ... values) {
        this.unckeckAll();
        for (int index : values) {
            this.select(index);
        }
    }

    @JDIAction(value="Uncheck '{0}' for '{name}'")
    public void uncheck(int ... values) {
        List options = this.asSelect().getOptions();
        for (int i = 0; i < options.size(); ++i) {
            WebElement opt = (WebElement)options.get(i);
            if ((!opt.isSelected() || !ArrayUtils.contains((int[])values, (int)i)) && (opt.isSelected() || ArrayUtils.contains((int[])values, (int)i))) continue;
            opt.click();
        }
    }

    public void unckeckAll() {
        this.asSelect().deselectAll();
    }

    @Override
    @JDIAction(value="Get checked elements")
    public List<String> checked() {
        return LinqUtils.map((Collection)this.asSelect().getAllSelectedOptions(), WebElement::getText);
    }

    @Override
    @JDIAction(value="Get selected value")
    public String selected() {
        return this.asSelect().getFirstSelectedOption().getText();
    }

    @Override
    @JDIAction(value="Is '{0}' selected")
    public boolean selected(String value) {
        return this.core().locator.isTemplate() ? new UIElement(this.base().get(value)).isSelected() : this.selected().trim().equalsIgnoreCase(value.trim());
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public List<String> values() {
        return LinqUtils.map((Collection)this.asSelect().getOptions(), WebElement::getText);
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public List<String> values(TextTypes type) {
        return LinqUtils.map((Collection)this.asSelect().getOptions(), w -> UIFactory.$(w).text(type));
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public List<String> listEnabled() {
        List els = this.asSelect().getOptions();
        return LinqUtils.ifSelect((Collection)els, WebElement::isEnabled, WebElement::getText);
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public List<String> listDisabled() {
        List els = this.asSelect().getOptions();
        return LinqUtils.ifSelect((Collection)els, WebElement::isDisplayed, WebElement::getText);
    }

    @Override
    public void setValue(String value) {
        if (this.asSelect().isMultiple()) {
            this.check(value.split(";"));
        } else {
            this.select(value);
        }
    }

    @Override
    public String getValue() {
        return this.asSelect().isMultiple() ? PrintUtils.print(this.checked(), (String)";") : this.selected();
    }

    @Override
    public UIMSelectAssert<?, ?> is() {
        return (UIMSelectAssert)new UIMSelectAssert().set(this);
    }
}

