/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.asserts.generic.UISelectAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.UIUtils;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.Label;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.CanBeSelected;
import com.epam.jdi.light.elements.complex.IList;
import com.epam.jdi.light.elements.complex.ISelector;
import com.epam.jdi.light.elements.complex.ISetup;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.init.entities.collection.EntitiesCollection;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.base.IClickable;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.elements.interfaces.common.IsText;
import com.epam.jdi.light.elements.pageobjects.annotations.Title;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.map.MapArray;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

abstract class ListBase<T extends ICoreElement, A extends UISelectAssert<?, ?>>
extends UIBaseElement<A>
implements IList<T>,
ISetup,
ISelector {
    protected WebList list;
    public Class<?> initClass = UIElement.class;
    protected CacheValue<List<T>> values = new CacheValue();
    public static JFunc1<Field[], String> GET_TITLE_FIELD_NAME = fields -> {
        Field expectedField = (Field)LinqUtils.first((Object[])fields, f -> f.isAnnotationPresent(Title.class));
        if (expectedField != null) {
            return expectedField.getName();
        }
        List titles = LinqUtils.filter((Object[])fields, f -> f.getType() == Label.class);
        return titles.size() == 1 ? ((Field)titles.get(0)).getName() : null;
    };
    protected String titleFieldName = null;

    @Override
    public WebList list() {
        if (this.list == null) {
            this.list = new WebList(this.core()).setUIElementName((JFunc1<UIElement, String>)((JFunc1)this::elementTitle)).setName(this.getName());
        }
        return this.list;
    }

    ListBase() {
    }

    ListBase(By locator) {
        this.list = new WebList(locator);
    }

    ListBase(List<WebElement> elements) {
        this.list = new WebList(elements);
    }

    private boolean actualMapValue() {
        return this.values.hasValue() && ((List)this.values.get()).size() > 0 && this.isActual((ICoreElement)((List)this.values.get()).get(0));
    }

    private boolean isActual(T element) {
        try {
            element.getTagName();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public List<T> elements(int minAmount) {
        if (this.actualMapValue() && ((List)this.values.get()).size() >= minAmount) {
            return (List)this.values.get();
        }
        return LinqUtils.map((Collection)this.list().elements(minAmount), this::toT);
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public T get(String value) {
        return this.toT(this.list().get(value));
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public T get(int index) {
        return this.toT(this.list().get(index));
    }

    @Override
    @JDIAction(value="Select '{0}' for '{name}'")
    public void select(String value) {
        Object item = this.get(value);
        EntitiesCollection.getByType((ICoreElement)item, IClickable.class).click();
    }

    @Override
    @JDIAction(value="Select ({0}) for '{name}'")
    public void select(String ... values) {
        for (String value : values) {
            this.select(value);
        }
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    public void hoverAndClick(String ... values) {
        this.list().hoverAndClick(values);
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    public void hoverAndClick(String value) {
        this.list().hoverAndClick(value);
    }

    @Override
    public <TEnum extends Enum<?>> void select(TEnum value) {
        this.list().select(value);
    }

    @Override
    @JDIAction(value="Select ({0}) for '{name}'")
    public <TEnum extends Enum<?>> void select(TEnum ... values) {
        this.list().select(values);
    }

    @Override
    public int size() {
        return this.list().size();
    }

    @Override
    @JDIAction(value="Select '{0}' for '{name}'")
    public void select(int index) {
        this.list().select(index);
    }

    @Override
    @JDIAction(value="Select ({0}) for '{name}'")
    public void select(int ... indexes) {
        this.list().select(indexes);
    }

    @Override
    @JDIAction(value="Get '{name}' selected value")
    public String selected() {
        this.refresh();
        ICoreElement first = (ICoreElement)WebSettings.logger.logOff(() -> (ICoreElement)this.first(item -> EntitiesCollection.getByType(item, CanBeSelected.class).isSelected()));
        return first != null ? EntitiesCollection.getByType(first, IsText.class).getText() : "";
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void refresh() {
        this.clear();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void clear() {
        this.list().clear();
        this.values.clear();
    }

    @Override
    public void setValue(String value) {
        this.list().setValue(value);
    }

    @Override
    public String getValue() {
        return this.list().getValue();
    }

    @JDIAction
    public void showAll() {
        this.list().showAll();
    }

    @Override
    public boolean selected(String option) {
        return this.list().selected(option);
    }

    public List<String> checked() {
        return this.list().checked();
    }

    @Override
    public List<String> values() {
        List elements = LinqUtils.map(this.list().uiElements(0), el -> {
            UIElement ui = UIFactory.$(el);
            ((MapArray)this.list().map.get()).update((Object)this.elementTitle(ui), (Object)ui);
            return this.toT(ui);
        });
        return LinqUtils.map((Collection)elements, this::printValue);
    }

    protected String printValue(T element) {
        return ReflectionUtils.isInterface(element.getClass(), HasValue.class) ? ((HasValue)element).getValue() : element.toString();
    }

    @Override
    public boolean isDisplayed() {
        return this.list().isDisplayed();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void highlight(String color) {
        this.list().highlight(color);
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void highlight() {
        this.list().highlight();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void hover() {
        this.list().hover();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void show() {
        this.get(0).show();
    }

    @Override
    public void setup(Field field) {
        Type[] types;
        try {
            types = ReflectionUtils.getGenericTypes((Field)field);
        }
        catch (Exception ex) {
            return;
        }
        if (types.length != 1) {
            return;
        }
        try {
            Class<UIElement> initClass = (Class<UIElement>)((Object)types[0]);
            if (initClass == WebElement.class) {
                initClass = UIElement.class;
            }
            this.initClass = initClass;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't init WebList. WebList elements should extend UIElement", new Object[0]);
        }
    }

    protected T toT(UIElement el) {
        return (T)((ICoreElement)UIUtils.initT(el, this, this.initClass));
    }

    protected String elementTitle(UIElement el) {
        if (this.titleFieldName == null) {
            this.titleFieldName = (String)GET_TITLE_FIELD_NAME.execute((Object)this.initClass.getFields());
        }
        return this.titleFieldName == null ? (String)JDISettings.ELEMENT.listLabel.execute((Object)el) : this.getElementTitle(el, this.titleFieldName);
    }

    protected String getElementTitle(UIElement el, String titleField) {
        T element = this.toT(el);
        Field field = null;
        try {
            field = element.getClass().getField(titleField);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getTextElement(field, element).getText();
    }

    private IsText getTextElement(Field field, Object element) {
        Object title = ReflectionUtils.getValueField((Field)field, (Object)element);
        IsText textElement = EntitiesCollection.getByType((ICoreElement)title, IsText.class);
        textElement.base().noValidation();
        return textElement;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.size() > 0;
    }
}

