/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.elements.complex.CanBeSelected;
import com.epam.jdi.light.elements.complex.IList;
import com.epam.jdi.light.elements.init.entities.collection.EntitiesCollection;
import com.epam.jdi.light.elements.interfaces.base.IClickable;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.elements.interfaces.common.IsText;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public interface IWebList<T extends ICoreElement>
extends IList<T> {
    @JDIAction(value="Select '{0}' for '{name}'")
    default public void select(String value) {
        IClickable element = EntitiesCollection.getByType((ICoreElement)this.get(value), IClickable.class);
        if (element == null) {
            throw Exceptions.exception("Can't get element '%s'", value);
        }
        element.click();
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    default public void select(String ... values) {
        for (String value : values) {
            this.select(value);
        }
    }

    @JDIAction(value="Check all '{name}' unchecked options")
    default public void checkAll() {
        for (ICoreElement checkbox : this) {
            if (!checkbox.isEnabled() || EntitiesCollection.getByType(checkbox, CanBeSelected.class).isSelected()) continue;
            EntitiesCollection.getByType(checkbox, IClickable.class).click();
        }
    }

    @JDIAction(value="Uncheck all '{name}' checked options")
    default public void uncheckAll() {
        for (ICoreElement checkbox : this) {
            if (!checkbox.isEnabled() || !EntitiesCollection.getByType(checkbox, CanBeSelected.class).isSelected()) continue;
            EntitiesCollection.getByType(checkbox, IClickable.class).click();
        }
    }

    @JDIAction(value="Check only '{0}' in '{name}' list")
    default public void check(String ... names) {
        List<String> listNames = Arrays.asList(names);
        for (ICoreElement value : this.elements(names.length)) {
            if (value.isDisabled() || (!EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || listNames.contains(EntitiesCollection.getByType(value, IsText.class).text(this.base().textType).trim())) && (EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || !listNames.contains(EntitiesCollection.getByType(value, IsText.class).getText().trim()))) continue;
            EntitiesCollection.getByType(value, IClickable.class).click();
        }
    }

    @JDIAction(value="Uncheck '{0}' checkboxes in '{name}' checklist")
    default public void uncheck(String ... names) {
        List<String> listNames = Arrays.asList(names);
        for (ICoreElement value : this.elements(names.length)) {
            if (value.isDisabled() || (!EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || !listNames.contains(EntitiesCollection.getByType(value, IsText.class).text(this.base().textType).trim())) && (EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || listNames.contains(EntitiesCollection.getByType(value, IsText.class).text(this.base().textType).trim()))) continue;
            EntitiesCollection.getByType(value, IClickable.class).click();
        }
    }

    @JDIAction(value="Check '{0}' checkboxes in '{name}' checklist")
    default public void check(int ... indexes) {
        List listIndexes = LinqUtils.toList((int[])indexes);
        for (int i = 0; i < this.values().size(); ++i) {
            ICoreElement value = (ICoreElement)this.get(i);
            if (value.isDisabled() || (!EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || listIndexes.contains(i + 1)) && (EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || !listIndexes.contains(i + 1))) continue;
            EntitiesCollection.getByType(value, IClickable.class).click();
        }
    }

    @JDIAction(value="Uncheck '{0}' checkboxes in  '{name}' checklist")
    default public void uncheck(int ... indexes) {
        if (indexes.length > 0 && ((ICoreElement)this.get(indexes[0] - 1)).isDisplayed()) {
            List listIndexes = LinqUtils.toList((int[])indexes);
            for (int i = 0; i < this.values().size(); ++i) {
                ICoreElement value = (ICoreElement)this.get(i);
                if (value.isDisabled() || (!EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || !listIndexes.contains(i + 1)) && (EntitiesCollection.getByType(value, CanBeSelected.class).isSelected() || listIndexes.contains(i + 1))) continue;
                EntitiesCollection.getByType(value, IClickable.class).click();
            }
        }
    }

    default public <TEnum extends Enum<?>> void check(TEnum ... values) {
        this.check(EnumUtils.getEnumValues(values));
    }

    default public <TEnum extends Enum<?>> void uncheck(TEnum ... values) {
        this.uncheck(EnumUtils.getEnumValues(values));
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    default public void hoverAndClick(String ... values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            throw Exceptions.exception("Nothing to select in %s", this.getName());
        }
        if (values.length < 2) {
            throw Exceptions.exception("Hover and click method should have at list 2 parameters", new Object[0]);
        }
        int length = values.length;
        for (int i = 0; i < length - 1; ++i) {
            ((ICoreElement)this.get(values[i])).hover();
        }
        EntitiesCollection.getByType((ICoreElement)this.get(values[length - 1]), IClickable.class).click();
    }

    default public String separator() {
        return ">";
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    default public void hoverAndClick(String value) {
        String[] split = value.split(this.separator());
        if (split.length == 1) {
            this.select(split[0]);
        } else {
            this.hoverAndClick(split);
        }
    }

    default public <TEnum extends Enum<?>> void select(TEnum value) {
        this.select(EnumUtils.getEnumValue(value));
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    default public <TEnum extends Enum<?>> void select(TEnum ... values) {
        for (TEnum value : values) {
            this.select(value);
        }
    }

    @JDIAction(value="Select '{0}' for '{name}'")
    default public void select(int index) {
        EntitiesCollection.getByType((ICoreElement)this.get(index), IClickable.class).click();
    }

    @JDIAction(value="Select ({0}) for '{name}'")
    default public void select(int ... indexes) {
        for (int index : indexes) {
            this.select(index);
        }
    }

    @JDIAction(value="Get '{name}' selected value")
    default public String selected() {
        this.refresh();
        ICoreElement first = (ICoreElement)WebSettings.logger.logOff(() -> (ICoreElement)this.first(val -> EntitiesCollection.getByType(val, CanBeSelected.class).isSelected()));
        return first != null ? this.getElementName(first) : "";
    }

    default public String getElementName(T element) {
        return element.getName();
    }

    @JDIAction(value="Check that '{option}' is selected in '{name}'")
    default public boolean selected(String option) {
        return EntitiesCollection.getByType((ICoreElement)this.get(option), CanBeSelected.class).isSelected();
    }

    @JDIAction(value="Get '{name}' checked values")
    default public List<String> checked() {
        return this.ifSelect(val -> EntitiesCollection.getByType(val, CanBeSelected.class).isSelected(), this::getElementName);
    }

    @JDIAction(value="Get '{name}' values")
    default public List<String> values() {
        this.refresh();
        this.base().noValidation();
        return LinqUtils.map(this.elements(0), el -> el.core().getText());
    }

    @JDIAction(value="Get '{name}' values")
    default public List<String> values(TextTypes type) {
        this.base().textType = type;
        return this.values();
    }

    @JDIAction(value="Get list of enabled values for '{name}'")
    default public List<String> listEnabled() {
        return this.ifSelect(ICoreElement::isEnabled, this::getElementName);
    }

    @JDIAction(value="Get list of disabled values for '{name}'")
    default public List<String> listDisabled() {
        return this.ifSelect(ICoreElement::isDisabled, this::getElementName);
    }

    @JDIAction(value="Check that '{name}' is displayed")
    default public boolean isDisplayed() {
        return this.isNotEmpty() && ((ICoreElement)this.get(0)).isDisplayed();
    }

    @JDIAction(value="Check that '{name}' is hidden")
    default public boolean isHidden() {
        return !this.isDisplayed();
    }

    @JDIAction(value="Check that '{name}' is enabled")
    default public boolean isEnabled() {
        return this.isNotEmpty() && ((ICoreElement)this.get(0)).isEnabled();
    }

    @JDIAction(value="Check that '{name}' is disabled")
    default public boolean isDisabled() {
        return !this.isEnabled();
    }
}

