/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.elements.common.Label;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.IHasSize;
import com.epam.jdi.light.elements.interfaces.base.HasUIList;
import com.epam.jdi.light.elements.interfaces.base.INamed;
import com.epam.jdi.light.elements.interfaces.base.SetValue;
import com.epam.jdi.light.elements.interfaces.common.IsText;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import java.util.Collection;
import java.util.List;

public interface ISelector
extends IsText,
HasUIList,
INamed,
IHasSize,
SetValue {
    @JDIAction(value="Select '{0}' in '{name}'")
    default public void select(String value) {
        this.list().select(value);
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    default public void select(int index) {
        this.list().select(index);
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    default public <TEnum extends Enum<?>> void select(TEnum value) {
        this.select(EnumUtils.getEnumValue(value));
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    default public void select(String ... values) {
        this.list().select(values);
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    default public <TEnum extends Enum<?>> void select(TEnum ... values) {
        this.list().select(values);
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    default public void select(int ... values) {
        this.list().select(values);
    }

    @JDIAction(value="Get selected value")
    default public String selected() {
        return this.list().selected();
    }

    @JDIAction(value="Is '{0}' selected")
    default public boolean selected(String option) {
        return this.list().selected(option);
    }

    @JDIAction(value="Is '{0}' selected")
    default public boolean selected(int index) {
        return this.list().selected(index);
    }

    @JDIAction(level=LogLevels.DEBUG)
    default public List<String> values() {
        return this.list().values();
    }

    @JDIAction(level=LogLevels.DEBUG)
    default public List<String> values(TextTypes type) {
        return this.list().values(type);
    }

    @JDIAction(level=LogLevels.DEBUG)
    default public List<String> listEnabled() {
        return this.list().listEnabled();
    }

    @JDIAction(level=LogLevels.DEBUG)
    default public List<String> listDisabled() {
        return this.list().listDisabled();
    }

    @JDIAction(level=LogLevels.DEBUG)
    default public List<String> attrs(String value) {
        return this.list().attrs(value);
    }

    @Override
    default public String getText() {
        return this.selected();
    }

    @Override
    default public String getValue() {
        return this.selected();
    }

    @Override
    default public void setValue(String value) {
        this.select(value);
    }

    @Override
    @JDIAction(value="Check that '{name}' is displayed")
    default public boolean isDisplayed() {
        return this.list().isDisplayed();
    }

    @Override
    @JDIAction(value="Check that '{name}' is hidden")
    default public boolean isHidden() {
        return !this.isDisplayed();
    }

    @Override
    default public int size() {
        return this.list().size();
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean isNotEmpty() {
        return this.size() > 0;
    }

    default public List<Label> labels() {
        return LinqUtils.map((Collection)this.list(), UIElement::label);
    }
}

