/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.asserts.core.DataListAssert;
import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.UIUtils;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.ListBase;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.WebElement;

public class DataList<T extends ICoreElement, D>
extends ListBase<T, DataListAssert<T, D>> {
    public Class<D> dataType;

    public DataList() {
    }

    public DataList(Class<T> type, Class<D> dataType) {
        this.initClass = type;
        this.dataType = dataType;
    }

    public D getData(String name) {
        return UIUtils.asEntity(this.get(name), this.dataType);
    }

    public D getData(Enum name) {
        return this.getData(EnumUtils.getEnumValue((Enum)name));
    }

    public D getData(int index) {
        return UIUtils.asEntity(this.get(index), this.dataType);
    }

    public List<D> asData() {
        try {
            if (this.dataType == null) {
                return null;
            }
            List elements = this.elements(0);
            return LinqUtils.map((Collection)elements, v -> UIUtils.asEntity(v, this.dataType));
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get DataList data", new Object[0]);
        }
    }

    @Override
    public String getValue() {
        return PrintUtils.print(this.asData(), Object::toString);
    }

    @Override
    public DataListAssert<T, D> is() {
        this.refresh();
        return (DataListAssert)new DataListAssert().set(this);
    }

    @JDIAction(value="Assert that {name} data meet condition")
    public DataListAssert<T, D> isData(Matcher<? super List<D>> condition) {
        MatcherAssert.assertThat(this.asData(), condition);
        return this.is();
    }

    @JDIAction(value="Assert that {name} data meet condition")
    public DataListAssert<T, D> assertThat(Matcher<? super List<D>> condition) {
        return this.isData(condition);
    }

    public DataListAssert<T, D> verify(Matcher<? super List<D>> condition) {
        SoftAssert.assertSoft();
        return this.isData(condition);
    }

    @Override
    public void setup(Field field) {
        try {
            Type[] types = ReflectionUtils.getGenericTypes((Field)field);
            if (types.length == 0) {
                throw Exceptions.exception("Can't setup DataList generic parameters for field '%s'. Actual 0 but expected 1 or 2", field.getName());
            }
            if (types.length > 2) {
                throw Exceptions.exception("Can't setup DataList generic parameters for field '%s'. Actual more than %s but expected 1 or 2", field.getName(), types.length);
            }
            this.initClass = types[0].toString().equals("?") ? null : (Class)types[0];
            this.dataType = types.length == 1 || types[1].toString().equals("?") ? null : (Class)types[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getIndex(String name) {
        int i = this.list().startIndex;
        if (this.list().map.hasValue() && this.list().isActualMap()) {
            for (Pair pair : ((MapArray)this.list().map.get()).pairs) {
                if (StringUtils.namesEqual((String)((String)pair.key), (String)name)) {
                    if (!this.list().isActual((WebElement)pair.value)) break;
                    return i;
                }
                ++i;
            }
        }
        for (UIElement element : this.list().elements(1)) {
            String title = this.elementTitle(element);
            if (StringUtils.namesEqual((String)title, (String)name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public List<String> values() {
        return LinqUtils.map(this.asData(), Object::toString);
    }

    public List<String> keys() {
        this.asData();
        return ((MapArray)this.list().map.get()).keys();
    }
}

