/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.asserts.complex.ChecklistAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.elements.base.UIListBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.interfaces.complex.IsChecklist;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import java.util.Collection;
import java.util.List;

public class Checklist
extends UIListBase<ChecklistAssert>
implements IsChecklist {
    @Override
    public WebList list() {
        return super.list().setUIElementName(TextTypes.LABEL);
    }

    public Checklist() {
        this.base().setLocator("input[type=checkbox]");
    }

    @Override
    @JDIAction(value="Select '{0}' for '{name}'")
    public void select(String value) {
        this.list().select(value);
    }

    @Override
    @JDIAction(value="Select '{0}' checkboxes in '{name}' checklist")
    public void select(String ... values) {
        this.list().select(values);
    }

    @Override
    public <TEnum extends Enum<?>> void select(TEnum value) {
        this.list().select(value);
    }

    @Override
    public <TEnum extends Enum<?>> void select(TEnum ... values) {
        this.list().select(values);
    }

    @Override
    @JDIAction(value="Select '{0}' for '{name}'")
    public void select(int index) {
        this.list().select(index);
    }

    @Override
    @JDIAction(value="Select '{0}' checkboxes in '{name}' checklist")
    public void select(int ... indexes) {
        for (int index : indexes) {
            this.select(index);
        }
    }

    @Override
    @JDIAction(value="Check '{0}' checkboxes in '{name}' checklist")
    public void check(String ... names) {
        this.list().check(names);
    }

    protected boolean selected(UIElement value) {
        return value.isSelected();
    }

    @Override
    @JDIAction(value="Uncheck '{0}' checkboxes in '{name}' checklist")
    public void uncheck(String ... names) {
        this.list().uncheck(names);
    }

    @Override
    public <TEnum extends Enum<?>> void check(TEnum value) {
        this.check(EnumUtils.getEnumValue(value));
    }

    @Override
    public <TEnum extends Enum<?>> void check(TEnum ... values) {
        this.list().check((Enum[])values);
    }

    @Override
    public <TEnum extends Enum<?>> void uncheck(TEnum value) {
        this.uncheck(EnumUtils.getEnumValue(value));
    }

    @Override
    public <TEnum extends Enum<?>> void uncheck(TEnum ... values) {
        this.uncheck(EnumUtils.getEnumValues(values));
    }

    @Override
    public void check(int index) {
        this.check(new int[]{index});
    }

    @Override
    @JDIAction(value="Check '{0}' checkboxes in '{name}' checklist")
    public void check(int ... indexes) {
        this.list().check(indexes);
    }

    @Override
    public boolean isDisplayed() {
        return this.list().isDisplayed();
    }

    @Override
    @JDIAction(value="Check all '{name}' unchecked options")
    public void checkAll() {
        this.list().checkAll();
    }

    @Override
    public void uncheck(int index) {
        this.uncheck(new int[]{index});
    }

    @Override
    @JDIAction(value="Uncheck '{0}' checkboxes in  '{name}' checklist")
    public void uncheck(int ... indexes) {
        this.list().uncheck(indexes);
    }

    @Override
    @JDIAction(value="Uncheck all '{name}' checked options")
    public void uncheckAll() {
        this.list().uncheckAll();
    }

    @Override
    @JDIAction(value="Get '{name}' checked options")
    public List<String> checked() {
        return LinqUtils.ifSelect((Collection)this.list(), UIElement::isSelected, UIElement::labelText);
    }

    @Override
    public void setValue(String value) {
        this.check(value.split(";"));
    }

    @Override
    @JDIAction(value="Get '{name}' selected option")
    public String selected() {
        return PrintUtils.print(this.list().ifSelect(UIElement::isSelected, UIElement::labelText));
    }

    @Override
    @JDIAction(value="Is '{0}' selected in '{name}'")
    public boolean selected(String value) {
        return this.list().get(value).isSelected();
    }

    @Override
    public List<String> listEnabled() {
        return this.list().ifSelect(UIElement::isEnabled, UIElement::labelText);
    }

    @Override
    public List<String> listDisabled() {
        return this.list().ifSelect(UIElement::isDisabled, UIElement::labelText);
    }

    @Override
    public ChecklistAssert is() {
        return (ChecklistAssert)new ChecklistAssert().set(this);
    }
}

