/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.tools.map.MapArray;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Dimension;

public class WindowsManager {
    private static Set<String> windowHandles;
    private static MapArray<String, String> windowHandlesMap;
    private static boolean newWindow;

    public static Set<String> getWindows() {
        Set wHandles = WebDriverFactory.getDriver().getWindowHandles();
        if (windowHandles != null && windowHandles.size() < wHandles.size()) {
            newWindow = true;
        }
        windowHandles = wHandles;
        return windowHandles;
    }

    public static boolean newWindowIsOpened() {
        WindowsManager.getWindows();
        if (newWindow) {
            newWindow = false;
            return true;
        }
        return false;
    }

    @JDIAction(value="Check that new window is opened")
    public static void checkNewWindowIsOpened() {
        boolean isNewWindow = WindowsManager.newWindowIsOpened();
        if (!isNewWindow) {
            throw Exceptions.exception("New window is not opened", new Object[0]);
        }
        WindowsManager.switchToNewWindow();
    }

    public static void setWindowName(String value) {
        windowHandlesMap.update((Object)value, (Object)WebDriverFactory.getDriver().getWindowHandle());
    }

    @JDIAction(value="Get windows count")
    public static int windowsCount() {
        return WindowsManager.getWindows().size();
    }

    @JDIAction(value="Switch to new window")
    public static void switchToNewWindow() {
        String last = "";
        Iterator<String> iterator = WindowsManager.getWindows().iterator();
        while (iterator.hasNext()) {
            String window;
            last = window = iterator.next();
        }
        if (StringUtils.isBlank((CharSequence)last)) {
            throw Exceptions.exception("No windows found", new Object[0]);
        }
        WebDriverFactory.getDriver().switchTo().window(last);
    }

    @JDIAction(value="Open new tab")
    public static void openNewTab() {
        WebDriverFactory.jsExecute("window.open()", new Object[0]);
    }

    @JDIAction(value="Go back to original window")
    public static void originalWindow() {
        WebDriverFactory.getDriver().switchTo().window(WindowsManager.getWindows().iterator().next());
    }

    @JDIAction(value="Switch to window '{index}'")
    public static void switchToWindow(int index) {
        if (index < 1) {
            throw Exceptions.exception("Window's index starts from 1. You try to use '%s' that less than 1.", index);
        }
        int counter = 0;
        if (WindowsManager.getWindows().size() < index) {
            throw Exceptions.exception(index + " is too much. Only " + WindowsManager.getWindows().size() + " windows found", new Object[0]);
        }
        for (String window : WindowsManager.getWindows()) {
            if (++counter != index) continue;
            WebDriverFactory.getDriver().switchTo().window(window);
            return;
        }
    }

    @JDIAction(value="Switch to window '{0}'")
    public static void switchToWindow(String value) {
        if (!windowHandlesMap.has((Object)value)) {
            throw Exceptions.exception("Window %s not registered. Use setWindowName method to setup window name for current windowHandle", value);
        }
        WebDriverFactory.getDriver().switchTo().window((String)windowHandlesMap.get((Object)value));
    }

    @JDIAction(value="Close current window")
    public static void closeWindow() {
        WebDriverFactory.getDriver().close();
        WindowsManager.originalWindow();
    }

    @JDIAction(value="Close window '{0}'")
    public static void closeWindow(String value) {
        WindowsManager.switchToWindow(value);
        WindowsManager.closeWindow();
    }

    @JDIAction(value="Resize window '{0}'")
    public static void resizeWindow(int width, int height) {
        WebDriverFactory.getDriver().manage().window().setSize(new Dimension(width, height));
    }

    static {
        windowHandlesMap = new MapArray();
        newWindow = false;
    }
}

