/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.asserts.core.IsAssert;
import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.HasAssert;
import com.epam.jdi.light.common.ElementArea;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.Keyboard;
import com.epam.jdi.light.elements.common.Label;
import com.epam.jdi.light.elements.complex.CanBeSelected;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.HasCheck;
import com.epam.jdi.light.elements.interfaces.base.HasClick;
import com.epam.jdi.light.elements.interfaces.base.HasLabel;
import com.epam.jdi.light.elements.interfaces.base.HasPlaceholder;
import com.epam.jdi.light.elements.interfaces.base.SetValue;
import com.epam.jdi.light.elements.interfaces.common.IsInput;
import com.epam.jdi.light.elements.interfaces.common.IsText;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.MarkupLocator;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.JsonUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.Timer;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.func.JFunc2;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.switcher.CaseR;
import com.epam.jdi.tools.switcher.SwitchActions;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public class UIElement
extends JDIBase
implements WebElement,
SetValue,
HasAssert<IsAssert>,
HasClick,
IsText,
HasLabel,
HasPlaceholder,
IsInput,
HasCheck,
CanBeSelected {
    protected String imageFilePath;
    public static JFunc1<UIElement, String> SMART_GET_TEXT = ui -> {
        String text = ui.text(TextTypes.TEXT);
        if (StringUtils.isNotBlank((CharSequence)text)) {
            return text;
        }
        text = ui.text(TextTypes.INNER);
        if (StringUtils.isNotBlank((CharSequence)text)) {
            return text;
        }
        text = ui.text(TextTypes.VALUE);
        return StringUtils.isNotBlank((CharSequence)text) ? text : "";
    };
    public static JFunc1<UIElement, String> SMART_LIST_TEXT = ui -> {
        String text = ui.text(TextTypes.TEXT);
        if (StringUtils.isNotBlank((CharSequence)text)) {
            return text;
        }
        text = ui.text(TextTypes.INNER);
        if (StringUtils.isNotBlank((CharSequence)text)) {
            return text;
        }
        String id = ui.attr("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            UIElement label = UIFactory.$(By.cssSelector((String)("[for=" + id + "]")));
            label.waitSec(0);
            try {
                text = label.getText();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return StringUtils.isNotBlank((CharSequence)text) ? text : ui.text(TextTypes.VALUE);
    };

    public UIElement() {
    }

    public UIElement(WebElement el) {
        this.setWebElement(el);
    }

    public UIElement(List<WebElement> els) {
        this.setWebElements(els);
    }

    public UIElement(@MarkupLocator By locator) {
        this.setLocator(locator);
    }

    public UIElement(JDIBase base) {
        super(base);
    }

    public UIElement(JDIBase base, String locator, String name, Object parent) {
        super(base);
        this.setLocator(locator);
        this.setName(name);
        this.setParent(parent);
    }

    public UIElement(JDIBase base, By locator, String name) {
        super(base);
        this.setLocator(locator);
        this.setName(name);
    }

    public UIElement(JDIBase base, WebElement el, JFunc<WebElement> func) {
        super(base);
        this.setWebElement(el);
        this.setGetFunc(func);
    }

    @Override
    public UIElement core() {
        return this;
    }

    public UIElement setup(JAction1<JDIBase> setup) {
        return this.setup(UIElement.class, setup);
    }

    @Override
    public UIElement setCore(JDIBase base) {
        super.setCore(base);
        return this;
    }

    @Override
    public UIElement setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public UIElement waitSec(int timeout) {
        super.waitSec(timeout);
        return this;
    }

    public UIElement noWait() {
        super.noWait();
        return this;
    }

    @Override
    @JDIAction(value="Click on '{name}'")
    public void click() {
        this.click(this.clickAreaType);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public void submit() {
        this.get().submit();
    }

    @Override
    @JDIAction(value="Input '{0}' in '{name}'")
    public void sendKeys(CharSequence ... value) {
        WebElement el = this.get();
        if (value.length == 1 && value[0].equals("\n")) {
            el.sendKeys(new CharSequence[]{"\n " + Keys.BACK_SPACE});
        } else {
            el.sendKeys(value);
        }
        this.waitAfterAction();
    }

    @Override
    public void clear() {
        this.get().clear();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public String getTagName() {
        return this.getWebElement().getTagName();
    }

    public String tag() {
        return this.getTagName();
    }

    @JDIAction(value="Get '{name}' attribute '{0}'", level=LogLevels.DEBUG)
    public String getAttribute(String value) {
        return (String)LinqUtils.valueOrDefault((Object)this.getWebElement().getAttribute(value), (Object)"");
    }

    @Override
    @JDIAction(value="Check that '{name}' is selected", timeout=0)
    public boolean isSelected() {
        return this.selected();
    }

    @Override
    @JDIAction(value="Check that '{name}' is enabled", timeout=0)
    public boolean isEnabled() {
        return this.enabled();
    }

    @Override
    @JDIAction(value="Get '{name}' text")
    public String getText() {
        return this.text(this.textType);
    }

    @Override
    @JDIAction(value="Get '{name}' text")
    public String getTextForce() {
        this.noValidation();
        return this.text(this.textType);
    }

    @Override
    @JDIAction(value="Check that '{name}' is displayed", timeout=0, level=LogLevels.DEBUG)
    public boolean isDisplayed() {
        if (this.params.keys().contains("visualCheck")) {
            this.visualCheck("Check that '" + this.getName() + "' is displayed");
        }
        return this.displayed();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public Point getLocation() {
        return this.getWebElement().getLocation();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public Dimension getSize() {
        return this.getWebElement().getSize();
    }

    @JDIAction(level=LogLevels.DEBUG)
    public Rectangle getRect() {
        return this.getWebElement().getRect();
    }

    @JDIAction(level=LogLevels.DEBUG)
    public Rectangle getPosition() {
        Map map = (Map)this.js().executeScript("const rect = arguments[0].getBoundingClientRect();return {x:rect.x,y:rect.y,width:rect.width,height:rect.height};", new Object[]{this.getWebElement()});
        return new Rectangle(JsonUtils.getInt(map.get("x")), JsonUtils.getInt(map.get("y")), JsonUtils.getInt(map.get("height")), JsonUtils.getInt(map.get("width")));
    }

    @JDIAction(level=LogLevels.DEBUG)
    public String getCssValue(String value) {
        return this.getWebElement().getCssValue(value);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public WebElement findElement(@MarkupLocator By locator) {
        return UIFactory.$(locator, (Object)this).getWebElement();
    }

    @JDIAction(level=LogLevels.DEBUG)
    public List<WebElement> findElements(@MarkupLocator By locator) {
        return UIFactory.$(locator, (Object)this).getWebElements(new Object[0]);
    }

    @JDIAction(level=LogLevels.DEBUG)
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        return (X)this.getWebElement().getScreenshotAs(outputType);
    }

    @JDIAction(value="Execute javascript '{0}' for '{name}'", level=LogLevels.DEBUG, timeout=0)
    public String jsExecute(String jsCode) {
        return String.valueOf(this.js().executeScript("return arguments[0]." + jsCode + ";", new Object[]{this.getWebElement()}));
    }

    @Override
    @JDIAction(value="Check that '{name}' is visible by user", timeout=0)
    public boolean isVisible() {
        if (this.isHidden()) {
            return false;
        }
        Object isInView = this.js().executeScript("const rect = arguments[0].getBoundingClientRect();\nif (!rect) return false;\nconst windowHeight = Math.min(window.innerHeight || document.documentElement.clientHeight);\nconst windowWidth = Math.min(window.innerWidth || document.documentElement.clientWidth);\nconst ratio = arguments[1];\nconst reduceHeight = ratio*windowHeight;\nconst reduceWidth = ratio*windowWidth\nif (rect.top < reduceHeight) return false;\nif (rect.left < reduceWidth) return false;\nif (rect.bottom > windowHeight-reduceHeight) return false;\nif (rect.right > windowWidth-reduceWidth) return false;\nreturn true;", new Object[]{this.getWebElement(), 0.05});
        return (Boolean)isInView;
    }

    @Override
    @JDIAction(value="Input '{0}' in '{name}'")
    public void input(String value) {
        this.setTextType.action.execute((Object)this, (Object)value);
        this.waitAfterAction();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void focus() {
        this.sendKeys("");
    }

    @Override
    @JDIAction(value="Set '{0}' in '{name}'")
    public void setText(String value) {
        this.jsExecute("value='" + value.replace("\\", "\\\\").replace("'", "\\'") + "'");
    }

    @JDIAction(value="Click on '{name}' (x:{0}, y:{1})")
    public void click(int x, int y) {
        this.actionsWithElement((JFunc1<Actions, Actions>)((JFunc1)a -> a.moveByOffset(x - this.getRect().width / 2, y - this.getRect().height / 2).click()));
    }

    @Override
    @JDIAction(value="Click on '{name}'")
    public void click(ElementArea area) {
        if (this.isDisabled()) {
            throw Exceptions.exception("Can't perform click. Element is disabled", new Object[0]);
        }
        switch (area) {
            case TOP_LEFT: {
                this.click(1, 1);
                WebSettings.logger.debug("Click Top Left", new Object[0]);
                break;
            }
            case TOP_RIGHT: {
                this.click(this.getRect().getWidth() - 1, 1);
                WebSettings.logger.debug("Click Top Right", new Object[0]);
                break;
            }
            case BOTTOM_LEFT: {
                this.click(1, this.getRect().getHeight() - 1);
                WebSettings.logger.debug("Click Bottom Left", new Object[0]);
                break;
            }
            case BOTTOM_RIGHT: {
                this.click(this.getRect().getWidth() - 1, this.getRect().getHeight() - 1);
                WebSettings.logger.debug("Click Bottom Right", new Object[0]);
                break;
            }
            case CENTER: {
                this.get().click();
                break;
            }
            case JS: {
                this.jsExecute("click()");
                break;
            }
            case SMART_CLICK: {
                this.show();
                ElementArea clArea = (ElementArea)((Object)this.timer().getResultByCondition(this::getElementClickableArea, Objects::nonNull));
                if (clArea == null || clArea == ElementArea.CENTER) {
                    try {
                        this.get().click();
                        break;
                    }
                    catch (Exception ex) {
                        throw this.getNotClickableException();
                    }
                }
                this.click(clArea);
            }
        }
        this.waitAfterAction();
    }

    protected void waitAfterAction() {
        if (StringUtils.isBlank((CharSequence)this.waitAfterMethod) && this.waitAfterTimeout > 0) {
            Timer.sleep((long)(this.waitAfterTimeout * 1000));
        }
    }

    protected RuntimeException getNotClickableException() {
        return Exceptions.exception("%s is not clickable in any parts. Maybe this element overlapped by some other element or locator is wrong", this.getName());
    }

    protected ElementArea getElementClickableArea() {
        return (ElementArea)((Object)SwitchActions.Switch().get(new CaseR[]{SwitchActions.Case(t -> this.isClickable(), t -> ElementArea.CENTER), SwitchActions.Case(t -> this.isClickable(1, 1), t -> ElementArea.TOP_LEFT), SwitchActions.Case(t -> this.isClickable(this.getRect().getWidth() - 1, 1), t -> ElementArea.TOP_RIGHT), SwitchActions.Case(t -> this.isClickable(1, this.getRect().getHeight() - 1), t -> ElementArea.BOTTOM_LEFT), SwitchActions.Case(t -> this.isClickable(this.getRect().getWidth() - 1, this.getRect().getHeight() - 1), t -> ElementArea.BOTTOM_RIGHT)}));
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    public void select(String value) {
        this.get(value).click();
        this.waitAfterAction();
    }

    @JDIAction(value="Select '{name}' element")
    public void select() {
        this.click();
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    public void select(int index) {
        this.getWebElements(new Object[0]).get(index).click();
        this.waitAfterAction();
    }

    @JDIAction(value="Select '{0}' in '{name}'")
    public void select(String ... names) {
        for (String name : names) {
            this.select(name);
        }
    }

    public <TEnum extends Enum<?>> void select(TEnum name) {
        this.select(EnumUtils.getEnumValue(name));
    }

    public Select asSelect() {
        WebElement select = this.getWebElement();
        if (!this.getTagName().equals("select")) {
            List els = select.findElements(By.tagName((String)"select"));
            if (els.size() > 0) {
                select = (WebElement)els.get(0);
            } else {
                throw Exceptions.exception("Element should point to <select> tag in order to use Selenium Select", new Object[0]);
            }
        }
        return new Select(select);
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void setAttribute(String name, String value) {
        this.jsExecute("setAttribute('" + name + "','" + value + "')");
    }

    @JDIAction(level=LogLevels.DEBUG)
    public MapArray<String, String> getAllAttributes() {
        try {
            List jsList = (List)this.js().executeScript("var s = []; var attrs = arguments[0].attributes; for (var l = 0; l < attrs.length; ++l) { var a = attrs[l]; s.push(a.name + '=\"' + a.value + '\"'); } ; return s;", new Object[]{this.getWebElement()});
            return new MapArray((Collection)jsList, r -> r.split("=")[0], r -> r.split("=")[1].replace("\"", ""));
        }
        catch (Exception ignore) {
            return new MapArray();
        }
    }

    @JDIAction(value="Check that '{name}' is deselected", timeout=0)
    public boolean isDeselected() {
        return !this.selected();
    }

    @Override
    @JDIAction(value="Check that '{name}' is hidden", timeout=0)
    public boolean isHidden() {
        return !this.displayed();
    }

    @Override
    @JDIAction(value="Check that '{name}' is not visible by user", timeout=0)
    public boolean isNotVisible() {
        return !this.isVisible();
    }

    @Override
    @JDIAction(value="Check that '{name}' is exist on the page", timeout=0)
    public boolean isExist() {
        return (Boolean)this.noWait(() -> {
            try {
                this.getWebElement();
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        });
    }

    @Override
    @JDIAction(value="Check that '{name}' is missed on the page", timeout=0)
    public boolean isNotExist() {
        return !this.isExist();
    }

    @Override
    @JDIAction(value="Check that '{name}' is disabled")
    public boolean isDisabled() {
        return !this.enabled();
    }

    @Override
    @JDIAction(value="Get '{name}' list of classes ", level=LogLevels.DEBUG)
    public List<String> classes() {
        String cl = this.attr("class");
        return cl.length() > 0 ? Arrays.asList(cl.split(" ")) : new ArrayList();
    }

    @Override
    @JDIAction(value="Is '{name}' has class '{0}'", level=LogLevels.DEBUG)
    public boolean hasClass(String className) {
        return this.classes().contains(className);
    }

    @Override
    public boolean hasAttribute(String attrName) {
        return StringUtils.isNotBlank((CharSequence)this.attr(attrName));
    }

    @Override
    @JDIAction(value="Get '{name}' placeholder", level=LogLevels.DEBUG)
    public String placeholder() {
        return this.getAttribute("placeholder");
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public String printHtml() {
        return MessageFormat.format("<{0} {1}>{2}</{0}>", this.getTagName(), PrintUtils.print(this.getAllAttributes(), el -> String.format("%s=\"%s\"", el.key, el.value), (String)" "), this.getAttribute("innerHTML"));
    }

    @Override
    @JDIAction(timeout=0)
    public void show() {
        if (this.isDisplayed() && !this.isVisible()) {
            this.jsExecute("scrollIntoView({behavior:'auto',block:'center',inline:'center'})");
        }
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public void highlight(String color) {
        this.show();
        this.jsExecute("style.border='3px dashed " + color + "'");
    }

    @Override
    public void highlight() {
        this.highlight("red");
    }

    @Override
    @JDIAction(value="DoubleClick on '{name}'")
    public void doubleClick() {
        this.actionsWithElement((JFunc2<Actions, WebElement, Actions>)((JFunc2)(a, e) -> a.doubleClick(e)));
        this.waitAfterAction();
    }

    @Override
    @JDIAction(value="RightClick on '{name}'")
    public void rightClick() {
        this.actionsWithElement((JFunc2<Actions, WebElement, Actions>)((JFunc2)(a, e) -> a.contextClick(e)));
        this.waitAfterAction();
    }

    @Override
    @JDIAction(value="Hover to '{name}'")
    public void hover() {
        this.actions((JFunc2<Actions, WebElement, Actions>)((JFunc2)Actions::moveToElement));
    }

    @Override
    @JDIAction(value="Drag '{name}' and drop it to '{0}'")
    public void dragAndDropTo(WebElement to) {
        this.actions((JFunc2<Actions, WebElement, Actions>)((JFunc2)(a, from) -> a.clickAndHold(from).moveToElement(to).release(to)));
    }

    @Override
    @JDIAction(value="Drag '{name}' and drop it to ({0},{1})")
    public void dragAndDropTo(int x, int y) {
        this.actions((JFunc2<Actions, WebElement, Actions>)((JFunc2)(a, e) -> a.dragAndDropBy(e, x, y)));
    }

    public File makePhoto() {
        return this.makePhoto("");
    }

    public boolean hasImage() {
        return this.imageFilePath != null;
    }

    public File getImageFile() {
        return this.hasImage() ? new File(this.imageFilePath) : null;
    }

    protected String getScreenshotName(String tag) {
        return this.varName + tag + JDISettings.SCREEN.fileSuffix;
    }

    @JDIAction(level=LogLevels.DEBUG)
    public File makePhoto(String tag) {
        this.show();
        Rectangle rect = this.getPosition();
        this.imageFilePath = WebPage.windowScreenshot(this.multiply(rect.getX()), this.multiply(rect.getY()), this.multiply(rect.getWidth()), this.multiply(rect.getHeight()), this.getScreenshotName(tag));
        return this.getImageFile();
    }

    protected int multiply(int value) {
        return (int)Math.round((double)value * WebPage.zoomLevel());
    }

    @Override
    @JDIAction(value="Visual compare '{0}'")
    public void visualValidation(String tag) {
        try {
            if (this.hasImage()) {
                File image = this.getImageFile();
                this.makePhoto(tag + "-new");
                this.compareImageFiles(this.getImageFile(), image);
            } else {
                this.makePhoto(tag);
                String message = "Set baseline: " + this.imageFilePath;
                SoftAssert.jdiAssert(message, Matchers.is((Object)message));
            }
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't compare files", new Object[0]);
        }
    }

    protected void compareImageFiles(File image1, File image2) {
        long expected;
        long actual = image1.length();
        String result = Math.abs(actual - (expected = image2.length())) < 100L ? "Images are the same" : String.format("Images are different %s %s", image1.getAbsolutePath(), image2.getAbsolutePath());
        SoftAssert.jdiAssert(result, Matchers.is((Object)"Images are the same"));
    }

    @Override
    @JDIAction(value="Visual compare '{0}'")
    public void visualValidation(UIElement element) {
        this.compareImageFiles(this.getImageFile(), element.getImageFile());
    }

    @Override
    @JDIAction(value="Check '{name}'")
    public void check() {
        if (this.isDeselected()) {
            this.click();
        }
    }

    @Override
    @JDIAction(value="Uncheck '{name}'")
    public void uncheck() {
        if (this.isSelected()) {
            this.click();
        }
    }

    @Override
    public Label label() {
        return new Label().setup(Label.class, (JAction1<JDIBase>)((JAction1)j -> j.setLocator(By.cssSelector((String)("[for=" + this.core().attr("id") + "]"))).setName(this.getName() + " label")));
    }

    @Override
    @JDIAction(value="Get '{name}' label text")
    public String labelText() {
        return this.label().getText();
    }

    @Override
    @JDIAction(value="Get '{name}' text")
    public String text(TextTypes type) {
        return (String)this.timer().getResult(() -> (String)this.noWait(() -> (String)type.func.execute((Object)this)));
    }

    @Override
    public UIElement find(@MarkupLocator String by) {
        return UIFactory.$(by, (Object)this);
    }

    public UIElement findFirst(@MarkupLocator String by) {
        UIElement element = UIFactory.$(by, (Object)this);
        element.strictSearch(false);
        return element;
    }

    @Override
    public UIElement find(@MarkupLocator By by) {
        return UIFactory.$(by, (Object)this);
    }

    @Override
    public WebList finds(@MarkupLocator String by) {
        return UIFactory.$$(by, (Object)this);
    }

    @Override
    public WebList finds(@MarkupLocator By by) {
        return UIFactory.$$(by, (Object)this);
    }

    @Override
    public UIElement firstChild() {
        return this.find("*");
    }

    @Override
    public WebList children() {
        return this.finds("*");
    }

    @Override
    public MapArray<String, String> attrs() {
        return this.getAllAttributes();
    }

    @Override
    public String attr(String value) {
        return this.getAttribute(value);
    }

    @Override
    public String text() {
        return this.text(this.textType);
    }

    @Override
    public String css(String prop) {
        return this.getCssValue(prop);
    }

    @Override
    public void setValue(String value) {
        this.input(value);
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    protected boolean selected() {
        if (this.getWebElement().isSelected()) {
            return true;
        }
        return this.hasClass("checked") || this.hasClass("active") || this.hasClass("selected") || this.attr("checked").equals("true");
    }

    protected boolean enabled() {
        if (this.hasClass("active")) {
            return true;
        }
        if (this.hasClass("disabled") || this.hasAttribute("disabled")) {
            return false;
        }
        return this.getWebElement().isEnabled();
    }

    protected boolean displayed() {
        try {
            return this.getWebElement().isDisplayed();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public UIElement noValidation() {
        super.noValidation();
        return this;
    }

    public boolean isClickable() {
        return this.isClickable(this.getRect().getWidth() / 2, this.getRect().getHeight() / 2 - 1);
    }

    public boolean isClickable(int x, int y) {
        return (Boolean)this.js().executeScript("var elem = arguments[0],      rect = elem.getBoundingClientRect(),      cx = rect.left + arguments[1],          cy = rect.top + arguments[2],          e = document.elementFromPoint(cx, cy); for (; e; e = e.parentElement) {           if (e === elem)                            return true;                         }                                        return false;                            ", new Object[]{this.getWebElement(), x, y});
    }

    public boolean wait(JFunc1<UIElement, Boolean> condition) {
        return this.timer().wait(() -> (Boolean)condition.execute((Object)this));
    }

    @Override
    public <T> T with(Class<T> cl) {
        try {
            return (T)ReflectionUtils.create(cl, (Object[])new Object[]{this});
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "Can't create instantiate class. %s class should have constructor with UIElement parameter in order to use with method", cl.getSimpleName());
        }
    }

    @Override
    public void press(Keys key) {
        Keyboard.press(key);
    }

    @Override
    public void command(String sequence) {
        Keyboard.command(sequence);
    }

    @Override
    public void commands(String ... commands) {
        Keyboard.commands(commands);
    }

    @Override
    public void pasteText(String text) {
        Keyboard.pasteText(text);
    }

    @Override
    public void pasteText(String text, long timeToWaitMSec) {
        Keyboard.pasteText(text, timeToWaitMSec);
    }

    @Override
    public IsAssert is() {
        return (IsAssert)new IsAssert().set(this);
    }
}

