/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.Timer;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.Keys;

public class Keyboard {
    static Robot robot;

    static Robot getRobot() {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Can't instantiate Robot", new Object[0]);
            }
        }
        return robot;
    }

    public static void pasteText(CharSequence text) {
        Keyboard.pasteText(text, 10L);
    }

    public static void pasteText(CharSequence text, long timeToWaitMSec) {
        try {
            StringSelection stringSelection = new StringSelection(text.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, (clipboard1, contents) -> {});
            Timer.sleep((long)timeToWaitMSec);
            Keyboard.commands("Ctrl+V", "Enter");
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Past text '%s' failed with exception", text);
        }
    }

    public static void commands(String ... commands) {
        for (String keyGroup : commands) {
            Object[] keys;
            for (Object key : keys = keyGroup.split("\\+")) {
                Keyboard.getRobot().keyPress(Keyboard.getKeyCode((String)key));
            }
            ArrayUtils.reverse((Object[])keys);
            for (Object key : keys) {
                Keyboard.getRobot().keyRelease(Keyboard.getKeyCode((String)key));
            }
        }
    }

    public static void command(String sequence) {
        Keyboard.commands(sequence.replace(" ", "").split(","));
    }

    private static int getKeyCode(String key) {
        String keyName;
        List<Field> keys = Keyboard.getKeys();
        Field keyField = (Field)LinqUtils.first(keys, arg_0 -> Keyboard.lambda$getKeyCode$1(keyName = key.replaceAll(" ", "").replaceAll("_", ""), arg_0));
        if (keyField != null) {
            return (Integer)ReflectionUtils.getValueField((Field)keyField, null);
        }
        throw Exceptions.exception("Unknown key '%s'", key);
    }

    private static String getKeyName(Field field) {
        int underscore = field.getName().indexOf(95);
        return field.getName().substring(underscore + 1).toLowerCase().replaceAll(" ", "").replaceAll("_", "");
    }

    private static List<Field> getKeys() {
        return LinqUtils.filter((Object[])KeyEvent.class.getDeclaredFields(), f -> Modifier.isStatic(f.getModifiers()) && f.getName().startsWith("VK_"));
    }

    public static void press(String key) {
        Keyboard.press(Keyboard.getKeyCode(key));
    }

    public static void press(int key) {
        Keyboard.getRobot().keyPress(key);
        Keyboard.getRobot().keyRelease(key);
    }

    public static void press(Keys key) {
        String keyName;
        List<Field> keys = Keyboard.getKeys();
        Field keyField = (Field)LinqUtils.first(keys, arg_0 -> Keyboard.lambda$press$3(keyName = key.name().replaceAll(" ", "").replaceAll("_", ""), arg_0));
        if (keyField == null) {
            throw Exceptions.exception("Unknown key '%s'", key);
        }
        int keyCode = (Integer)ReflectionUtils.getValueField((Field)keyField, null);
        Keyboard.press(keyCode);
    }

    private static /* synthetic */ Boolean lambda$press$3(String keyName, Field f) throws Exception {
        return Keyboard.getKeyName(f).equalsIgnoreCase(keyName);
    }

    private static /* synthetic */ Boolean lambda$getKeyCode$1(String keyName, Field f) throws Exception {
        return Keyboard.getKeyName(f).equalsIgnoreCase(keyName);
    }
}

