/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.driver.WebDriverFactory;
import java.util.Collection;
import java.util.Set;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

public class Cookies {
    private static WebDriver.Options manage() {
        return WebDriverFactory.getDriver().manage();
    }

    @JDIAction(value="Get site cookies")
    public static Set<Cookie> getCookies() {
        return Cookies.manage().getCookies();
    }

    @JDIAction(value="Get cookie '{0}'")
    public static Cookie getCookie(String value) {
        return Cookies.manage().getCookieNamed(value);
    }

    @JDIAction(value="Add cookie '{0}'")
    public static void addCookie(Cookie cookie) {
        Cookies.manage().addCookie(cookie);
    }

    @JDIAction(value="Add cookie '{0}'")
    public static void addCookies(Collection<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            Cookies.addCookie(cookie);
        }
    }

    @JDIAction(value="Add cookie '{0}'")
    public static void setCookies(Collection<Cookie> cookies) {
        Cookies.clearAllCookies();
        Cookies.addCookies(cookies);
    }

    @JDIAction(value="Delete all cookies")
    public static void clearAllCookies() {
        Cookies.manage().deleteAllCookies();
    }

    @JDIAction(value="Delete all cookies")
    public static void deleteCookie(Cookie cookie) {
        Cookies.manage().deleteCookie(cookie);
    }

    @JDIAction(value="Delete all cookies")
    public static void deleteCookie(String name) {
        Cookies.manage().deleteCookieNamed(name);
    }
}

