/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.base;

import com.epam.jdi.light.asserts.generic.UISelectAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.ISelector;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.interfaces.base.SetValue;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.tools.func.JAction1;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;

public abstract class UIListBase<A extends UISelectAssert<?, ?>>
extends UIBaseElement<A>
implements ISelector,
SetValue {
    protected WebList list;

    @Override
    public WebList list() {
        return new WebList(this.base()).setup((JAction1<JDIBase>)((JAction1)JDIBase::searchVisible));
    }

    protected void setList(WebList webList) {
        this.list = webList;
    }

    public UIElement first() {
        return this.list().first();
    }

    public UIElement last() {
        return this.list().last();
    }

    public UIElement get(String value) {
        return this.list().get(value);
    }

    public UIElement get(int index) {
        return this.list().get(index);
    }

    @Override
    @JDIAction(value="Check that '{name}' is displayed")
    public boolean isDisplayed() {
        return this.list().isDisplayed();
    }

    @Override
    @JDIAction(value="Check that '{name}' is visible by user")
    public boolean isVisible() {
        return this.isDisplayed() && this.list().hasAny(UIElement::isVisible);
    }

    @Override
    @JDIAction(value="Check that '{name}' is not visible by user")
    public boolean isNotVisible() {
        return this.isHidden() || this.list().all(UIElement::isNotVisible);
    }

    @Override
    public boolean isEnabled() {
        return this.list().isEnabled();
    }

    @Override
    @JDIAction(level=LogLevels.DEBUG)
    public boolean isDisabled() {
        return !this.isEnabled();
    }

    @Override
    public String getValue() {
        return this.selected();
    }

    @Override
    public void setValue(String value) {
        this.select(value);
    }

    @Override
    public void offCache() {
        this.list().offCache();
        super.offCache();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.size() > 0;
    }

    @Override
    public Point getLocation() {
        return this.list().getLocation();
    }

    @Override
    public void highlight() {
        this.list().highlight();
    }

    @Override
    public void highlight(String color) {
        this.list().highlight(color);
    }

    @Override
    public void show() {
        this.list().show();
    }

    @Override
    public Dimension getSize() {
        return this.list().getSize();
    }

    @Override
    public A is() {
        this.list().refresh();
        return (A)((UISelectAssert)new UISelectAssert().set(this));
    }
}

