/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.base;

import com.epam.jdi.light.common.ElementArea;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.JDILocator;
import com.epam.jdi.light.common.OutputTemplates;
import com.epam.jdi.light.common.SearchStrategies;
import com.epam.jdi.light.common.SetTextTypes;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.base.DriverBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.HasCache;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.JDIElement;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.MarkupLocator;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.Timer;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JAction2;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.func.JFunc2;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import com.epam.jdi.tools.switcher.CaseR;
import com.epam.jdi.tools.switcher.SwitchActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public abstract class JDIBase
extends DriverBase
implements IBaseElement,
HasCache {
    public static JFunc1<String, String> STRING_SIMPLIFY = s -> s.toLowerCase().replaceAll("[^a-zA-Z0-9]", "");
    public MapArray<String, Object> params = new MapArray();
    public JDILocator locator = new JDILocator(this);
    public CacheValue<WebElement> webElement = new CacheValue();
    public CacheValue<List<WebElement>> webElements = new CacheValue();
    public MapArray<String, JFunc1<WebElement, Boolean>> searchRules = new MapArray();
    public JAction1<UIElement> beforeSearch = null;
    protected int timeout = -1;
    protected int waitAfterTimeout = -1;
    protected String waitAfterMethod = "";
    public static final String FAILED_TO_FIND_ELEMENT_MESSAGE = "Can't find Element '%s' during %s seconds";
    public static final String FIND_TO_MUCH_ELEMENTS_MESSAGE = "Found %s elements instead of one for Element '%s' during %s seconds";
    public static final String ELEMENTS_FILTERED_MESSAGE = "Found %s elements but none pass results filtering. Please change locator or filtering rules (JDISettings.ELEMENT.searchRule = )" + StringUtils.LINE_BREAK + "Element '%s' search during %s seconds";
    public static JAction2<JDIBase, WebElement> VALIDATE_FOUND_ELEMENT = JDIBase::validateFoundElement;
    protected JFunc<WebElement> getElementFunc = null;
    public Boolean strictSearch;
    public static JFunc1<JDIBase, String> PRINT_ELEMENT = element -> {
        if (element.webElement.hasValue()) {
            return element.printWebElement();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)element.varName)) {
            return element.context;
        }
        return (String)SwitchActions.Switch((Object)((Object)JDISettings.LOGS.logLevel)).get(new CaseR[]{SwitchActions.Case(l -> l == LogLevels.STEP, l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_ELEMENT_STEP, (Object)element)), SwitchActions.Case(l -> l == LogLevels.INFO, l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_ELEMENT_INFO, (Object)element)), SwitchActions.Case(l -> l == LogLevels.ERROR, l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_ERROR_STEP, (Object)element)), SwitchActions.Default(l -> StringUtils.msgFormat((String)OutputTemplates.PRINT_ELEMENT_DEBUG, (Object)element))});
    };
    private Safe<Actions> actions = new Safe(() -> new Actions(this.driver()));
    public ElementArea clickAreaType;
    public TextTypes textType;
    public SetTextTypes setTextType;

    @Override
    public JDIBase base() {
        return this;
    }

    public JDIBase() {
        this.clickAreaType = JDISettings.ELEMENT.clickType;
        this.textType = JDISettings.ELEMENT.getTextType;
        this.setTextType = JDISettings.ELEMENT.setTextType;
        this.searchRules.update(JDISettings.ELEMENT.searchRule);
    }

    public JDIBase(JDIBase base) {
        this();
        this.setCore(base);
    }

    public JDIBase setCore(JDIBase base) {
        this.locator = base.locator.copy();
        this.name = base.name;
        this.parent = base.parent;
        this.varName = base.varName;
        this.typeName = base.typeName;
        this.failElement = base.failElement;
        this.driverName = base.driverName;
        this.context = base.printFullLocator();
        this.webElement = base.webElement.copy();
        this.webElements = base.webElements.copy();
        this.searchRules = base.searchRules.copy();
        this.beforeSearch = base.beforeSearch;
        this.timeout = base.timeout;
        return this;
    }

    @Override
    public DriverBase setParent(Object parent) {
        return super.setParent(parent);
    }

    private MapArray<String, JFunc1<WebElement, Boolean>> searchRules() {
        return this.searchRules;
    }

    WebElement beforeSearch(WebElement el) {
        (this.beforeSearch == null ? JDISettings.ELEMENT.beforeSearch : this.beforeSearch).execute((Object)new UIElement(el));
        return el;
    }

    public JDIBase doBefore(JAction1<UIElement> action) {
        this.beforeSearch = action;
        return this;
    }

    public JDIBase showBefore() {
        this.beforeSearch = UIElement::show;
        return this;
    }

    public JDIBase noValidation() {
        return this.setSearchRule("Any", SearchStrategies.ANY_ELEMENT);
    }

    public <T> T noValidation(JFunc<T> func) {
        MapArray rules = this.searchRules.copy();
        this.searchRules.clear();
        Object result = func.execute();
        this.searchRules = rules;
        return (T)result;
    }

    public JDIBase searchVisible() {
        return this.setSearchRule("Visible", SearchStrategies.VISIBLE_ELEMENT);
    }

    public JDIBase visibleEnabled() {
        return this.setSearchRule("Enabled", SearchStrategies.ENABLED_ELEMENT);
    }

    public JDIBase inView() {
        this.showBefore();
        return this.setSearchRule("Element in view", SearchStrategies.ELEMENT_IN_VIEW);
    }

    public JDIBase addSearchRule(String name, JFunc1<WebElement, Boolean> rule) {
        this.searchRules.add((Object)name, rule);
        return this;
    }

    public JDIBase setSearchRule(String name, JFunc1<WebElement, Boolean> rule) {
        this.searchRules.clear();
        this.searchRules.add((Object)name, rule);
        return this;
    }

    public JDIBase setWebElement(WebElement el) {
        this.webElement.setForce((Object)el);
        return this;
    }

    public JDIBase setWebElements(List<WebElement> els) {
        this.webElements.setForce(els);
        return this;
    }

    public JDIBase setLocator(@MarkupLocator String locator) {
        return this.setLocator(WebDriverByUtils.defineLocator(locator));
    }

    public JDIBase setLocator(@MarkupLocator By locator) {
        if (locator != null) {
            if (this.name.isEmpty()) {
                this.name = WebDriverByUtils.shortBy(locator, this);
            }
            this.locator.add(locator, this);
        }
        return this;
    }

    public JDIBase setFrames(List<By> frames) {
        if (this.name.isEmpty() && frames.size() > 0) {
            this.name = WebDriverByUtils.shortBy(frames.get(0));
        }
        this.locator.add(frames, this);
        return this;
    }

    public By getLocator(Object ... args) {
        this.initContext();
        return this.locator.getLocator(args);
    }

    public List<By> getFrames() {
        return this.locator.getFrames();
    }

    public IBaseElement waitAfter(int timeout, String methodName) {
        if (timeout > 0) {
            this.waitAfterTimeout = timeout;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)methodName)) {
            this.waitAfterMethod = methodName;
        }
        return this;
    }

    public Pair<String, Integer> waitAfter() {
        return new Pair((Object)this.waitAfterMethod, (Object)this.waitAfterTimeout);
    }

    @Override
    public IBaseElement waitSec(int sec) {
        this.timeout = sec;
        return this;
    }

    public int getTimeout() {
        return this.timeout > -1 ? this.timeout : JDISettings.TIMEOUTS.element.get();
    }

    public Timer timer() {
        return new Timer((long)(this.getTimeout() * 1000));
    }

    @Override
    public JDIBase setName(String name) {
        this.name = name;
        this.varName = name;
        this.failElement = name;
        return this;
    }

    @JDIAction(value="{0}", timeout=0)
    public void visualCheck(String message) {
    }

    public WebElement getWebElement() {
        return this.get(new Object[0]);
    }

    public WebElement get() {
        WebElement element = this.get(new Object[0]);
        VALIDATE_FOUND_ELEMENT.execute((Object)this, (Object)element);
        return element;
    }

    private static void validateFoundElement(JDIBase base, WebElement element) {
        for (JFunc1 rule : base.searchRules().values()) {
            if (((Boolean)rule.execute((Object)element)).booleanValue()) continue;
            throw Exceptions.exception("Search rules failed for element. Please check base().searchRules() for element or in global settings(JDISettings.ELEMENT.searchRule)", new Object[0]);
        }
    }

    public JDIBase setGetFunc(JFunc<WebElement> func) {
        this.getElementFunc = func;
        return this;
    }

    private WebElement purify(WebElement element) {
        return ReflectionUtils.isInterface(element.getClass(), IBaseElement.class) ? ((IBaseElement)element).base().get() : element;
    }

    private UIElement getUIElementByLocator(WebElement element) {
        return new UIElement(element).find(this.getLocator(new Object[0])).setup((JAction1<JDIBase>)((JAction1)b -> {
            b.searchRules = this.searchRules;
            b.timeout = this.timeout;
        }));
    }

    public WebElement get(Object ... args) {
        return (WebElement)JDISettings.ELEMENT.getElementWithArgs.execute((Object)this, (Object)args);
    }

    UIElement getWebListFromArgs(Object ... args) {
        if (this.locator.argsCount() == 0 && args.length == 1) {
            if (args[0].getClass() == String.class) {
                return new WebList(this).get(args[0].toString());
            }
            if (ReflectionUtils.isClass(args[0].getClass(), Enum.class)) {
                return new WebList(this).get(EnumUtils.getEnumValue((Enum)((Enum)args[0])));
            }
        }
        throw Exceptions.exception("Can't get element with template locator '%s'. Expected %s arguments but found %s", this.getLocator(new Object[0]), this.locator.argsCount(), args.length);
    }

    WebElement getCachedElement() {
        WebElement element = this.purify((WebElement)this.webElement.get());
        try {
            element.getTagName();
            if (this.locator.isNull()) {
                return element;
            }
            return this.purify(this.getUIElementByLocator(element));
        }
        catch (Exception ignore) {
            if (this.getElementFunc == null) {
                this.webElement.clear();
                return null;
            }
            return (WebElement)this.webElement.set((Object)this.purify((WebElement)this.getElementFunc.execute()));
        }
    }

    public void strictSearch(boolean strictSearch) {
        this.strictSearch = strictSearch;
    }

    WebElement getElement(List<WebElement> els) {
        if (els.size() == 1) {
            return els.get(0);
        }
        if (els.isEmpty()) {
            throw Exceptions.exception(FAILED_TO_FIND_ELEMENT_MESSAGE, this.toString(), this.getTimeout());
        }
        List<WebElement> filtered = this.filterElements(els);
        if (filtered.size() == 1) {
            return filtered.get(0);
        }
        if (this.strictSearch == null && WebSettings.STRICT_SEARCH || this.strictSearch != null && this.strictSearch.booleanValue()) {
            throw Exceptions.exception(FIND_TO_MUCH_ELEMENTS_MESSAGE, els.size(), this.toString(), this.getTimeout());
        }
        return (filtered.size() > 1 ? filtered : els).get(0);
    }

    private List<WebElement> filterElements(List<WebElement> elements) {
        if (elements.size() == 0) {
            return new ArrayList<WebElement>();
        }
        List result = elements;
        for (JFunc1 rule : this.searchRules().values()) {
            result = LinqUtils.filter(result, arg_0 -> ((JFunc1)rule).execute(arg_0));
        }
        if (result.size() == 0 && this.textType == TextTypes.LABEL) {
            return elements;
        }
        return result;
    }

    public WebElement getSmart() {
        try {
            WebElement element = (WebElement)WebSettings.SMART_SEARCH.execute((Object)this);
            if (element != null) {
                return element;
            }
            throw Exceptions.exception("", new Object[0]);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, FAILED_TO_FIND_ELEMENT_MESSAGE, this.toString(), this.getTimeout());
        }
    }

    public List<WebElement> getWebElements(Object ... args) {
        return (List)this.noValidation(() -> this.getAll(args));
    }

    public List<WebElement> getAll(Object ... args) {
        return this.getAllElements(args);
    }

    public List<WebElement> getAllElements(Object ... args) {
        this.getDefaultContext();
        if (this.webElements.hasValue()) {
            List elements = LinqUtils.map((Collection)((Collection)this.webElements.get()), this::purify);
            try {
                this.beforeSearch((WebElement)elements.get(0)).getTagName();
                return elements;
            }
            catch (Exception ignore) {
                this.webElements.clear();
            }
        }
        if (this.locator.isNull()) {
            return Collections.singletonList(this.beforeSearch(this.getSmart()));
        }
        SearchContext searchContext = this.getContext(this.parent, this.locator);
        List<WebElement> result = WebDriverByUtils.uiSearch(searchContext, this.correctLocator(this.getLocator(args)));
        if (result.size() > 0) {
            this.beforeSearch(result.get(0));
        }
        return result;
    }

    public WebElement getFast() {
        return this.getEl(this.getContext(this.parent, this.locator));
    }

    public List<WebElement> getListFast() {
        return this.getEls(this.getContext(this.parent, this.locator));
    }

    public WebElement seleniumElement() {
        return this.getEl((SearchContext)this.driver());
    }

    public List<WebElement> seleniumList() {
        return this.getEls((SearchContext)this.driver());
    }

    private WebElement getEl(SearchContext ctx) {
        return ctx.findElement(WebDriverByUtils.correctXPaths(this.getLocator(new Object[0])));
    }

    private List<WebElement> getEls(SearchContext ctx) {
        return ctx.findElements(WebDriverByUtils.correctXPaths(this.getLocator(new Object[0])));
    }

    public List<WebElement> getList(int minAmount) {
        List result = (List)this.timer().getResultByCondition(this::tryGetList, els -> els.size() >= minAmount);
        if (result == null) {
            throw Exceptions.exception("Expected at least %s elements but failed (%s)", minAmount, this.toString());
        }
        return this.filterElements(result);
    }

    protected List<WebElement> tryGetList() {
        List<WebElement> elements = this.getAll(new Object[0]);
        if (elements == null) {
            throw Exceptions.exception("No elements found (%s)", this.toString());
        }
        if (elements.size() == 1) {
            elements = this.processListTag(elements);
        }
        return elements;
    }

    protected List<WebElement> processListTag(List<WebElement> elements) {
        String tagName;
        WebElement element = elements.get(0);
        switch (tagName = element.getTagName()) {
            case "ul": {
                return element.findElements(By.tagName((String)"li"));
            }
            case "select": {
                return element.findElements(By.tagName((String)"option"));
            }
        }
        return elements;
    }

    public WebList list(Object ... args) {
        return UIFactory.$$(this.getAll(args), this.getName());
    }

    public <TE extends IBaseElement> void waitAction(int sec, JAction1<TE> action, Class<TE> type) {
        this.waitFunc(sec, j -> {
            action.execute(j);
            return this;
        }, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TE extends IBaseElement, TR> TR waitFunc(int sec, JFunc1<TE, TR> action, Class<TE> type) {
        Object result;
        int temp = this.getTimeout();
        try {
            this.waitSec(sec);
            result = action.execute((Object)this);
        }
        finally {
            this.waitSec(temp);
            this.dropToGlobalTimeout();
        }
        return (TR)result;
    }

    public <T> T waitFunc(int sec, JFunc<T> func) {
        return (T)this.waitFunc(sec, j -> func.execute(), IBaseElement.class);
    }

    public <T> T noWait(JFunc<T> func) {
        return this.waitFunc(0, func);
    }

    public <T> T noWait() {
        return (T)this.waitSec(0);
    }

    public <TE extends IBaseElement, TR> TR noWait(JFunc1<TE, TR> action, Class<TE> type) {
        return this.waitFunc(0, action, type);
    }

    public void dropToGlobalTimeout() {
        this.waitSec(JDISettings.TIMEOUTS.element.get());
    }

    private JDIBase getBase(Object element) {
        if (ReflectionUtils.isClass(element.getClass(), JDIBase.class)) {
            return (JDIBase)element;
        }
        if (ReflectionUtils.isInterface(element.getClass(), IBaseElement.class)) {
            return ((IBaseElement)element).base();
        }
        return null;
    }

    private SearchContext getSearchContext(Object parent) {
        JDIBase base = this.getBase(parent);
        if (base == null) {
            return this.getDefaultContext();
        }
        if (base.webElement.hasValue()) {
            return (SearchContext)base.webElement.get();
        }
        if (base.locator.isRoot() && base.locator.isNull()) {
            return this.getDefaultContext();
        }
        List<By> frames = base.getFrames();
        if (frames != null) {
            return this.getFrameContext(frames);
        }
        By byLocator = base.getLocator(new Object[0]);
        IBaseElement asBaseElement = (IBaseElement)parent;
        return byLocator == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)WebDriverByUtils.getByLocator(byLocator)) ? this.getSmartSearchContext(asBaseElement) : this.getContextByLocator(base, byLocator);
    }

    private SearchContext getContextByLocator(JDIBase base, By locator) {
        List<WebElement> els = WebDriverByUtils.uiSearch(this.getContext(base.parent, base.locator), this.correctLocator(locator));
        return this.getElement(els);
    }

    private SearchContext getSmartSearchContext(IBaseElement bElement) {
        try {
            WebElement result = (WebElement)WebSettings.SMART_SEARCH.execute((Object)bElement);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getContext(bElement.base().parent, bElement.base().locator);
    }

    private boolean isRoot(Object parent) {
        return parent == null || ReflectionUtils.isClass(parent.getClass(), WebPage.class) || !ReflectionUtils.isInterface(parent.getClass(), JDIElement.class);
    }

    public boolean hasLocator() {
        return !this.locator.isNull();
    }

    private SearchContext getContext(Object parent, JDILocator locator) {
        List<By> frames = this.getFrames();
        if (frames != null) {
            return this.getFrameContext(frames);
        }
        return locator.isRoot || this.isRoot(parent) ? this.getDefaultContext() : this.getSearchContext(parent);
    }

    private SearchContext getFrameContext(List<By> frames) {
        WebDriver driver = this.driver();
        for (By frame : frames) {
            try {
                driver = driver.switchTo().frame(WebDriverByUtils.uiSearch((SearchContext)driver, this.getFrameLocator(frame, driver)).get(0));
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Can't find frame by locator: '%s'", frame);
            }
        }
        return driver;
    }

    private By getFrameLocator(By frame, WebDriver driver) {
        try {
            driver.findElement(frame).getTagName();
            return frame;
        }
        catch (Exception ignore) {
            return By.id((String)WebDriverByUtils.getByLocator(frame));
        }
    }

    private SearchContext getDefaultContext() {
        return this.driver().switchTo().defaultContent();
    }

    private By correctLocator(By locator) {
        if (locator == null) {
            return null;
        }
        return WebDriverByUtils.correctXPaths(locator);
    }

    public String printContext() {
        JDIBase jdiBase = this.getBase(this.parent);
        if (jdiBase == null) {
            return "";
        }
        String locator = jdiBase.locator.printLocator();
        if (jdiBase.parent == null) {
            return locator;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)locator)) {
            return jdiBase.printContext();
        }
        return jdiBase.printContext() + ">" + locator;
    }

    public String printFullLocator() {
        return this.parent == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.printContext()) ? this.locator.printLocator() : this.printContext() + ">" + this.locator.printLocator();
    }

    private void initContext() {
        this.context = this.printFullLocator();
    }

    public String toString() {
        this.initContext();
        try {
            return (String)PRINT_ELEMENT.execute((Object)this);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't print element", new Object[0]);
        }
    }

    public static String printWebElement(WebElement element) {
        String result;
        String asString = element.toString().replaceAll("css selector", "css");
        String string = result = asString.startsWith("WebElement->") ? "" : "WebElement->";
        if (asString.contains(")]")) {
            String s = asString.substring(asString.indexOf("-> ") + 3).replaceAll("]* -> ", "->");
            return result + s.substring(0, s.length() - 1);
        }
        return asString;
    }

    public String printWebElement() {
        if (this.webElement.hasValue()) {
            return JDIBase.printWebElement((WebElement)this.webElement.get());
        }
        if (this.webElements.hasValue() && ((List)this.webElements.get()).size() > 0) {
            return JDIBase.printWebElement((WebElement)((List)this.webElements.get()).get(0));
        }
        return "";
    }

    public void actions(JFunc2<Actions, WebElement, Actions> action) {
        ((Actions)action.execute((Object)((Actions)this.actions.get()), (Object)this.get())).build().perform();
    }

    public void actions(JFunc1<Actions, Actions> action) {
        ((Actions)action.execute((Object)((Actions)this.actions.get()))).build().perform();
    }

    public void actionsWithElement(JFunc2<Actions, WebElement, Actions> action) {
        ((Actions)action.execute((Object)((Actions)this.actions.get()).moveToElement(this.get()), (Object)this.get())).build().perform();
    }

    public void actionsWithElement(JFunc1<Actions, Actions> action) {
        ((Actions)action.execute((Object)((Actions)this.actions.get()).moveToElement(this.get()))).build().perform();
    }

    @Override
    public void offCache() {
        this.webElement.useCache(false);
        this.webElements.useCache(false);
    }

    @Override
    public boolean isUseCache() {
        return this.webElement.isUseCache() || this.webElements.isUseCache();
    }
}

