/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.settings.JDISettings;
import org.apache.commons.lang3.StringUtils;

public class RemoteDriver {
    public static String seleniumLocalhost() {
        return RemoteDriver.getRemoteURL("http://localhost:4444/");
    }

    public static String sauceLabs() {
        return RemoteDriver.getRemoteURL("http://ondemand.eu-central-1.saucelabs.com/");
    }

    public static String browserstack() {
        return RemoteDriver.browserstack(System.getenv("USERNAME"), System.getenv("ACCESS_KEY"));
    }

    public static String browserstack(String userName, String accessKey) {
        return RemoteDriver.getRemoteURL(String.format("https://%s:%s/@hub-cloud.browserstack.com/", userName, accessKey));
    }

    public static String appium() {
        return RemoteDriver.getRemoteURL("http://0.0.0.0:4723/");
    }

    public static String getRemoteURL() {
        return RemoteDriver.getRemoteURL(JDISettings.DRIVER.remoteUrl);
    }

    public static String getRemoteURL(String remoteUrl) {
        try {
            if (!StringUtils.isBlank((CharSequence)remoteUrl)) {
                String url = remoteUrl.replaceAll("/+$", "/");
                if (!url.contains("wd/hub")) {
                    url = url + "wd/hub/";
                }
                return url;
            }
            throw Exceptions.exception("You run tests in Remote mode, please specify 'driver.remote.url' in test.properties", new Object[0]);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get remote Url", new Object[0]);
        }
    }
}

