/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.get.DownloadDriverManager;
import com.epam.jdi.light.driver.get.DriverData;
import com.epam.jdi.light.driver.get.DriverTypes;
import com.epam.jdi.light.driver.get.DriverVersion;
import com.epam.jdi.light.driver.get.OsTypes;
import com.epam.jdi.light.driver.get.Platform;
import com.epam.jdi.light.driver.get.RemoteDriver;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.DataClass;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.func.JFunc1;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DriverInfo
extends DataClass<DriverInfo> {
    public DriverTypes downloadType;
    public MutableCapabilities initCapabilities = new DesiredCapabilities();
    public JFunc1<MutableCapabilities, Capabilities> capabilities = c -> c;
    public JFunc<String> path;
    public String properties;
    public JFunc1<Capabilities, WebDriver> getDriver;
    public JFunc1<Capabilities, WebDriver> getRemoteDriver;

    public boolean isLocal() {
        return !JDISettings.DRIVER.remoteRun;
    }

    public WebDriver getDriver() {
        WebSettings.logger.debug("getDriver(): " + this.toString(), new Object[0]);
        return this.isLocal() ? this.setupLocal() : this.setupRemote();
    }

    private Capabilities getCapabilities() {
        return (Capabilities)this.capabilities.execute((Object)this.initCapabilities);
    }

    private WebDriver setupRemote() {
        try {
            WebSettings.logger.debug("setupRemote()", new Object[0]);
            Capabilities caps = this.getCapabilities();
            if (this.getRemoteDriver != null) {
                WebSettings.logger.debug("getRemoteDriver.execute(caps: %s)", caps);
                return (WebDriver)this.getRemoteDriver.execute((Object)caps);
            }
            WebSettings.logger.debug("new RemoteWebDriver(url:%s, caps: %s)", RemoteDriver.getRemoteURL(), caps);
            return new RemoteWebDriver(new URL(RemoteDriver.getRemoteURL()), caps);
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "Failed to setup remote " + this.downloadType.name + " driver", new Object[0]);
        }
    }

    private Platform getDriverPlatform() {
        if (JDISettings.DRIVER.platform != null) {
            return JDISettings.DRIVER.platform;
        }
        if (DriverData.getOs() == OsTypes.WIN || System.getProperty("os.arch").contains("32")) {
            return Platform.X32;
        }
        if (System.getProperty("os.arch").contains("64")) {
            return Platform.X64;
        }
        throw Exceptions.exception("Unknown driver platform: %s. Only X32 or X64 allowed. Please specify exact platform in JDISettings.DRIVER.platform", System.getProperty("os.arch"));
    }

    private WebDriver setupLocal() {
        try {
            boolean emptyDriverPath = StringUtils.isBlank((CharSequence)JDISettings.DRIVER.path);
            WebSettings.logger.debug("setupLocal(): isBlank(DRIVER.path)=" + emptyDriverPath, new Object[0]);
            String driverPath = emptyDriverPath ? DownloadDriverManager.downloadDriver(this.downloadType, this.getDriverPlatform(), JDISettings.DRIVER.version) : (String)this.path.execute();
            WebSettings.logger.info("Use driver path: " + driverPath, new Object[0]);
            WebSettings.logger.debug("setProperty(properties:%s, driverPath:%s)", this.properties, driverPath);
            System.setProperty(this.properties, driverPath);
            Capabilities caps = this.getCapabilities();
            WebSettings.logger.debug("getDriver.execute(getCapabilities())", caps);
            return (WebDriver)this.getDriver.execute((Object)caps);
        }
        catch (Throwable ex) {
            try {
                if (StringUtils.isBlank((CharSequence)JDISettings.DRIVER.path) && JDISettings.DRIVER.version.equals(DriverVersion.LATEST.value)) {
                    WebSettings.logger.info("Failed to download driver (%s %s) of latest version:TRY TO GET DRIVER PREVIOUS VERSION", new Object[]{this.downloadType, JDISettings.DRIVER.version});
                    try {
                        DownloadDriverManager.downloadDriver(this.downloadType, this.getDriverPlatform(), DriverInfo.getBelowVersion());
                        return (WebDriver)this.getDriver.execute((Object)this.getCapabilities());
                    }
                    catch (Throwable ex2) {
                        throw Exceptions.exception(ex2, "Failed to download driver", new Object[0]);
                    }
                }
                throw Exceptions.exception(Exceptions.safeException(ex), new Object[0]);
            }
            catch (Throwable ex2) {
                throw Exceptions.exception(ex2, "Failed to setup local driver", new Object[0]);
            }
        }
    }

    public static String getBelowVersion() {
        String currentMajor = DownloadDriverManager.wdm.getDownloadedDriverVersion().split("\\.")[0];
        List allVersions = DownloadDriverManager.wdm.getDriverVersions();
        for (int i = allVersions.size() - 1; i >= 0; --i) {
            if (Integer.parseInt(currentMajor) <= Integer.parseInt(((String)allVersions.get(i)).split("\\.")[0])) continue;
            return (String)allVersions.get(i);
        }
        throw Exceptions.exception("Can't find version below current(" + DownloadDriverManager.wdm.getDownloadedDriverVersion() + ")", new Object[0]);
    }

    public String toString() {
        return String.format("DriverInfo:[downloadType: %s; initCapabilities: %s; path: %s; properties: %s]", this.downloadType.name, this.initCapabilities, this.path.execute(), this.properties);
    }
}

