/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.get.OsTypes;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.PathUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JAction;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.switcher.CaseR;
import com.epam.jdi.tools.switcher.SwitchActions;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang3.ObjectUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Point;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.safari.SafariOptions;

public class DriverData {
    public static final String DEFAULT_DRIVER = "chrome";
    public static String ARGUMENTS_PROPERTY = "arguments";
    public static List<String> setupErrors = new ArrayList<String>();
    public static JAction1<ChromeOptions> CHROME_OPTIONS = DriverData::defaultChromeOptions;
    public static JAction1<FirefoxOptions> FIREFOX_OPTIONS = DriverData::defaultFirefoxOptions;
    public static JAction1<InternetExplorerOptions> IE_OPTIONS = DriverData::defaultIEOptions;
    public static JAction1<EdgeOptions> EDGE_OPTIONS = DriverData::defaultEdgeOptions;
    public static JAction1<OperaOptions> OPERA_OPTIONS = DriverData::defaultOperaOptions;
    public static JAction1<SafariOptions> SAFARI_OPTIONS = DriverData::defaultSafariOptions;

    public static String getDriverFolder() {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)JDISettings.DRIVER.path) && !JDISettings.DRIVER.path.equalsIgnoreCase("default") ? JDISettings.DRIVER.path : PathUtils.mergePath((String)JDISettings.COMMON.testPath, (String[])new String[]{"resources", "drivers"});
    }

    public static String chromeDriverPath() {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{DriverData.getOs() == OsTypes.WIN ? "chromedriver.exe" : "chromedriver"});
    }

    public static String ieDriverPath() {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{"IEDriverServer.exe"});
    }

    public static String edgeDriverPath() {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{"MicrosoftWebDriver.exe"});
    }

    public static String operaDriverPath() {
        return DriverData.driverPath("operadriver");
    }

    public static String safariDriverPath() {
        return DriverData.driverPath("safaridriver");
    }

    public static String firefoxDriverPath() {
        return DriverData.driverPath("geckodriver");
    }

    private static String driverPath(String driverName) {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{DriverData.getOs() == OsTypes.WIN ? driverName + ".exe" : driverName});
    }

    public static OsTypes getOs() {
        if (JDISettings.DRIVER.os != null) {
            return JDISettings.DRIVER.os;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        return (OsTypes)((Object)SwitchActions.Switch((Object)osName).get(new CaseR[]{SwitchActions.Case(os -> os.contains("mac"), (Object)((Object)OsTypes.MAC)), SwitchActions.Case(os -> os.contains("win") || os.contains("ms"), (Object)((Object)OsTypes.WIN)), SwitchActions.Default((Object)((Object)OsTypes.LINUX))}));
    }

    public static WebDriver driverSettings(WebDriver driver) {
        if (JDISettings.DRIVER.screenSize.maximize) {
            if (DriverData.getOs().equals((Object)OsTypes.MAC)) {
                DriverData.maximizeScreen(driver);
            } else {
                driver.manage().window().maximize();
            }
        } else {
            driver.manage().window().setSize(JDISettings.DRIVER.screenSize.asDimension());
        }
        return driver;
    }

    private static WebDriver setBrowserSizeForMac(WebDriver driver, int width, int height) {
        try {
            Point position = new Point(0, 0);
            driver.manage().window().setPosition(position);
            driver.manage().window().setSize(new org.openqa.selenium.Dimension(width, height));
            return driver;
        }
        catch (Exception ex) {
            WebSettings.logger.error("Failed to Set resolution (%s, %s): %s", width, height, Exceptions.safeException(ex));
            throw ex;
        }
    }

    public static MutableCapabilities getCapabilities(MutableCapabilities capabilities, JAction1<MutableCapabilities> defaultCapabilities) {
        try {
            setupErrors.clear();
            defaultCapabilities.execute((Object)capabilities);
        }
        catch (Throwable ex) {
            setupErrors.add("Setup capabilities exception: " + Exceptions.safeException(ex));
        }
        if (ObjectUtils.isNotEmpty(setupErrors)) {
            WebSettings.logger.info("Failed to set Default Capabilities for Driver:", new Object[0]);
            WebSettings.logger.info("Errors: " + PrintUtils.print(setupErrors, (String)StringUtils.LINE_BREAK), new Object[0]);
            setupErrors.clear();
        }
        try {
            JDISettings.DRIVER.capabilities.common.forEach((arg_0, arg_1) -> ((MutableCapabilities)capabilities).setCapability(arg_0, arg_1));
        }
        catch (Throwable ex) {
            WebSettings.logger.info("Failed to set COMMON_CAPABILITIES Capabilities for Driver: " + Exceptions.safeException(ex), new Object[0]);
        }
        return capabilities;
    }

    public static void setUp(String name, JAction action) {
        try {
            action.invoke();
        }
        catch (Throwable ex) {
            setupErrors.add(String.format("%s: %s", name, Exceptions.safeException(ex)));
        }
    }

    public static void defaultChromeOptions(ChromeOptions cap) {
        HashMap chromePrefs = new HashMap();
        DriverData.setUp("Set Chrome Prefs", () -> {
            chromePrefs.put("credentials_enable_service", false);
            new File(JDISettings.DRIVER.downloadsFolder).mkdirs();
            chromePrefs.put("download.default_directory", JDISettings.DRIVER.downloadsFolder);
            chromePrefs.put("profile.default_content_setting_values.notifications", 0);
            chromePrefs.put("profile.default_content_settings.popups", 0);
            chromePrefs.put("profile.password_manager_enabled", false);
        });
        DriverData.setUp("Chrome: '--disable-web-security', '--disable-extensions', 'test-type'", () -> cap.addArguments(new String[]{"--disable-web-security", "--disable-extensions", "test-type"}));
        DriverData.setUp("Chrome: PageLoadStrategy:" + JDISettings.DRIVER.pageLoadStrategy, () -> cap.setPageLoadStrategy(JDISettings.DRIVER.pageLoadStrategy));
        DriverData.setUp("Chrome: ACCEPT_SSL_CERTS:true", () -> cap.setCapability("acceptSslCerts", true));
        DriverData.setUp("Chrome: unexpectedAlertBehaviour=" + UnexpectedAlertBehaviour.ACCEPT, () -> cap.setCapability("unexpectedAlertBehaviour", (Object)UnexpectedAlertBehaviour.ACCEPT));
        DriverData.setUp("Chrome: setExperimentalOption: prefs", () -> cap.setExperimentalOption("prefs", (Object)chromePrefs));
        DriverData.setUp("Chrome: setExperimentalOption: prefs", () -> {
            LoggingPreferences logPrefs = new LoggingPreferences();
            logPrefs.enable("performance", Level.ALL);
            cap.setCapability("loggingPrefs", (Object)logPrefs);
        });
        JDISettings.DRIVER.capabilities.chrome.forEach((property, value) -> DriverData.setupCapability(cap, property, value));
    }

    public static void setupCapability(ChromeOptions cap, String property, String value) {
        if (!property.equals(ARGUMENTS_PROPERTY)) {
            cap.setCapability(property, ReflectionUtils.stringToPrimitive((String)value));
        } else {
            cap.addArguments(value.split(" "));
        }
    }

    public static void defaultFirefoxOptions(FirefoxOptions cap) {
        FirefoxProfile firefoxProfile = new FirefoxProfile();
        DriverData.setUp("Set FirefoxProfile", () -> {
            firefoxProfile.setAssumeUntrustedCertificateIssuer(false);
            firefoxProfile.setPreference("browser.download.folderList", 2);
            firefoxProfile.setPreference("browser.download.manager.showWhenStarting", false);
            firefoxProfile.setPreference("browser.helperApps.alwaysAsk.force", false);
            firefoxProfile.setPreference("browser.helperApps.neverAsk.saveToDisk", "application/xls;text/csv;text/plain");
            firefoxProfile.setPreference("browser.download.dir", JDISettings.DRIVER.downloadsFolder);
            firefoxProfile.setPreference("print.always_print_silent", "true");
            firefoxProfile.setPreference("print.show_print_progress", "false");
            firefoxProfile.setPreference("browser.startup.homepage", "about:blank");
            firefoxProfile.setPreference("startup.homepage_welcome_url", "about:blank");
            firefoxProfile.setPreference("startup.homepage_welcome_url.additional", "about:blank");
            firefoxProfile.setPreference("network.http.phishy-userpass-length", 255);
        });
        DriverData.setUp("Firefox: PageLoadStrategy:" + JDISettings.DRIVER.pageLoadStrategy, () -> cap.setPageLoadStrategy(JDISettings.DRIVER.pageLoadStrategy));
        DriverData.setUp("Firefox: ACCEPT_SSL_CERTS: true", () -> cap.setCapability("acceptSslCerts", true));
        DriverData.setUp("Firefox: UNEXPECTED_ALERT_BEHAVIOR, ACCEPT", () -> cap.setCapability("unexpectedAlertBehaviour", (Object)UnexpectedAlertBehaviour.ACCEPT));
        DriverData.setUp("Firefox: Firefox Profile", () -> cap.setProfile(firefoxProfile));
        JDISettings.DRIVER.capabilities.firefox.forEach((arg_0, arg_1) -> ((FirefoxOptions)cap).setCapability(arg_0, arg_1));
    }

    public static void defaultIEOptions(InternetExplorerOptions cap) {
        DriverData.setUp("IE: introduceFlakinessByIgnoringSecurityDomains", () -> ((InternetExplorerOptions)cap).introduceFlakinessByIgnoringSecurityDomains());
        DriverData.setUp("ignoreZoomSettings", () -> ((InternetExplorerOptions)cap).ignoreZoomSettings());
        DriverData.setUp("IE: requireWindowFocus:true", () -> cap.setCapability("requireWindowFocus", true));
        DriverData.setUp("IE: PageLoadStrategy:" + JDISettings.DRIVER.pageLoadStrategy, () -> cap.setPageLoadStrategy(JDISettings.DRIVER.pageLoadStrategy));
        DriverData.setUp("IE: takeFullPageScreenshot", () -> ((InternetExplorerOptions)cap).takeFullPageScreenshot());
        DriverData.setUp("IE: ACCEPT_SSL_CERTS: true", () -> cap.setCapability("acceptSslCerts", true));
        DriverData.setUp("IE: destructivelyEnsureCleanSession", () -> ((InternetExplorerOptions)cap).destructivelyEnsureCleanSession());
        DriverData.setUp("IE: UNEXPECTED_ALERT_BEHAVIOR: ACCEPT)", () -> cap.setCapability("unexpectedAlertBehaviour", (Object)UnexpectedAlertBehaviour.ACCEPT));
        DriverData.setUp("IE: SUPPORTS_JAVASCRIPT", () -> cap.is("javascriptEnabled"));
        DriverData.setUp("IE: ACCEPT_SSL_CERTS: true", () -> cap.setCapability("acceptSslCerts", true));
        JDISettings.DRIVER.capabilities.ie.forEach((arg_0, arg_1) -> ((InternetExplorerOptions)cap).setCapability(arg_0, arg_1));
    }

    public static void defaultEdgeOptions(EdgeOptions cap) {
        JDISettings.DRIVER.capabilities.ieEdge.forEach((arg_0, arg_1) -> ((EdgeOptions)cap).setCapability(arg_0, arg_1));
    }

    public static void defaultOperaOptions(OperaOptions cap) {
        JDISettings.DRIVER.capabilities.opera.forEach((arg_0, arg_1) -> ((OperaOptions)cap).setCapability(arg_0, arg_1));
    }

    public static void defaultSafariOptions(SafariOptions cap) {
        JDISettings.DRIVER.capabilities.safari.forEach((arg_0, arg_1) -> ((SafariOptions)cap).setCapability(arg_0, arg_1));
    }

    private static WebDriver maximizeScreen(WebDriver driver) {
        try {
            switch (DriverData.getOs()) {
                case WIN: 
                case LINUX: {
                    driver.manage().window().maximize();
                    break;
                }
                case MAC: {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    DriverData.setBrowserSizeForMac(driver, (int)screenSize.getWidth(), (int)screenSize.getHeight());
                }
            }
            return driver;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Failed to maximize window", new Object[0]);
        }
    }
}

