/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.map.MapArray;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Quotes;

public final class WebDriverByUtils {
    private static MapArray<String, String> byReplace = new MapArray((Object[][])new Object[][]{{"cssSelector", "css"}, {"tagName", "tag"}, {"className", "class"}});

    private WebDriverByUtils() {
    }

    public static Function<String, By> getByFunc(By by) {
        return (Function)LinqUtils.first(WebDriverByUtils.getMapByTypes(), key -> by.toString().contains((CharSequence)key));
    }

    private static String getBadLocatorMsg(String byLocator, Object ... args) {
        return "Bad locator template '" + byLocator + "'. Args: " + PrintUtils.print((Collection)LinqUtils.select((Object[])args, Object::toString), (String)", ", (String)"'%s'") + ".";
    }

    public static By fillByTemplate(By by, Object ... args) {
        String byLocator = WebDriverByUtils.getByLocator(by);
        if (!byLocator.contains("%")) {
            throw new RuntimeException(WebDriverByUtils.getBadLocatorMsg(byLocator, args));
        }
        try {
            byLocator = String.format(byLocator, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(WebDriverByUtils.getBadLocatorMsg(byLocator, args));
        }
        return WebDriverByUtils.getByFunc(by).apply(byLocator);
    }

    public static By fillByMsgTemplate(By by, Object ... args) {
        String byLocator = WebDriverByUtils.getByLocator(by);
        try {
            byLocator = MessageFormat.format(byLocator, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(WebDriverByUtils.getBadLocatorMsg(byLocator, args));
        }
        return WebDriverByUtils.getByFunc(by).apply(byLocator);
    }

    public static By copyBy(By by) {
        String byLocator = WebDriverByUtils.getByLocator(by);
        return WebDriverByUtils.getByFunc(by).apply(byLocator);
    }

    public static String getByLocator(By by) {
        if (by == null) {
            return null;
        }
        String byAsString = by.toString();
        int index = byAsString.indexOf(": ") + 2;
        return byAsString.substring(index);
    }

    public static String getByName(By by) {
        Matcher m = Pattern.compile("By\\.(?<locator>[a-zA-Z]+):.*").matcher(by.toString());
        if (m.find()) {
            String result = m.group("locator");
            return byReplace.has((Object)result) ? (String)byReplace.get((Object)result) : result;
        }
        throw new RuntimeException("Can't get By name for: " + by);
    }

    public static By correctXPaths(By byValue) {
        return byValue.toString().contains("By.xpath: //") ? WebDriverByUtils.getByFunc(byValue).apply(WebDriverByUtils.getByLocator(byValue).replaceFirst("/", "./")) : byValue;
    }

    public static String shortBy(By by) {
        return WebDriverByUtils.shortBy(by, (JFunc<String>)((JFunc)() -> "No locator"));
    }

    public static String shortBy(By by, IBaseElement el) {
        return WebDriverByUtils.shortBy(by, (JFunc<String>)((JFunc)() -> WebSettings.printSmartLocators(el)));
    }

    private static String shortBy(By by, JFunc<String> noLocator) {
        return (by == null ? (String)noLocator.execute() : String.format("%s='%s'", WebDriverByUtils.getByName(by), WebDriverByUtils.getByLocator(by))).replaceAll("%s", "{{VALUE}}");
    }

    public static By getByFromString(String stringLocator) {
        if (stringLocator == null || stringLocator.equals("")) {
            throw new RuntimeException("Can't get By locator from string empty or null string");
        }
        String[] split = stringLocator.split("(^=)*=.*");
        if (split.length == 1) {
            return WebDriverByUtils.defineLocator(split[0]);
        }
        switch (split[0]) {
            case "css": {
                return By.cssSelector((String)split[1]);
            }
            case "xpath": {
                return By.xpath((String)split[1]);
            }
            case "class": {
                return By.className((String)split[1]);
            }
            case "name": {
                return By.name((String)split[1]);
            }
            case "id": {
                return By.id((String)split[1]);
            }
            case "tag": {
                return By.tagName((String)split[1]);
            }
            case "link": {
                return By.partialLinkText((String)split[1]);
            }
        }
        throw new RuntimeException(String.format("Can't get By locator from string: %s. Bad suffix: %s. (available: css, xpath, class, id, name, link, tag)", stringLocator, split[0]));
    }

    private static Map<String, Function<String, By>> getMapByTypes() {
        HashMap<String, Function<String, By>> map = new HashMap<String, Function<String, By>>();
        map.put("By.cssSelector", By::cssSelector);
        map.put("By.className", By::className);
        map.put("By.id", By::id);
        map.put("By.linkText", By::linkText);
        map.put("By.name", By::name);
        map.put("By.partialLinkText", By::partialLinkText);
        map.put("By.tagName", By::tagName);
        map.put("By.xpath", By::xpath);
        return map;
    }

    public static List<WebElement> uiSearch(By by) {
        return WebDriverByUtils.uiSearch((SearchContext)WebDriverFactory.getDriver(), by);
    }

    public static List<WebElement> uiSearch(SearchContext ctx, By by) {
        List<WebElement> els = null;
        for (Object step : WebDriverByUtils.searchBy(by)) {
            els = WebDriverByUtils.getEls(step, ctx, els);
        }
        return els;
    }

    private static List<WebElement> getEls(Object step, SearchContext ctx, List<WebElement> els) {
        if (ReflectionUtils.isClass(step.getClass(), By.class)) {
            String byName = WebDriverByUtils.getByName((By)step);
            if (byName.equals("id") || byName.equals("css") && WebDriverByUtils.getByLocator((By)step).matches("^#[a-zA-Z-]+$")) {
                return WebDriverFactory.getDriver().findElements((By)step);
            }
            return els == null ? ctx.findElements((By)step) : LinqUtils.selectMany(els, e -> e.findElements((By)step));
        }
        if (ReflectionUtils.isClass(step.getClass(), Integer.class) && els != null) {
            return Collections.singletonList(els.get((Integer)step - 1));
        }
        throw Exceptions.exception("Unknown locator part '%s'. Can't get element. Please correct locator", new Object[0]);
    }

    public static List<Object> searchBy(By by) {
        try {
            if (!WebDriverByUtils.getByName(by).equals("css")) {
                return Collections.singletonList(by);
            }
            String locator = WebDriverByUtils.getByLocator(by);
            List<By> result = WebDriverByUtils.replaceUp(locator);
            result = WebDriverByUtils.replaceText(result);
            return (List)LinqUtils.valueOrDefault(WebDriverByUtils.replaceChildren(result), WebDriverByUtils.one(by));
        }
        catch (Exception ex) {
            throw new RuntimeException("Search By failed");
        }
    }

    public static By defineLocator(String locator) {
        String by;
        String string = by = locator.contains("*root*") ? locator.replaceAll("\\*root\\*", "") : locator;
        if (Strings.isBlank((String)by)) {
            return By.cssSelector((String)"");
        }
        if (by.length() == 1) {
            return By.cssSelector((String)locator);
        }
        if (by.matches("\\*=.*")) {
            return WebDriverByUtils.withText(by.substring(2));
        }
        if (by.matches("=.*")) {
            return WebDriverByUtils.byText(by.substring(1));
        }
        return by.substring(0, 2).contains("/") || by.contains("..") || by.charAt(0) == '(' ? By.xpath((String)locator) : By.cssSelector((String)locator);
    }

    private static List<Object> one(By by) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(by);
        return result;
    }

    private static List<By> replaceUp(String locator) {
        ArrayList<By> result = null;
        if (locator.contains("<")) {
            result = new ArrayList<By>();
            String loc = locator.replaceAll(" *< *", "<");
            Matcher m = Pattern.compile("(?<up><+)").matcher(loc);
            while (m.find()) {
                String[] locs = loc.split(m.group("up"));
                if (locs.length > 0) {
                    result.add(By.cssSelector((String)locs[0]));
                }
                result.add(WebDriverByUtils.getUpXpath(m.group("up")));
                loc = locs.length == 2 ? locs[1] : "";
            }
            if (Strings.isNotEmpty((CharSequence)loc)) {
                result.add(By.cssSelector((String)loc));
            }
        }
        return (List)LinqUtils.valueOrDefault(result, Collections.singletonList(By.cssSelector((String)locator)));
    }

    private static By getUpXpath(String group) {
        String result = ".." + StringUtils.repeat((String)"/..", (int)(group.length() - 1));
        return By.xpath((String)result);
    }

    private static List<By> replaceText(List<By> bys) {
        ArrayList<By> result = new ArrayList<By>();
        for (By by : bys) {
            if (WebDriverByUtils.getByName(by).equals("css")) {
                result.addAll(WebDriverByUtils.replaceText(WebDriverByUtils.getByLocator(by)));
                continue;
            }
            result.add(by);
        }
        return result;
    }

    private static List<By> replaceText(String locator) {
        ArrayList<By> result = new ArrayList<By>();
        String loc = locator;
        Matcher m = Pattern.compile("\\[(?<modifier>\\*?)'(?<text>[^']+)']").matcher(loc);
        while (m.find() && Strings.isNotEmpty((CharSequence)loc)) {
            String[] locs = loc.split("\\[\\*?'" + m.group("text") + "']");
            if (locs.length > 0) {
                result.add(By.cssSelector((String)locs[0]));
            }
            result.add(m.group("modifier").equals("") ? By.xpath((String)(".//*[text()='" + m.group("text") + "']")) : By.xpath((String)(".//*[contains(text(),'" + m.group("text") + "')]")));
            loc = locs.length == 2 ? locs[1] : "";
        }
        if (Strings.isNotEmpty((CharSequence)loc)) {
            result.add(By.cssSelector((String)loc));
        }
        return result;
    }

    private static List<Object> replaceChildren(List<By> bys) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (By by : bys) {
            if (WebDriverByUtils.getByName(by).equals("css")) {
                result.addAll(WebDriverByUtils.replaceChildren(WebDriverByUtils.getByLocator(by)));
                continue;
            }
            result.add(by);
        }
        return result;
    }

    private static List<Object> replaceChildren(String locator) {
        ArrayList<Object> result = new ArrayList<Object>();
        String loc = locator;
        Matcher m = Pattern.compile("\\[(?<num>\\d+)]").matcher(loc);
        while (m.find() && Strings.isNotEmpty((CharSequence)loc)) {
            String[] locs = loc.split("\\[" + m.group("num") + "]");
            if (locs.length > 0) {
                result.add(By.cssSelector((String)locs[0]));
            }
            result.add(Integer.parseInt(m.group("num")));
            loc = locs.length == 2 ? locs[1] : "";
        }
        if (Strings.isNotEmpty((CharSequence)loc)) {
            result.add(By.cssSelector((String)loc));
        }
        return result;
    }

    public static String asTextLocator(String text) {
        return String.format(".//*/text()[normalize-space(.) = %s]/parent::*", Quotes.escape((String)text));
    }

    public static String asContainsTextLocator(String text) {
        return String.format(".//*/text()[contains(normalize-space(.), %s)]/parent::*", Quotes.escape((String)text));
    }

    public static By byText(String text) {
        return By.xpath((String)WebDriverByUtils.asTextLocator(text));
    }

    public static By withText(String text) {
        return By.xpath((String)WebDriverByUtils.asContainsTextLocator(text));
    }
}

