/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.Order;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.init.PageFactory;
import com.epam.jdi.light.elements.init.SiteInfo;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.IClickable;
import com.epam.jdi.light.elements.interfaces.base.INamed;
import com.epam.jdi.light.elements.interfaces.common.IsButton;
import com.epam.jdi.light.elements.pageobjects.annotations.Name;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.func.JFunc2;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.map.MultiMap;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.WebElement;

public final class UIUtils {
    public static JFunc2<Object, String, IClickable> GET_DEFAULT_BUTTON = (obj, buttonName) -> UIFactory.$("[type=submit]", obj).setName((String)buttonName);
    public static JFunc2<Object, String, IClickable> GET_BUTTON = (obj, buttonName) -> {
        Field field;
        Object btnObj;
        List buttons;
        IClickable button;
        List fields = ReflectionUtils.getFields((Object)obj, (Class[])new Class[]{IsButton.class});
        if (fields.size() == 0) {
            fields = ReflectionUtils.getFieldsExact((Object)obj, (Class[])new Class[]{WebElement.class, UIElement.class});
        }
        if (fields.size() > 1 && (fields = LinqUtils.filter((Collection)fields, f -> ReflectionUtils.isInterfaceAnd(ReflectionUtils.getValueField((Field)f, (Object)obj).getClass(), (Class[])new Class[]{IClickable.class, INamed.class}))).size() >= 1 && (button = (IClickable)LinqUtils.first((Collection)(buttons = LinqUtils.select((Collection)fields, f -> (IClickable)ReflectionUtils.getValueField((Field)f, (Object)obj))), b -> StringUtils.namesEqual((String)UIUtils.toButton(((INamed)((Object)b)).getName()), (String)UIUtils.toButton(buttonName)))) != null) {
            return button;
        }
        if (fields.size() == 1 && ReflectionUtils.isInterface((btnObj = ReflectionUtils.getValueField((Field)(field = (Field)fields.get(0)), (Object)obj)).getClass(), IClickable.class)) {
            return (IClickable)btnObj;
        }
        return (IClickable)GET_DEFAULT_BUTTON.execute(obj, buttonName);
    };

    private UIUtils() {
    }

    public static MapArray<String, String> getMapFromObject(Object obj) {
        if (obj == null) {
            return new MapArray();
        }
        List notNullFields = LinqUtils.filter((Collection)ReflectionUtils.getFields((Object)obj, (Class[])new Class[]{Object.class}), f -> ReflectionUtils.getValueField((Field)f, (Object)obj) != null);
        List withOrder = LinqUtils.filter((Collection)notNullFields, f -> f.getAnnotation(Order.class) != null);
        List<Field> ordered = new ArrayList();
        if (withOrder.size() > 0) {
            MultiMap orderMap = new MultiMap((Collection)withOrder, k -> k.getAnnotation(Order.class).value(), v -> v).ignoreKeyCase();
            orderMap.pairs.sort((d1, d2) -> (Integer)d2.key - (Integer)d1.key);
            for (Pair pairs : orderMap.pairs) {
                ordered.add((Field)pairs.value);
            }
            ordered.addAll(LinqUtils.filter((Collection)notNullFields, f -> f.getAnnotation(Order.class) == null));
        } else {
            ordered = notNullFields;
        }
        return new MapArray(ordered, UIUtils::getElementName, field -> {
            Object value = ReflectionUtils.getValueField((Field)field, (Object)obj);
            if (ReflectionUtils.isClassOr(value.getClass(), (Class[])new Class[]{String.class, Integer.class, Boolean.class})) {
                return value.toString();
            }
            if (ReflectionUtils.isClass(value.getClass(), Enum.class)) {
                return EnumUtils.getEnumValue((Enum)((Enum)value));
            }
            return null;
        });
    }

    public static String getElementName(Field field) {
        if (WebAnnotationsUtil.hasAnnotation(field, Name.class)) {
            return field.getAnnotation(Name.class).value();
        }
        if (field.getType().isAnnotationPresent(Name.class)) {
            return field.getType().getAnnotation(Name.class).value();
        }
        return StringUtils.splitCamelCase((String)field.getName());
    }

    private static String toButton(String buttonName) {
        return buttonName.toLowerCase().contains("button") ? buttonName : buttonName + "button";
    }

    public static <T> T asEntity(Object obj, Class<T> entityClass) {
        try {
            Object data = ReflectionUtils.create(entityClass);
            List dataFields = ReflectionUtils.getFields((Object)data, (Class[])new Class[]{String.class});
            LinqUtils.foreach((Collection)ReflectionUtils.getFields((Object)obj, (Class[])new Class[]{HasValue.class}), item -> {
                Field field = (Field)LinqUtils.first((Collection)dataFields, f -> StringUtils.namesEqual((String)UIUtils.getElementName(f), (String)UIUtils.getElementName(item)));
                if (field == null) {
                    return;
                }
                try {
                    StringUtils.setPrimitiveField((Field)field, (Object)data, (String)((HasValue)ReflectionUtils.getValueField((Field)item, (Object)obj)).getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return (T)data;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get entity from '" + UIUtils.getName(obj) + "' for class: " + entityClass, new Object[0]);
        }
    }

    public static <T extends IBaseElement> T initT(UIElement el, IBaseElement parent, Class<?> initClass) {
        try {
            if (initClass == null) {
                throw Exceptions.exception("Can't init List of UI Elements. Class Type is null", new Object[0]);
            }
            SiteInfo info = (SiteInfo)((Object)new SiteInfo(parent.base().driverName).set(s -> {
                s.cl = initClass;
                s.name = el.getName();
                s.parent = el.parent;
            }));
            PageFactory.initJdiField(info);
            if (info.instance != null) {
                PageFactory.setupFieldUsingRules(info);
            }
            IBaseElement t = (IBaseElement)info.instance;
            t.base().setCore(el);
            t.base().searchRules = parent.base().searchRules;
            PageFactory.initElements((Object)t);
            return (T)t;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't init new element for list", new Object[0]);
        }
    }

    public static String getName(Object obj) {
        return ReflectionUtils.isInterface(obj.getClass(), INamed.class) ? ((INamed)obj).getName() : obj.getClass().getSimpleName();
    }
}

