/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.light.common.ElementArea;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.pairs.Pair;
import java.util.Objects;
import org.openqa.selenium.WebElement;

public class SearchStrategies {
    public static JFunc1<WebElement, Boolean> ANY_ELEMENT = Objects::nonNull;
    public static JFunc1<WebElement, Boolean> VISIBLE_ELEMENT = WebElement::isDisplayed;
    public static JFunc1<WebElement, Boolean> ENABLED_ELEMENT = el -> el != null && el.isDisplayed() && el.isEnabled();
    public static JFunc1<WebElement, Boolean> ELEMENT_IN_VIEW = el -> el != null && el.isDisplayed() && UIFactory.$(el).isClickable();

    public static void setSearchRule(String name, JFunc1<WebElement, Boolean> rule) {
        JDISettings.ELEMENT.searchRule = Pair.$((Object)name, rule);
    }

    public static void noValidation() {
        JDISettings.ELEMENT.searchRule = Pair.$((Object)"Any", ANY_ELEMENT);
        JDISettings.ELEMENT.clickType = ElementArea.CENTER;
    }

    public static void onlyVisible() {
        JDISettings.ELEMENT.searchRule = Pair.$((Object)"Visible", VISIBLE_ELEMENT);
    }

    public static void visibleEnabled() {
        JDISettings.ELEMENT.searchRule = Pair.$((Object)"Enabled", ENABLED_ELEMENT);
    }

    public static void inView() {
        JDISettings.ELEMENT.searchRule = Pair.$((Object)"Element in view", ELEMENT_IN_VIEW);
        JDISettings.ELEMENT.beforeSearch = UIElement::show;
    }
}

