/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.tools.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class LinuxProcessUtils {
    public static void killProcessesTree(String rootNamePart) {
        try {
            List<String> browsersPids = LinuxProcessUtils.getPIDsByNamePart(rootNamePart);
            for (String pid : browsersPids) {
                LinuxProcessUtils.killProcessByPid(pid);
            }
        }
        catch (IOException | InterruptedException e) {
            throw Exceptions.exception("Can't kill drivers", new Object[0]);
        }
    }

    private static void killProcessByPid(String pid) throws IOException, InterruptedException {
        Process process = new ProcessBuilder("kill", "-9", pid).start();
        process.waitFor();
    }

    private static List<String> getPIDsByNamePart(String value) throws IOException, InterruptedException {
        Process process = new ProcessBuilder("pgrep", value).start();
        process.waitFor();
        return StringUtils.inputStreamToList((InputStream)process.getInputStream());
    }
}

