/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import java.lang.reflect.InvocationTargetException;

public class Exceptions {
    public static RuntimeException exception(String msg, Object ... args) {
        String message = args.length == 0 ? msg : String.format(msg, args);
        return new RuntimeException(StringUtils.LINE_BREAK + message);
    }

    public static RuntimeException exception(Throwable ex, String msg, Object ... args) {
        String message = args.length == 0 ? msg : String.format(msg, args);
        Class<?> exceptionClass = ex.getClass();
        if (ReflectionUtils.isClass(AssertionError.class, exceptionClass)) {
            throw new AssertionError(message, ex);
        }
        if (ReflectionUtils.isClass(exceptionClass, UnsupportedOperationException.class)) {
            return new UnsupportedOperationException(message, ex);
        }
        return new RuntimeException(message, ex);
    }

    public static String safeException(Throwable ex) {
        String msg = ex.getMessage();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)msg) && ReflectionUtils.isClass(ex.getClass(), InvocationTargetException.class)) {
            msg = ((InvocationTargetException)ex).getTargetException().getMessage();
        }
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)msg) ? msg : ex.toString();
    }
}

