/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.generic.table;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.table.BaseTableAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.BaseTable;
import com.epam.jdi.light.elements.complex.table.Table;
import com.epam.jdi.light.elements.complex.table.TableMatcher;
import org.hamcrest.Matchers;

public class TableAssert
extends BaseTableAssert<Table, TableAssert> {
    public Compare exact(int count) {
        return new Compare(count, this, true);
    }

    public Compare atLeast(int count) {
        return new Compare(count, this, false);
    }

    public Compare no() {
        return this.exact(0);
    }

    public Compare all() {
        return this.exact(((Table)this.table()).count());
    }

    public Compare onlyOne() {
        return this.exact(1);
    }

    public class Compare {
        public int count;
        public String name;
        public String failElement;
        public String type;
        TableAssert tAssert;
        boolean exact;

        private Compare(int count, TableAssert tAssert, boolean exact) {
            this.count = count;
            this.tAssert = tAssert;
            this.exact = exact;
            this.type = exact ? "exactly" : "at least";
            this.name = tAssert.name;
            this.failElement = tAssert.failElement;
        }

        @JDIAction(value="Assert that '{name}' has at least '{0}' rows that {0}")
        public TableAssert rows(TableMatcher ... matchers) {
            SoftAssert.jdiAssert(((WebList)TableMatcher.TABLE_MATCHER.execute((Object)((BaseTable)TableAssert.this.element()), (Object)matchers)).size(), Matchers.greaterThan((Comparable)Integer.valueOf(((Table)TableAssert.this.table()).header().size() * this.count - 1)));
            return this.tAssert;
        }
    }
}

