/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.generic.table;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.JAssert;
import com.epam.jdi.light.asserts.generic.table.BaseTableAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.DataTable;
import com.epam.jdi.light.elements.complex.table.Row;
import com.epam.jdi.light.elements.complex.table.TableMatcher;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.func.JFunc2;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class DataTableAssert<L extends PageObject, D>
extends BaseTableAssert<DataTable<L, D>, DataTableAssert<L, D>> {
    @JDIAction(value="Assert that '{name}' has rows that meet expected condition")
    public DataTableAssert<L, D> row(JFunc1<D, Boolean> condition) {
        SoftAssert.jdiAssert(((DataTable)this.table()).dataRow(condition), Matchers.not((Matcher)Matchers.nullValue()));
        return this;
    }

    @JDIAction(value="Assert that '{name}' has rows that meet expected condition")
    public DataTableAssert<L, D> value(JFunc1<D, Boolean> condition, Row row) {
        SoftAssert.jdiAssert((Boolean)condition.execute(((DataTable)this.table()).dataRow(row.getIndex(((DataTable)this.table()).header()))), Matchers.is((Object)true));
        return this;
    }

    @JDIAction(value="Assert that '{name}' has {0}")
    public DataTableAssert<L, D> row(D data) {
        return this.row((D)((JFunc1)d -> d.equals(data)));
    }

    @JDIAction(value="Assert that '{name}' has {0}")
    public DataTableAssert<L, D> value(D expected, Row row) {
        Object actual = ((DataTable)this.table()).dataRow(row.getIndex(((DataTable)this.table()).header()));
        SoftAssert.jdiAssert(actual, Matchers.is(expected));
        return this;
    }

    @JDIAction(value="Assert that '{name}' rows {0}")
    public DataTableAssert<L, D> rows(Matcher<? super List<D>> condition) {
        SoftAssert.jdiAssert(((DataTable)this.table()).allData(), condition);
        return this;
    }

    @JDIAction(value="Assert that '{name}' is sorted by ascending")
    public DataTableAssert<L, D> sortedByAsc(String columnName, JFunc1<UIElement, Object> getValue) {
        WebList column = ((DataTable)this.table()).webColumn(columnName);
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted((Object)getValue.execute((Object)column.get(i - 1)), (Object)getValue.execute((Object)column.get(i)), (boolean)true, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by ascending at " + i + " row", Matchers.is((Object)""));
        }
        return this;
    }

    @JDIAction(value="Assert that '{name}' is sorted by descending")
    public DataTableAssert<L, D> sortedByDesc(String columnName, JFunc1<UIElement, Object> getValue) {
        WebList column = ((DataTable)this.table()).webColumn(columnName);
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted((Object)getValue.execute((Object)column.get(i - 1)), (Object)getValue.execute((Object)column.get(i)), (boolean)false, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by descending at " + i + " row", Matchers.is((Object)""));
        }
        return this;
    }

    @JDIAction(value="Assert that '{name}' is sorted by ascending")
    public <C extends HasValue> DataTableAssert<L, D> sortedByAsc(String columnName, Class<C> cl) {
        List<C> column = ((DataTable)this.table()).columnValues(columnName, cl);
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted((Object)((HasValue)column.get(i - 1)).getValue(), (Object)((HasValue)column.get(i)).getValue(), (boolean)true, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by ascending at " + i + " row", Matchers.is((Object)""));
        }
        return this;
    }

    @JDIAction(value="Assert that '{name}' is sorted by descending")
    public <C extends HasValue> DataTableAssert<L, D> sortedByDesc(String columnName, Class<C> cl) {
        List<C> column = ((DataTable)this.table()).columnValues(columnName, cl);
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted((Object)((HasValue)column.get(i - 1)).getValue(), (Object)((HasValue)column.get(i)).getValue(), (boolean)false, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by descending at " + i + " row", Matchers.is((Object)""));
        }
        return this;
    }

    @JDIAction(value="Assert that '{name}' is sorted")
    public DataTableAssert<L, D> sortedBy(JFunc2<L, L, Boolean> condition) {
        List allRows = ((DataTable)this.table()).allLines();
        for (int i = 1; i < allRows.size(); ++i) {
            if (((Boolean)condition.execute((Object)((PageObject)allRows.get(i - 1)), (Object)((PageObject)allRows.get(i)))).booleanValue()) continue;
            SoftAssert.jdiAssert("Table is not sorted at " + i + " row", Matchers.is((Object)""));
        }
        SoftAssert.jdiAssert("Table is sorted", Matchers.is((Object)"Table is sorted"));
        return this;
    }

    @JDIAction(value="Assert that '{name}' is sorted")
    public DataTableAssert<L, D> dataSortedBy(JFunc2<D, D, Boolean> condition) {
        List allRows = ((DataTable)this.table()).allData();
        for (int i = 1; i < allRows.size(); ++i) {
            if (((Boolean)condition.execute(allRows.get(i - 1), allRows.get(i))).booleanValue()) continue;
            SoftAssert.jdiAssert("Table is not sorted at " + i + " row", Matchers.is((Object)""));
        }
        SoftAssert.jdiAssert("Table is sorted", Matchers.is((Object)"Table is sorted"));
        return this;
    }

    public Compare exact(int count) {
        return new Compare(count, this, CompareType.EXACT);
    }

    public Compare atLeast(int count) {
        return new Compare(count, this, CompareType.ATLEAST);
    }

    public Compare no() {
        return this.exact(0);
    }

    public Compare all() {
        return new Compare(this);
    }

    public Compare onlyOne() {
        return this.exact(1);
    }

    public class Compare
    implements JAssert {
        public int count;
        public String name;
        public String printText;
        DataTableAssert<L, D> dtAssert;
        CompareType compareType;

        @Override
        public JDIBase base() {
            return DataTableAssert.this.base();
        }

        private Compare(DataTableAssert<L, D> dtAssert) {
            this.dtAssert = dtAssert;
            this.compareType = CompareType.ALL;
            this.printText = "all rows";
            this.name = dtAssert.name;
        }

        private Compare(int count, DataTableAssert<L, D> dtAssert, CompareType compareType) {
            this.count = count;
            this.dtAssert = dtAssert;
            this.compareType = compareType;
            this.printText = String.format("has %s %s rows that", compareType.text, count);
            this.name = dtAssert.name;
        }

        @JDIAction(value="Assert that '{name}' {printText} meet expected condition")
        public DataTableAssert<L, D> rows(JFunc1<D, Boolean> condition) {
            switch (this.compareType) {
                case EXACT: {
                    SoftAssert.jdiAssert(((DataTable)DataTableAssert.this.table()).dataRows(condition), Matchers.hasSize((int)this.count));
                    break;
                }
                case ALL: {
                    List rows = ((DataTable)DataTableAssert.this.table()).allData();
                    SoftAssert.jdiAssert(LinqUtils.all(rows, condition), Matchers.is((Object)true));
                    break;
                }
                case ATLEAST: {
                    SoftAssert.jdiAssert(((DataTable)DataTableAssert.this.table()).dataRows(condition, this.count), Matchers.hasSize((int)this.count));
                }
            }
            return this.dtAssert;
        }

        @JDIAction(value="Assert that '{name}' {printText} has '{0}'")
        public DataTableAssert<L, D> rows(D data) {
            return this.rows((Object)d -> d.equals(data));
        }

        @JDIAction(value="Assert that '{name}' {printText} has {0}")
        public DataTableAssert<L, D> rows(TableMatcher ... matchers) {
            SoftAssert.jdiAssert(((WebList)TableMatcher.TABLE_MATCHER.execute(DataTableAssert.this.table(), (Object)matchers)).size(), Matchers.greaterThan((Comparable)Integer.valueOf(((DataTable)DataTableAssert.this.table()).header().size() * this.count - 1)));
            return this.dtAssert;
        }

        public DataTableAssert<L, D> row(JFunc1<D, Boolean> condition) {
            return this.rows((Object)condition);
        }

        public DataTableAssert<L, D> row(D data) {
            return this.rows(data);
        }

        public DataTableAssert<L, D> row(TableMatcher ... matchers) {
            return this.rows(matchers);
        }
    }

    public static enum CompareType {
        EXACT("exactly"),
        ATLEAST("at least"),
        ALL("all");

        public String text;

        private CompareType(String text) {
            this.text = text;
        }
    }
}

