/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.generic.table;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.UIAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.complex.table.BaseTable;
import com.epam.jdi.light.elements.complex.table.Column;
import com.epam.jdi.light.elements.complex.table.Line;
import com.epam.jdi.light.elements.complex.table.Single;
import com.epam.jdi.light.elements.complex.table.TableMatcher;
import com.epam.jdi.tools.LinqUtils;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class BaseTableAssert<T extends BaseTable<?, ?>, A extends BaseTableAssert<?, ?>>
extends UIAssert<A, T> {
    protected T table() {
        return (T)((BaseTable)this.element());
    }

    @JDIAction(value="Assert is '{name}' empty")
    public A empty() {
        SoftAssert.jdiAssert(((BaseTable)this.table()).isEmpty() ? "is empty" : "is not empty", Matchers.is((Object)"is empty"));
        return (A)this;
    }

    @JDIAction(value="Assert is '{name}' not empty")
    public A notEmpty() {
        SoftAssert.jdiAssert(((BaseTable)this.table()).isEmpty() ? "is empty" : "is not empty", Matchers.is((Object)"is not empty"));
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' size '{0}'")
    public A size(Matcher<Integer> condition) {
        SoftAssert.jdiAssert(((BaseTable)this.table()).count(), condition);
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' size '{0}'")
    public A size(int size) {
        return this.size((Matcher<Integer>)Matchers.is((Object)size));
    }

    @JDIAction(value="Assert that '{name}' has column'{0}'")
    public A column(String column) {
        SoftAssert.jdiAssert(((BaseTable)this.table()).header(), Matchers.hasItem((Object)column));
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' has columns '{0}'")
    public A columns(List<String> columns) {
        for (String column : columns) {
            this.column(column);
        }
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' columns '{0}'")
    public A columns(Matcher<Collection<? extends String>> condition) {
        SoftAssert.jdiAssert(((BaseTable)this.table()).header(), condition);
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' has at least one row that '{0}'")
    public A rowThat(TableMatcher ... matchers) {
        SoftAssert.jdiAssert((List)TableMatcher.TABLE_MATCHER.execute(this.table(), (Object)matchers), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' has at least one row that '{0}'")
    public A rowThat(Single matcher, Column column) {
        SoftAssert.jdiAssert((List)TableMatcher.TABLE_MATCHER.execute(this.table(), (Object)new TableMatcher[]{matcher.toTableMatcher(column)}), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' has rows that '{0}' in column '{1}'")
    public A row(Matcher<String> matcher, Column column) {
        SoftAssert.jdiAssert(((BaseTable)this.table()).row(matcher, column), Matchers.not((Matcher)Matchers.nullValue()));
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' row '{0}' equals to other row")
    public A rowVisualValidation(String rowName, Line row) {
        SoftAssert.jdiAssert(((BaseTable)this.table()).row(rowName).visualCompareTo(row), Matchers.is((Object)true));
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' row '{0}' equals to other rows")
    public A rowsLooksCorrect(String keyColumn, List<Line> rows) {
        List<Line> tableRows = ((BaseTable)this.table()).rowsImages();
        for (int i = 0; i < ((BaseTable)this.table()).count(); ++i) {
            Line tableRow = tableRows.get(i);
            String valueToSearch = tableRow.get(keyColumn);
            Line searchRow = this.findRow(rows, valueToSearch, keyColumn);
            SoftAssert.jdiAssert(tableRow.visualCompareTo(searchRow), Matchers.is((Object)true));
        }
        return (A)this;
    }

    private Line findRow(List<Line> rows, String name, String columnName) {
        Line line = (Line)LinqUtils.first(rows, l -> l.get(columnName).equals(name));
        if (line == null) {
            throw Exceptions.exception("Can't find %s row with column %s", name, columnName);
        }
        return line;
    }

    @JDIAction(value="Assert that '{name}' is sorted by '{0}' in ascending order")
    public A sortedByAsc(String columnName) {
        List<String> column = ((BaseTable)this.table()).webColumn(columnName).values();
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted((Object)column.get(i - 1), (Object)column.get(i), (boolean)true, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by ascending at " + i + " row", Matchers.is((Object)""));
        }
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' is sorted by '{0}' in descending order")
    public A sortedByDesc(String columnName) {
        List<String> column = ((BaseTable)this.table()).webColumn(columnName).values();
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted((Object)column.get(i), (Object)column.get(i - 1), (boolean)true, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by descending at " + i + " row", Matchers.is((Object)""));
        }
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' is sorted by '{0}' in ascending order")
    public A sortedNumByAsc(String columnName) {
        List column = LinqUtils.map(((BaseTable)this.table()).webColumn(columnName).values(), el -> el.replaceAll("[^0-9.,]", ""));
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted(column.get(i - 1), column.get(i), (boolean)true, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by ascending at " + i + " row", Matchers.is((Object)""));
        }
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' is sorted by '{0}' in descending order")
    public A sortedNumByDesc(String columnName) {
        List column = LinqUtils.map(((BaseTable)this.table()).webColumn(columnName).values(), el -> el.replaceAll("[^0-9.,+\\-]", ""));
        for (int i = 1; i < column.size(); ++i) {
            if (LinqUtils.isSorted(column.get(i), column.get(i - 1), (boolean)true, (boolean)false)) continue;
            SoftAssert.jdiAssert("Table is not by descending at " + i + " row", Matchers.is((Object)""));
        }
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' preview is correct")
    public A preview(String preview) {
        SoftAssert.jdiAssert(((BaseTable)this.table()).preview(), Matchers.is((Object)preview));
        return (A)this;
    }
}

