/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.generic;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.ITextAssert;
import com.epam.jdi.light.asserts.generic.JAssert;
import com.epam.jdi.light.asserts.generic.UIAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.ISelector;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.Timer;
import com.epam.jdi.tools.func.JFunc1;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class UISelectAssert<A extends UISelectAssert<?, ?>, E extends ISelector>
extends UIAssert<A, E>
implements ITextAssert<A> {
    @JDIAction(value="Assert that '{0}' option selected for '{name}'")
    public A selected(Matcher<String> condition) {
        SoftAssert.jdiAssert(((ISelector)this.element()).selected(), condition);
        return (A)this;
    }

    @JDIAction(value="Assert that '{0}' option selected for '{name}'")
    public A selected(String option) {
        return (A)this.selected((Enum)Matchers.is((Object)option));
    }

    @JDIAction(value="Assert that '{0}' option selected for '{name}'")
    public A selected(int index) {
        SoftAssert.jdiAssert(((ISelector)this.element()).selected(index), Matchers.is((Object)true));
        return (A)this;
    }

    public <TEnum extends Enum<?>> UISelectAssert<?, ?> selected(TEnum option) {
        return this.selected((TEnum)((Object)EnumUtils.getEnumValue(option)));
    }

    @Override
    public A text(Matcher<String> condition) {
        SoftAssert.jdiAssert(((ISelector)this.element()).text(), condition);
        return (A)this;
    }

    @Override
    public A text(String condition) {
        return (A)this.text(Matchers.is((Object)condition));
    }

    public <TEnum extends Enum<?>> A value(TEnum option) {
        SoftAssert.jdiAssert(((ISelector)this.element()).values(), Matchers.hasItem((Object)EnumUtils.getEnumValue(option)));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' values {0}")
    public A value(Matcher<String> condition) {
        return this.values((Matcher<List<String>>)Matchers.hasItem(condition));
    }

    @Override
    @JDIAction(value="Assert that '{name}' has value {0}")
    public A value(String value) {
        return this.values((Matcher<List<String>>)Matchers.hasItem((Object)value));
    }

    @JDIAction(value="Assert that '{name}' values {0}")
    public A values(Matcher<? super List<String>> condition) {
        SoftAssert.jdiAssert(((ISelector)this.element()).values(), condition);
        return (A)this;
    }

    public A values(String ... values) {
        return this.values((Matcher<List<String>>)Matchers.hasItems((Object[])values));
    }

    public A values(List<String> values) {
        return this.values(LinqUtils.toStringArray(values));
    }

    @JDIAction(value="Assert that '{name}' values {0}")
    public A values(TextTypes type, Matcher<? super List<String>> condition) {
        SoftAssert.jdiAssert(((ISelector)this.element()).values(type), condition);
        return (A)this;
    }

    public A values(TextTypes type, String ... values) {
        return this.values(type, (Matcher<List<String>>)Matchers.hasItems((Object[])values));
    }

    @JDIAction(value="Assert that '{name}' enabled items {0}")
    public A enabled(Matcher<? super List<String>> condition) {
        SoftAssert.jdiAssert(((ISelector)this.element()).listEnabled(), condition);
        return (A)this;
    }

    public A enabled(String ... enabled) {
        return this.enabled((Matcher<List<String>>)Matchers.hasItems((Object[])enabled));
    }

    @JDIAction(value="Assert that '{name}' disabled items {0}")
    public A disabled(Matcher<? super List<String>> condition) {
        SoftAssert.jdiAssert(((ISelector)this.element()).listDisabled(), condition);
        return (A)this;
    }

    public A disabled(String ... disabled) {
        return this.disabled((Matcher<List<String>>)Matchers.hasItems((Object[])disabled));
    }

    @JDIAction(value="Assert that '{name}' size {0}")
    public A size(Matcher<Integer> condition) {
        SoftAssert.jdiAssert(((ISelector)this.element()).size(), condition);
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' size {0}")
    public A size(int size) {
        return this.size((Matcher<Integer>)Matchers.equalTo((Object)size));
    }

    @Override
    @JDIAction(value="Assert that '{name}' is empty")
    public A empty() {
        return this.size(0);
    }

    @JDIAction(value="Assert that '{name}' is not empty")
    public A notEmpty() {
        return this.size((Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Override
    @JDIAction(value="Assert that '{name}' is displayed")
    public A displayed() {
        SoftAssert.jdiAssert(((ISelector)this.element()).isDisplayed() ? "displayed" : "hidden", Matchers.is((Object)"displayed"));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is disappeared")
    public A disappear() {
        SoftAssert.jdiAssert(((ISelector)this.element()).isHidden() ? "hidden" : "displayed", Matchers.is((Object)"hidden"));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is hidden")
    public A hidden() {
        return (A)this.disappear();
    }

    @Override
    public A notAppear() {
        return (A)this.notAppear(JDISettings.TIMEOUTS.element.get());
    }

    @Override
    @JDIAction(value="Assert that '{name}' does not appear during {0} seconds", timeout=0)
    public A notAppear(int timeoutSec) {
        boolean result = new Timer((long)(timeoutSec * 1000)).wait(() -> ((ISelector)this.element()).isDisplayed());
        SoftAssert.jdiAssert(result ? "displayed" : "hidden", Matchers.is((Object)"hidden"));
        return (A)this;
    }

    public Compare exact(int count) {
        return new Compare(count, this, true);
    }

    public Compare atLeast(int count) {
        return new Compare(count, this, false);
    }

    public Compare no() {
        return this.exact(0);
    }

    public Compare all() {
        return this.exact(((ISelector)this.element()).size());
    }

    public Compare onlyOne() {
        return this.exact(1);
    }

    @Override
    public A and() {
        return (A)this;
    }

    public class Compare
    implements JAssert {
        public int count;
        public String name;
        public String type;
        UISelectAssert<A, E> dtAssert;
        boolean exact;

        @Override
        public JDIBase base() {
            return UISelectAssert.this.base();
        }

        private Compare(int count, UISelectAssert<A, E> dtAssert, boolean exact) {
            this.count = count;
            this.dtAssert = dtAssert;
            this.exact = exact;
            this.type = exact ? "exactly" : "at least";
            this.name = dtAssert.name;
        }

        @JDIAction(value="Assert that '{name}' has {type} '{count}' elements that meet expected condition")
        public UISelectAssert<A, E> elements(JFunc1<UIElement, Boolean> condition) {
            SoftAssert.jdiAssert(((ISelector)UISelectAssert.this.element()).list().filter(condition), Matchers.hasSize((int)this.count));
            return this.dtAssert;
        }

        @JDIAction(value="Assert that '{name}' has {type} '{count}' '{0}'")
        public UISelectAssert<A, E> elements(UIElement data) {
            return this.elements((JFunc1<UIElement, Boolean>)((JFunc1)d -> d.equals(data)));
        }
    }
}

