/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.generic;

import com.epam.jdi.light.asserts.core.IsAssert;
import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.BaseAssert;
import com.epam.jdi.light.asserts.generic.CommonAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.Timer;
import com.epam.jdi.tools.func.JFunc1;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class UIAssert<A extends UIAssert, E extends ICoreElement>
extends BaseAssert<E>
implements CommonAssert<A> {
    @Override
    @JDIAction(value="Assert that '{name}' is displayed")
    public A displayed() {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).isDisplayed() ? "displayed" : "hidden", Matchers.is((Object)"displayed"));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is visible by user")
    public A visible() {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).isVisible() ? "is in the user view" : "out of the screen or hidden", Matchers.is((Object)"is in the user view"));
        return (A)this;
    }

    @JDIAction(value="Assert that '{name}' is not visible by user")
    public A notVisible() {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).isNotVisible() ? "out of the user view" : "is in the user view", Matchers.is((Object)"out of the user view"));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is shown")
    public A shown() {
        return (A)this.displayed();
    }

    @Override
    @JDIAction(value="Assert that '{name}' is disappear")
    public A disappear() {
        return (A)this.hidden();
    }

    @Override
    @JDIAction(value="Assert that '{name}' is hidden")
    public A hidden() {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).isHidden() ? "hidden" : "displayed", Matchers.is((Object)"hidden"));
        return (A)this;
    }

    @Override
    public A notAppear() {
        return (A)this.notAppear(this.base().getTimeout());
    }

    @Override
    @JDIAction(value="Assert that '{name}' does not appear during {0} seconds", timeout=0)
    public A notAppear(int timeoutSec) {
        boolean result = new Timer((long)timeoutSec * 1000L).wait(() -> ((ICoreElement)this.element()).isDisplayed());
        SoftAssert.jdiAssert(result ? "displayed" : "hidden", Matchers.is((Object)"hidden"));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' attribute '{0}' {1}")
    public A attr(String attrName, Matcher<String> condition) {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).attr(attrName), condition);
        return (A)this;
    }

    @Override
    public A attr(String attrName, String value) {
        return (A)this.attr(attrName, Matchers.is((Object)value));
    }

    @Override
    @JDIAction(value="Assert that '{name}' css '{0}' {1}")
    public A css(String css, Matcher<String> condition) {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).css(css), condition);
        return (A)this;
    }

    @Override
    public A css(String css, String value) {
        return (A)this.css(css, Matchers.is((Object)value));
    }

    @Override
    @JDIAction(value="Assert that '{name}' css class {0}")
    public A cssClasses(Matcher<? super List<String>> condition) {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).classes(), condition);
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' css class {0}")
    public A classValue(Matcher<String> condition) {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).core().attr("class"), condition);
        return (A)this;
    }

    @Override
    public A classValue(String value) {
        return (A)this.classValue(Matchers.is((Object)value));
    }

    @Override
    public A cssClass(String className) {
        return (A)this.cssClasses(Matchers.hasItem((Object)className));
    }

    @Override
    @JDIAction(value="Assert that '{name}' tag {0}")
    public A tag(Matcher<String> condition) {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).getTagName(), condition);
        return (A)this;
    }

    @Override
    public A tag(String tagName) {
        return (A)this.tag(Matchers.is((Object)tagName));
    }

    @JDIAction(value="Assert that '{name}' has css class {0}")
    public A attr(String attrName) {
        SoftAssert.jdiAssert(StringUtils.format((String)(((ICoreElement)this.element()).hasAttribute(attrName) ? "has attribute '%s'" : "has no attribute '%s'"), (Object[])new Object[]{attrName}), Matchers.is((Object)("has attribute '" + attrName + "'")));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is enabled")
    public A enabled() {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).isEnabled() ? "enabled" : "disabled", Matchers.is((Object)"enabled"));
        return (A)this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is disabled")
    public A disabled() {
        SoftAssert.jdiAssert(((ICoreElement)this.element()).isEnabled() ? "enabled" : "disabled", Matchers.is((Object)"disabled"));
        return (A)this;
    }

    @Override
    public A and() {
        return (A)this;
    }

    public IsAssert core() {
        return ((ICoreElement)this.element()).core().is();
    }

    @Override
    public A condition(JFunc1<A, A> t) {
        return (A)((UIAssert)t.execute((Object)this));
    }

    public A set(E element) {
        this.element = element;
        this.name = element.getName();
        this.failElement = StringUtils.format((String)"%s(%s)", (Object[])new Object[]{this.name, element.core().printFullLocator()});
        return (A)this;
    }

    @Override
    public A is() {
        return (A)this;
    }
}

