/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.generic;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.ITextAssert;
import com.epam.jdi.light.asserts.generic.UISelectAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.complex.IListSelector;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.func.JFunc1;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ListAssert<A extends ListAssert<?, ?, ?>, T, E extends IListSelector<T>>
extends UISelectAssert<A, E>
implements ITextAssert<A> {
    private List<T> list() {
        return ((IListSelector)this.element()).elements(1);
    }

    @JDIAction(value="Assert that each of '{name}' elements meet condition")
    public ListAssert<A, T, E> each(JFunc1<T, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.all(this.list(), arg_0 -> condition.execute(arg_0)), Matchers.is((Object)true));
        return this;
    }

    @JDIAction(value="Assert that any of '{name}' elements meet condition")
    public ListAssert<A, T, E> any(JFunc1<T, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.any(this.list(), arg_0 -> condition.execute(arg_0)), Matchers.is((Object)true));
        return this;
    }

    @JDIAction(value="Assert that only one of '{name}' elements meet condition")
    public ListAssert<A, T, E> onlyOne(JFunc1<T, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.single(this.list(), arg_0 -> condition.execute(arg_0)), Matchers.is((Matcher)Matchers.notNullValue()));
        return this;
    }

    @JDIAction(value="Assert that none of '{name}' meet condition")
    public ListAssert<A, T, E> noOne(JFunc1<T, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.first(this.list(), arg_0 -> condition.execute(arg_0)), Matchers.is((Matcher)Matchers.nullValue()));
        return this;
    }
}

