/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.generic;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.interfaces.base.HasRefresh;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.JDIElement;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.func.JFunc1;

public class BaseAssert<E extends IBaseElement>
implements IBaseElement {
    public String name;
    public String failElement;
    public E element;
    public static JFunc1<JDIElement, String> PRINT_ASSERT = Object::toString;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JDIBase base() {
        return this.element().base();
    }

    public E element() {
        if (ReflectionUtils.isInterface(this.element.getClass(), HasRefresh.class)) {
            ((HasRefresh)this.element).refresh();
        }
        return this.element;
    }

    public BaseAssert() {
    }

    public BaseAssert(E element) {
        this(element.getName(), element.getName());
        this.element = element;
    }

    public BaseAssert(String name, String failElement) {
        this.name = name;
        this.failElement = failElement;
    }

    public BaseAssert(String name) {
        this(name, name);
    }

    public String toString() {
        return this.element != null ? (String)PRINT_ASSERT.execute(this.element) : this.name;
    }

    public void assertResults() {
        SoftAssert.assertResults();
    }
}

