/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.core;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.ITextAssert;
import com.epam.jdi.light.asserts.generic.SelectedAssert;
import com.epam.jdi.light.asserts.generic.UIAssert;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.common.UIElement;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class IsAssert
extends UIAssert<IsAssert, UIElement>
implements SelectedAssert<IsAssert>,
ITextAssert<IsAssert> {
    @Override
    @JDIAction(value="Assert that '{name}' text {0}")
    public IsAssert text(Matcher<String> condition) {
        SoftAssert.jdiAssert(((UIElement)this.element()).getText(), condition);
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' attribute '{0}' {1}")
    public IsAssert attr(String attrName, Matcher<String> condition) {
        SoftAssert.jdiAssert(((UIElement)this.element()).getAttribute(attrName), condition);
        return this;
    }

    @Override
    public IsAssert attr(String attrName, String value) {
        return this.attr(attrName, Matchers.is((Object)value));
    }

    @Override
    public IsAssert attr(String attrName) {
        return this.attr(attrName, Matchers.not((Matcher)Matchers.is((Object)"")));
    }

    public IsAssert noAttribute(String attrName) {
        return this.attr(attrName, Matchers.is((Object)""));
    }

    @Override
    @JDIAction(value="Assert that '{name}' css '{0}' {1}")
    public IsAssert css(String css, Matcher<String> condition) {
        SoftAssert.jdiAssert(((UIElement)this.element()).getCssValue(css), condition);
        return this;
    }

    @Override
    public IsAssert css(String css, String value) {
        return this.css(css, Matchers.is((Object)value));
    }

    @Override
    @JDIAction(value="Assert that '{name}' tag {0}")
    public IsAssert tag(Matcher<String> condition) {
        SoftAssert.jdiAssert(((UIElement)this.element()).getTagName(), condition);
        return this;
    }

    @Override
    public IsAssert tag(String tagName) {
        return this.tag(Matchers.is((Object)tagName));
    }

    @Override
    @JDIAction(value="Assert that '{name}' css class {0}")
    public IsAssert cssClasses(Matcher<? super List<String>> condition) {
        SoftAssert.jdiAssert(((UIElement)this.element()).classes(), condition);
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' css class {0}")
    public IsAssert classValue(Matcher<String> condition) {
        SoftAssert.jdiAssert(((UIElement)this.element()).attr("class"), condition);
        return this;
    }

    @Override
    public IsAssert classValue(String value) {
        return this.classValue(Matchers.is((Object)value));
    }

    @Override
    public IsAssert cssClass(String className) {
        return this.cssClasses(Matchers.hasItem((Object)className));
    }

    @Override
    @JDIAction(value="Assert that '{name}' is selected")
    public IsAssert selected() {
        SoftAssert.jdiAssert(((UIElement)this.element()).isSelected() ? "selected" : "not selected", Matchers.is((Object)"selected"));
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is deselected")
    public IsAssert deselected() {
        SoftAssert.jdiAssert(((UIElement)this.element()).isDeselected() ? "not selected" : "selected", Matchers.is((Object)"not selected"));
        return this;
    }
}

