/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.core;

import com.epam.jdi.light.asserts.generic.BaseAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.PathUtils;
import java.io.File;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class FileAssert
extends BaseAssert<IBaseElement> {
    private File file;

    public static FileAssert assertThatFile(String fileName) {
        return new FileAssert(fileName);
    }

    public FileAssert(String fileName) {
        super(fileName);
        this.file = new File(PathUtils.mergePath((String)JDISettings.DRIVER.downloadsFolder, (String[])new String[]{fileName}));
    }

    @JDIAction(value="Assert that file '{name}' is downloaded")
    public FileAssert isDownloaded() {
        MatcherAssert.assertThat((Object)this.file.exists(), (Matcher)Matchers.is((Object)true));
        return this;
    }

    @JDIAction(value="Assert that file '{name}' text {0}")
    public FileAssert text(Matcher<String> text) {
        try {
            MatcherAssert.assertThat((Object)FileUtils.readFileToString((File)this.file, (String)"UTF-8"), text);
            return this;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Error reading file", new Object[0]);
        }
    }

    public FileAssert text(String text) {
        return this.text((Matcher<String>)Matchers.is((Object)text));
    }

    @JDIAction(value="Assert file '{name}' size")
    public FileAssert hasSize(Matcher<Long> size) {
        MatcherAssert.assertThat((Object)this.file.length(), size);
        return this;
    }

    @JDIAction(value="Assert file '{name}' size")
    public FileAssert hasSize(long min, long max) {
        long fileSize = this.file.length();
        MatcherAssert.assertThat((Object)fileSize, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(min)));
        MatcherAssert.assertThat((Object)fileSize, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(max)));
        return this;
    }

    public FileAssert hasSize(long size) {
        return this.hasSize(size - 10L, size + 10L);
    }

    public static void cleanupDownloads() {
        File dir = new File(JDISettings.DRIVER.downloadsFolder);
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            file.delete();
        }
        WebSettings.logger.info("Remove all downloads successfully", new Object[0]);
    }
}

