/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.core;

import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.asserts.generic.UISelectAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.complex.DataList;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.func.JFunc1;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DataListAssert<T extends ICoreElement, D>
extends UISelectAssert<DataListAssert<T, D>, DataList<T, D>> {
    public List<D> data() {
        return ((DataList)this.element()).asData();
    }

    @JDIAction(value="Assert that each of '{name}' elements meet condition")
    public DataListAssert<T, D> each(JFunc1<D, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.all(this.data(), arg_0 -> condition.execute(arg_0)), Matchers.is((Object)true));
        return this;
    }

    @JDIAction(value="Assert that any of '{name}' elements meet condition")
    public DataListAssert<T, D> any(JFunc1<D, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.any(this.data(), arg_0 -> condition.execute(arg_0)), Matchers.is((Object)true));
        return this;
    }

    @JDIAction(value="Assert that only one of '{name}' elements meet condition")
    public DataListAssert<T, D> onlyOne(JFunc1<D, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.single(this.data(), arg_0 -> condition.execute(arg_0)), Matchers.is((Matcher)Matchers.notNullValue()));
        return this;
    }

    @JDIAction(value="Assert that none of '{name}' meet condition")
    public DataListAssert<T, D> noOne(JFunc1<D, Boolean> condition) {
        SoftAssert.jdiAssert(LinqUtils.first(this.data(), arg_0 -> condition.execute(arg_0)), Matchers.is((Matcher)Matchers.nullValue()));
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' text {0}")
    public DataListAssert<T, D> value(D item) {
        return this.and(Matchers.hasItem(item));
    }

    @Override
    @JDIAction(value="Assert that '{name}' text {0}")
    public DataListAssert<T, D> value(Matcher<String> condition) {
        MatcherAssert.assertThat(((DataList)this.element()).values(), (Matcher)Matchers.hasItem(condition));
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' text {0}")
    public DataListAssert<T, D> value(String text) {
        MatcherAssert.assertThat(((DataList)this.element()).values(), (Matcher)Matchers.hasItem((Object)text));
        return this;
    }

    @JDIAction(value="Assert that '{name}' elements [{0}] are displayed")
    public DataListAssert<T, D> displayed(String ... names) {
        for (String name : names) {
            SoftAssert.jdiAssert(((DataList)this.element()).get(name).isDisplayed() ? name + "displayed" : "hidden", Matchers.is((Object)(name + "displayed")));
        }
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' has at least one displayed element")
    public DataListAssert<T, D> displayed() {
        SoftAssert.jdiAssert(((DataList)this.element()).isDisplayed() ? "displayed" : "hidden", Matchers.is((Object)"displayed"));
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is hidden")
    public DataListAssert<T, D> hidden() {
        SoftAssert.jdiAssert(LinqUtils.map((Collection)((Collection)this.element()), this::isDisplayed), Matchers.everyItem((Matcher)Matchers.is((Object)false)));
        return this;
    }

    private boolean isDisplayed(T element) {
        try {
            return element.core().isDisplayed();
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Is element Displayed failed. DataList element not a Section. Only Sections can be assert on isDisplayed", new Object[0]);
        }
    }

    @Override
    @JDIAction(value="Assert that '{name}' is empty")
    public DataListAssert<T, D> empty() {
        SoftAssert.jdiAssert(((DataList)this.element()).isEmpty() ? "list is empty" : "list is not empty", Matchers.is((Object)"list is empty"));
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' is not empty")
    public DataListAssert<T, D> notEmpty() {
        SoftAssert.jdiAssert(((DataList)this.element()).isEmpty() ? "list is empty" : "list is not empty", Matchers.is((Object)"list is not empty"));
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' size {0}")
    public DataListAssert<T, D> size(Matcher<Integer> condition) {
        SoftAssert.jdiAssert(((DataList)this.element()).size(), condition);
        return this;
    }

    @Override
    @JDIAction(value="Assert that '{name}' size {0}")
    public DataListAssert<T, D> size(int size) {
        return this.size(Matchers.equalTo((Object)size));
    }

    @JDIAction(value="Assert that '{name}' data {0}")
    public DataListAssert<T, D> and(Matcher<? super List<D>> condition) {
        MatcherAssert.assertThat(this.data(), condition);
        return this;
    }
}

