/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.actions;

import com.epam.jdi.light.actions.ActionHelper;
import com.epam.jdi.light.actions.ActionObject;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.Safe;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class ActionProcessor {
    public static Safe<List<ActionObject>> jStack = new Safe(new ArrayList());

    @Pointcut(value="execution(* *(..)) && @annotation(com.epam.jdi.light.common.JDIAction)")
    protected void jdiPointcut() {
    }

    @Pointcut(value="execution(* *(..)) && @annotation(io.qameta.allure.Step)")
    protected void stepPointcut() {
    }

    @Around(value="jdiPointcut()")
    public Object jdiAround(ProceedingJoinPoint jp) {
        ActionObject jInfo = null;
        try {
            jInfo = ActionHelper.newInfo(jp);
            ActionHelper.failedMethods.clear();
            ActionHelper.BEFORE_JDI_ACTION.execute((Object)jInfo);
            Object result = jInfo.topLevel() ? ActionHelper.stableAction(jInfo) : ActionHelper.defaultAction(jInfo);
            Object object = ActionHelper.AFTER_JDI_ACTION.execute((Object)jInfo, result);
            return object;
        }
        catch (Throwable ex) {
            WebSettings.logger.debug("ActionProcessor exception:" + Exceptions.safeException(ex), new Object[0]);
            throw (RuntimeException)ActionHelper.ACTION_FAILED.execute((Object)jInfo, (Object)ex);
        }
        finally {
            if (jInfo != null) {
                jInfo.clear();
            }
        }
    }

    @Before(value="stepPointcut()")
    public void step(JoinPoint jp) {
        ActionObject jInfo = null;
        try {
            jInfo = ActionHelper.newInfo(jp);
            ActionHelper.beforeStepAction(jp);
        }
        catch (Throwable ex) {
            WebSettings.logger.debug("StepProcessor exception:" + Exceptions.safeException(ex), new Object[0]);
            throw (RuntimeException)ActionHelper.ACTION_FAILED.execute((Object)jInfo, (Object)ex);
        }
        finally {
            if (jInfo != null) {
                jInfo.clear();
            }
        }
    }
}

