/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.actions;

import com.epam.jdi.light.actions.ActionHelper;
import com.epam.jdi.light.actions.ActionOverride;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.tools.CacheValue;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.func.JFunc1;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class ActionObject {
    private JoinPoint jp;
    private ProceedingJoinPoint pjp;
    private UUID uuid;
    public String stepUId = "";
    private CacheValue<Object> obj = new CacheValue(() -> this.jp().getThis() != null ? this.jp().getThis() : this.jp().getSignature().getDeclaringType().getSimpleName());
    private int elementTimeout;
    private CacheValue<Integer> timeout = new CacheValue(this::getTimeout);
    private CacheValue<JFunc1<Object, Object>> overrideAction = new CacheValue(this::getOverride);
    private static Safe<List<String>> isOverride = new Safe(ArrayList::new);

    public ActionObject(JoinPoint joinPoint) {
        this.jp = joinPoint;
        this.baseInit();
    }

    public ActionObject(ProceedingJoinPoint joinPoint) {
        this.pjp = joinPoint;
        this.baseInit();
    }

    private void baseInit() {
        this.uuid = UUID.randomUUID();
        try {
            this.elementTimeout = this.element() != null ? this.element().base().getTimeout() : JDISettings.TIMEOUTS.element.get();
        }
        catch (Throwable ex) {
            this.elementTimeout = 10;
        }
    }

    public UUID uuid() {
        return this.uuid;
    }

    public JoinPoint jp() {
        return this.pjp != null ? this.pjp : this.jp;
    }

    public Object execute() throws Throwable {
        return this.pjp().proceed();
    }

    public ProceedingJoinPoint pjp() {
        return this.pjp;
    }

    public boolean topLevel() {
        return ActionHelper.aroundCount() == 1;
    }

    public LogLevels logLevel() {
        return ActionHelper.logLevel(this.jp());
    }

    public Object object() {
        return this.obj.get();
    }

    public IBaseElement element() {
        try {
            IBaseElement element;
            if (this.jp().getThis() != null && ReflectionUtils.isInterface(ActionHelper.getJpClass(this.jp()), IBaseElement.class) && (element = (IBaseElement)this.jp().getThis()).base() != null) {
                return element;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ICoreElement core() {
        try {
            ICoreElement element;
            if (this.jp().getThis() != null && ReflectionUtils.isInterface(ActionHelper.getJpClass(this.jp()), ICoreElement.class) && (element = (ICoreElement)this.jp().getThis()).core() != null) {
                return element;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int timeout() {
        return (Integer)this.timeout.get();
    }

    private int getTimeout() {
        JDIAction ja = this.jp() != null ? this.jdiAnnotation() : null;
        return ja != null && ja.timeout() != -1 ? ja.timeout() : this.elementTimeout;
    }

    public JDIAction jdiAnnotation() {
        return ActionHelper.getJdiAction(this.jp());
    }

    public boolean isAssertAnnotation() {
        JDIAction ja = ActionHelper.getJdiAction(this.jp());
        return ja != null && ja.isAssert();
    }

    private void resetElementTimeout() {
        if (this.element() != null) {
            this.element().base().waitSec(this.elementTimeout);
        }
    }

    public void setElementTimeout() {
        if (this.element() != null) {
            this.element().base().waitSec(this.timeout());
        }
    }

    public JFunc1<Object, Object> overrideAction() {
        return (JFunc1)this.overrideAction.get();
    }

    private JFunc1<Object, Object> getOverride() {
        String name = this.jp().getSignature().getName();
        if (((List)isOverride.get()).contains(name)) {
            return null;
        }
        JFunc1<Object, Object> override = ActionOverride.getOverrideAction(this.jp());
        if (override != null) {
            ((List)isOverride.get()).add(name);
        }
        return override;
    }

    public void clear() {
        this.resetElementTimeout();
        ((List)isOverride.get()).clear();
    }

    public Method jpMethod() {
        return ((MethodSignature)this.jp().getSignature()).getMethod();
    }

    public Class<?> jpClass() {
        return ActionHelper.getJpClass(this.jp());
    }

    public String methodName() {
        return ActionHelper.getMethodName(this.jp());
    }

    public String className() {
        return ActionHelper.getJpClass(this.jp()).getSimpleName();
    }

    public String methodFullName() {
        return ActionHelper.getClassMethodName(this.jp());
    }
}

