/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.actions;

import com.epam.jdi.light.actions.ActionObject;
import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.asserts.generic.JAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.OutputTemplates;
import com.epam.jdi.light.common.PageChecks;
import com.epam.jdi.light.common.VisualCheckAction;
import com.epam.jdi.light.common.VisualCheckPage;
import com.epam.jdi.light.driver.ScreenshotMaker;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.base.DriverBase;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.Alerts;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.common.WindowsManager;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.elements.interfaces.base.INamed;
import com.epam.jdi.light.elements.pageobjects.annotations.VisualCheck;
import com.epam.jdi.light.logger.AllureLogger;
import com.epam.jdi.light.logger.HighlightStrategy;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.logger.Strategy;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.JsonUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.Safe;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.Timer;
import com.epam.jdi.tools.func.JAction1;
import com.epam.jdi.tools.func.JFunc;
import com.epam.jdi.tools.func.JFunc1;
import com.epam.jdi.tools.func.JFunc2;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import com.epam.jdi.tools.switcher.CaseR;
import com.epam.jdi.tools.switcher.SwitchActions;
import io.qameta.allure.Step;
import io.qameta.allure.aspects.StepsAspects;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.openqa.selenium.WebDriver;

public class ActionHelper {
    public static JFunc1<JoinPoint, String> GET_ACTION_NAME = ActionHelper::getActionName;
    public static JFunc1<JoinPoint, MapArray<String, Object>> LOG_VALUES = ActionHelper::getLogOptions;
    public static Safe<Boolean> isAssert = new Safe(null);
    public static int CUT_STEP_TEXT = 70;
    public static JFunc1<String, String> TRANSFORM_LOG_STRING = s -> s;
    static Safe<List<String>> allureSteps = new Safe(ArrayList::new);
    public static JAction1<ActionObject> BEFORE_JDI_ACTION = ActionHelper::beforeJdiAction;
    public static JFunc2<ActionObject, Object, Object> AFTER_STEP_ACTION = ActionHelper::afterStepAction;
    public static JFunc2<ActionObject, Object, Object> AFTER_JDI_ACTION = ActionHelper::afterJdiAction;
    public static List<String> failedMethods = new ArrayList<String>();
    public static JFunc2<ActionObject, Throwable, RuntimeException> ACTION_FAILED = ActionHelper::actionFailed;
    public static MapArray<String, JFunc1<Object, Boolean>> CONDITIONS = MapArray.map((Pair[])new Pair[]{Pair.$((Object)"", result -> true), Pair.$((Object)"true", result -> result instanceof Boolean && (Boolean)result != false), Pair.$((Object)"false", result -> result instanceof Boolean && (Boolean)result == false), Pair.$((Object)"not empty", result -> result instanceof List && ((List)result).size() > 0), Pair.$((Object)"empty", result -> result instanceof List && ((List)result).size() == 0)});

    static String getTemplate(LogLevels level) {
        if (JDISettings.LOGS.logInfoDetails != null) {
            switch (JDISettings.LOGS.logInfoDetails) {
                case NONE: {
                    return OutputTemplates.STEP_TEMPLATE;
                }
                case NAME: {
                    return OutputTemplates.NAME_TEMPLATE;
                }
                case LOCATOR: {
                    return OutputTemplates.LOCATOR_TEMPLATE;
                }
                case CONTEXT: {
                    return OutputTemplates.CONTEXT_TEMPLATE;
                }
                case ELEMENT: {
                    return OutputTemplates.ELEMENT_TEMPLATE;
                }
            }
        }
        return level.equalOrMoreThan(LogLevels.STEP) ? OutputTemplates.STEP_TEMPLATE : OutputTemplates.ELEMENT_TEMPLATE;
    }

    public static String getActionName(JoinPoint jp) {
        try {
            MethodSignature method = ActionHelper.getJpMethod(jp);
            String template = ActionHelper.methodNameTemplate(method);
            return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)template) ? ActionHelper.getDefaultName(jp, method) : ActionHelper.fillTemplate(template, jp, method);
        }
        catch (Throwable ex) {
            ScreenshotMaker.takeScreen();
            throw Exceptions.exception(ex, "Surround method issue: Can't get action name: " + ActionHelper.getClassMethodName(jp), new Object[0]);
        }
    }

    public static String fillTemplate(String template, JoinPoint jp, MethodSignature method) {
        String filledTemplate = template;
        try {
            if (filledTemplate.contains("{0")) {
                Object[] args = ActionHelper.getArgs(jp);
                filledTemplate = StringUtils.msgFormat((String)filledTemplate, (Object[])args);
            } else if (filledTemplate.contains("%s")) {
                filledTemplate = String.format(filledTemplate, ActionHelper.getArgs(jp));
            }
            if (filledTemplate.contains("{")) {
                MapArray<String, Object> methods;
                MapArray<String, Object> fields;
                MapArray<String, Object> core;
                MapArray<String, Object> args;
                MapArray<String, Object> obj = ActionHelper.toMap((JFunc<MapArray<String, Object>>)((JFunc)() -> new MapArray((Object)"this", (Object)ActionHelper.getElementName(jp))));
                if ((filledTemplate = ActionHelper.getActionNameFromTemplate(method, filledTemplate, obj, args = ActionHelper.methodArgs(jp, method), core = ActionHelper.core(jp), fields = ActionHelper.classFields(jp.getThis()), methods = ActionHelper.classMethods(jp.getThis()))).contains("{{VALUE}}") && args.size() > 0) {
                    filledTemplate = filledTemplate.replaceAll("\\{\\{VALUE}}", args.get(0).toString());
                }
                if (filledTemplate.contains("{failElement}")) {
                    filledTemplate = filledTemplate.replaceAll("\\{failElement}", obj.get((int)0).value.toString());
                }
            }
            return filledTemplate;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Surround method issue: Can't fill JDIAction template: " + template + " for method: " + ActionHelper.getClassMethodName(jp), new Object[0]);
        }
    }

    public static void beforeJdiAction(ActionObject jInfo) {
        JoinPoint jp = jInfo.jp();
        String message = (String)TRANSFORM_LOG_STRING.execute((Object)ActionHelper.getBeforeLogString(jp));
        if (JDISettings.LOGS.writeToAllure && ActionHelper.logLevel(jInfo).equalOrMoreThan(LogLevels.INFO) && (((List)allureSteps.get()).isEmpty() || !((List)allureSteps.get()).contains(message))) {
            jInfo.stepUId = AllureLogger.startStep(message);
            ((List)allureSteps.get()).add(message);
        }
        if (jInfo.topLevel()) {
            ActionHelper.processBeforeAction(message, jInfo);
        }
    }

    protected static void processBeforeAction(String message, ActionObject jInfo) {
        allureSteps.reset();
        JoinPoint jp = jInfo.jp();
        if (JDISettings.LOGS.writeToLog) {
            WebSettings.logger.toLog(message, ActionHelper.logLevel(jInfo));
        }
        if (ObjectUtils.isNotEmpty(JDISettings.ELEMENT.highlight) && !JDISettings.ELEMENT.highlight.contains((Object)HighlightStrategy.OFF) && (JDISettings.ELEMENT.highlight.contains((Object)HighlightStrategy.ACTION) && !ActionHelper.isAssert(jInfo) || JDISettings.ELEMENT.highlight.contains((Object)HighlightStrategy.ASSERT) && ActionHelper.isAssert(jInfo))) {
            try {
                jInfo.core().highlight();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (JDISettings.PAGE.checkPageOpen != PageChecks.NONE || WebSettings.VISUAL_PAGE_STRATEGY == VisualCheckPage.CHECK_NEW_PAGE || JDISettings.LOGS.screenStrategy.contains((Object)Strategy.NEW_PAGE)) {
            ActionHelper.processPage(jInfo);
        }
        if (WebSettings.VISUAL_ACTION_STRATEGY == VisualCheckAction.ON_VISUAL_ACTION) {
            ActionHelper.visualValidation(jp, message);
        }
        if (JDISettings.LOGS.screenStrategy.contains((Object)Strategy.ASSERT)) {
            if (ActionHelper.isAssert(jInfo)) {
                ActionHelper.performAssert(jInfo);
            } else {
                isAssert.set((Object)false);
            }
        }
    }

    private static void performAssert(ActionObject jInfo) {
        boolean lastActionIsNotAssert = isAssert.get() == null || (Boolean)isAssert.get() == false;
        isAssert.set((Object)true);
        if (lastActionIsNotAssert) {
            String screenName = "Validate" + org.apache.commons.lang3.StringUtils.capitalize((String)jInfo.methodName());
            AllureLogger.createAttachment(screenName, ReflectionUtils.isClass(jInfo.jpClass(), Alerts.class));
        }
    }

    public static boolean isAssert(ActionObject jInfo) {
        return ReflectionUtils.isInterface(jInfo.jpClass(), JAssert.class) || jInfo.isAssertAnnotation();
    }

    public static void beforeStepAction(JoinPoint jp) {
        String message = (String)TRANSFORM_LOG_STRING.execute((Object)ActionHelper.getBeforeLogString(jp));
        WebSettings.logger.toLog(message, ActionHelper.logLevel(new ActionObject(jp)));
    }

    private static void visualValidation(JoinPoint jp, String message) {
        Object obj = jp.getThis();
        if (obj == null) {
            if (ActionHelper.getJpMethod(jp).getMethod().getAnnotation(VisualCheck.class) != null) {
                try {
                    WebPage.visualWindowCheck();
                }
                catch (Exception ex) {
                    WebSettings.logger.debug("BEFORE: Can't do visualWindowCheck", new Object[0]);
                }
            }
        } else if (ReflectionUtils.isInterface(obj.getClass(), JAssert.class)) {
            JDIBase element = ((IBaseElement)obj).base();
            try {
                element.visualCheck(message);
            }
            catch (Exception ex) {
                WebSettings.logger.debug("BEFORE: Can't do visualCheck for element", new Object[0]);
            }
        }
    }

    public static Object afterStepAction(ActionObject jInfo, Object result) {
        ActionHelper.afterAction(jInfo, result);
        AllureLogger.passStep(jInfo.stepUId);
        return result;
    }

    public static Object afterJdiAction(ActionObject jInfo, Object result) {
        ActionHelper.afterAction(jInfo, result);
        AllureLogger.passStep(jInfo.stepUId);
        return result;
    }

    static void afterAction(ActionObject jInfo, Object result) {
        JoinPoint jp = jInfo.jp();
        if (ActionHelper.logResult(jp)) {
            LogLevels logLevel = ActionHelper.logLevel(jInfo);
            if (result == null || ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), JAssert.class) || ReflectionUtils.isInterface(ActionHelper.firstInfo(jInfo).jpClass(), JAssert.class)) {
                WebSettings.logger.debug("Done", new Object[0]);
            } else {
                String text = result.toString();
                if (jInfo.topLevel()) {
                    String message = ">>> " + (logLevel == LogLevels.STEP && text.length() > CUT_STEP_TEXT + 5 ? text.substring(0, CUT_STEP_TEXT) + "..." : text);
                    WebSettings.logger.toLog(message, logLevel);
                }
                if (JDISettings.LOGS.writeToAllure && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jInfo.stepUId)) {
                    AllureLogger.attachText("Actual result", "text/plain", text);
                }
            }
        }
        ActionHelper.waitAfterAction(jInfo);
        JDISettings.TIMEOUTS.element.reset();
    }

    private static void waitAfterAction(ActionObject jInfo) {
        IBaseElement element = jInfo.element();
        if (element == null) {
            return;
        }
        Pair<String, Integer> waitAfter = element.base().waitAfter();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)waitAfter.key)) && jInfo.methodName().equalsIgnoreCase((String)waitAfter.key) && (Integer)waitAfter.value > 0) {
            Timer.sleep((long)((Integer)waitAfter.value * 1000));
        }
    }

    static boolean logResult(JoinPoint jp) {
        if (!JDISettings.LOGS.writeToLog) {
            return false;
        }
        JDIAction ja = ActionHelper.getJdiAction(jp);
        return ja != null && ja.logResult();
    }

    static JDIAction getJdiAction(JoinPoint jp) {
        return ((MethodSignature)jp.getSignature()).getMethod().getAnnotation(JDIAction.class);
    }

    protected static Class<?> getJpClass(JoinPoint jp) {
        return jp.getThis() != null ? jp.getThis().getClass() : jp.getSignature().getDeclaringType();
    }

    public static String getBeforeLogString(JoinPoint jp) {
        String logString;
        String actionName = (String)GET_ACTION_NAME.execute((Object)jp);
        if (jp.getThis() == null) {
            logString = actionName;
        } else {
            MapArray logOptions = (MapArray)LOG_VALUES.execute((Object)jp);
            logOptions.add((Object)"action", (Object)actionName);
            logString = StringUtils.msgFormat((String)ActionHelper.getTemplate(JDISettings.LOGS.logLevel), (MapArray)logOptions);
        }
        return Character.toUpperCase(logString.charAt(0)) + logString.substring(1);
    }

    public static MapArray<String, Object> getLogOptions(JoinPoint jp) {
        MapArray map = new MapArray();
        JFunc elementName = () -> ActionHelper.getElementName(jp);
        map.add((Object)"name", (Object)elementName);
        JFunc element = () -> ActionHelper.getFullInfo(jp);
        map.add((Object)"element", (Object)element);
        JFunc context = () -> ActionHelper.getElementContext(jp);
        map.add((Object)"context", (Object)context);
        JFunc locator = () -> ActionHelper.getElementLocator(jp);
        map.add((Object)"locator", (Object)locator);
        return map;
    }

    public static void processPage(ActionObject jInfo) {
        WebPage page;
        WindowsManager.getWindows();
        Object element = jInfo.jp().getThis();
        if (element != null && !ReflectionUtils.isClass(element.getClass(), WebPage.class) && (page = ActionHelper.getPage(element)) != null) {
            WebPage.setCurrentPage(page);
            JDISettings.PAGE.beforeEachStep.execute((Object)page);
        }
    }

    public static RuntimeException actionFailed(ActionObject jInfo, Throwable ex) {
        ActionHelper.addFailedMethod(jInfo.jp());
        if (jInfo.topLevel()) {
            ActionHelper.logFailure(jInfo);
            Collections.reverse(failedMethods);
            ArrayList<String> chainActions = new ArrayList<String>(failedMethods);
            try {
                WebSettings.logger.error("Url: " + WebPage.getUrl(), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            WebSettings.logger.error("Failed actions chain: " + PrintUtils.print(chainActions, (String)" > "), new Object[0]);
        } else if (JDISettings.LOGS.writeToAllure && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jInfo.stepUId)) {
            StepsAspects.getLifecycle().stopStep(jInfo.stepUId);
        }
        return Exceptions.exception(ex, ActionHelper.getExceptionAround(ex, jInfo), new Object[0]);
    }

    public static void logFailure(ActionObject jInfo) {
        WebSettings.logger.toLog(">>> " + jInfo.object().toString(), LogLevels.ERROR);
        String screenPath = "";
        String htmlSnapshot = "";
        String errors = "";
        if (ObjectUtils.isNotEmpty(JDISettings.ELEMENT.highlight) && !JDISettings.ELEMENT.highlight.contains((Object)HighlightStrategy.OFF) && JDISettings.ELEMENT.highlight.contains((Object)HighlightStrategy.FAIL)) {
            try {
                jInfo.core().highlight();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (JDISettings.LOGS.screenStrategy.contains((Object)Strategy.FAIL)) {
            String string = screenPath = JDISettings.SCREEN.tool.equalsIgnoreCase("robot") ? ScreenshotMaker.takeRobotScreenshot() : ScreenshotMaker.takeScreen("Failed" + org.apache.commons.lang3.StringUtils.capitalize((String)jInfo.methodName()));
        }
        if (JDISettings.LOGS.htmlCodeStrategy.contains((Object)Strategy.FAIL)) {
            htmlSnapshot = AllureLogger.takeHtmlCodeOnFailure();
        }
        if (JDISettings.LOGS.requestsStrategy.contains((Object)Strategy.FAIL)) {
            WebDriver driver = jInfo.element() != null ? jInfo.element().base().driver() : WebDriverFactory.getDriver();
            List requests = driver.manage().logs().get("performance").getAll();
            List errorEntries = LinqUtils.map((Collection)LinqUtils.filter((Collection)requests, JDISettings.LOGS.filterHttpRequests), logEntry -> JsonUtils.beautifyJson((String)logEntry.getMessage()));
            errors = PrintUtils.print((Collection)errorEntries);
        }
        AllureLogger.failStep(jInfo.stepUId, screenPath, htmlSnapshot, errors);
    }

    static WebPage getPage(Object element) {
        if (ReflectionUtils.isInterface(element.getClass(), IBaseElement.class)) {
            return ((IBaseElement)element).base().getPage();
        }
        if (ReflectionUtils.isClass(element.getClass(), WebPage.class)) {
            return (WebPage)element;
        }
        if (ReflectionUtils.isClass(element.getClass(), DriverBase.class)) {
            return ((DriverBase)element).getPage();
        }
        return null;
    }

    public static MethodSignature getJpMethod(JoinPoint joinPoint) {
        return (MethodSignature)joinPoint.getSignature();
    }

    public static String getMethodName(JoinPoint jp) {
        try {
            return ActionHelper.getJpMethod(jp).getName();
        }
        catch (Exception ignore) {
            return "Unknown method";
        }
    }

    static String methodNameTemplate(MethodSignature method) {
        try {
            Method m = method.getMethod();
            if (m.isAnnotationPresent(JDIAction.class)) {
                return m.getAnnotation(JDIAction.class).value();
            }
            if (m.isAnnotationPresent(Step.class)) {
                return m.getAnnotation(Step.class).value();
            }
            return null;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Surround method issue: Can't get method name template", new Object[0]);
        }
    }

    static LogLevels logLevel(ActionObject jInfo) {
        LogLevels topLevel;
        LogLevels currentLevel = ActionHelper.logLevel(jInfo.jp());
        return currentLevel.equalOrLessThan(topLevel = ActionHelper.firstInfo(jInfo).logLevel()) ? currentLevel : topLevel;
    }

    static LogLevels logLevel(JoinPoint jp) {
        Method m = ActionHelper.getJpMethod(jp).getMethod();
        return m.isAnnotationPresent(JDIAction.class) ? m.getAnnotation(JDIAction.class).level() : LogLevels.INFO;
    }

    static String getDefaultName(JoinPoint jp, MethodSignature method) {
        MapArray<String, Object> args = ActionHelper.methodArgs(jp, method);
        String methodName = StringUtils.splitCamelCase((String)ActionHelper.getMethodName(jp));
        if (args.size() == 0) {
            return methodName;
        }
        return String.format("%s%s", methodName, ActionHelper.argsToString(args));
    }

    static String argsToString(MapArray<String, Object> args) {
        return args.size() == 1 ? ActionHelper.argToString(args) : "(" + args.toString() + ")";
    }

    static String argToString(MapArray<String, Object> args) {
        return args.get((int)0).value.getClass().isArray() ? StringUtils.arrayToString((Object)args.get((int)0).value) : "(" + args.get((int)0).value + ")";
    }

    static MapArray<String, Object> methodArgs(JoinPoint joinPoint, MethodSignature method) {
        return ActionHelper.toMap((JFunc<MapArray<String, Object>>)((JFunc)() -> new MapArray((Object[])method.getParameterNames(), ActionHelper.getArgs(joinPoint))));
    }

    static MapArray<String, Object> toMap(JFunc<MapArray<String, Object>> getMap) {
        MapArray.IGNORE_NOT_UNIQUE = true;
        MapArray map = (MapArray)getMap.execute();
        MapArray.IGNORE_NOT_UNIQUE = false;
        return map;
    }

    static Object[] getArgs(JoinPoint jp) {
        Object[] args = jp.getArgs();
        if (args.length == 1 && args[0] == null) {
            return new Object[0];
        }
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = SwitchActions.Switch((Object)args[i]).get(new CaseR[]{SwitchActions.Case(Objects::isNull, null), SwitchActions.Case(arg -> arg.getClass().isArray(), PrintUtils::printArray), SwitchActions.Case(arg -> ReflectionUtils.isInterface(arg.getClass(), List.class), PrintUtils::printList), SwitchActions.Default(arg -> arg)});
        }
        return result;
    }

    static MapArray<String, Object> core(JoinPoint jp) {
        Object instance = jp.getThis();
        if (instance != null && ReflectionUtils.isInterface(instance.getClass(), ICoreElement.class)) {
            UIElement el = ((ICoreElement)instance).core();
            return ReflectionUtils.getAllFields((Object)el);
        }
        return new MapArray();
    }

    static MapArray<String, Object> classFields(Object obj) {
        return obj != null ? ReflectionUtils.getAllFields((Object)obj) : new MapArray();
    }

    static MapArray<String, Object> classMethods(Object obj) {
        return obj != null ? ActionHelper.getMethods(obj) : new MapArray();
    }

    private static MapArray<String, Object> getMethods(Object obj) {
        return new MapArray((Object[])obj.getClass().getMethods(), method -> method.getName() + "()", v -> ActionHelper.func(obj, v), true);
    }

    private static JFunc<String> func(Object obj, Method m) {
        return () -> m.invoke(obj, new Object[0]).toString();
    }

    static String getElementName(JoinPoint jp) {
        try {
            Object obj = jp.getThis();
            if (obj == null) {
                return jp.getSignature().getDeclaringType().getSimpleName();
            }
            return ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), INamed.class) ? ((INamed)obj).getName() : obj.toString();
        }
        catch (Throwable ex) {
            return "Can't get element name";
        }
    }

    static String getElementContext(JoinPoint jp) {
        try {
            Object obj = jp.getThis();
            if (obj == null) {
                return jp.getSignature().getDeclaringType().getSimpleName();
            }
            if (ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), IBaseElement.class)) {
                return ((IBaseElement)obj).base().printFullLocator();
            }
            return ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), INamed.class) ? ((INamed)obj).getName() : obj.toString();
        }
        catch (Throwable ex) {
            return "Can't get context locator";
        }
    }

    static String getFullInfo(JoinPoint jp) {
        try {
            Object obj = jp.getThis();
            if (obj == null) {
                return jp.getSignature().getDeclaringType().getSimpleName();
            }
            if (ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), IBaseElement.class)) {
                return ((IBaseElement)obj).base().toString();
            }
            return ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), INamed.class) ? ((INamed)obj).getName() : obj.toString();
        }
        catch (Throwable ex) {
            return "Can't get context locator";
        }
    }

    static String getElementLocator(JoinPoint jp) {
        try {
            Object obj = jp.getThis();
            if (obj == null) {
                return jp.getSignature().getDeclaringType().getSimpleName();
            }
            if (ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), IBaseElement.class)) {
                return ((IBaseElement)obj).base().locator.toString();
            }
            return ReflectionUtils.isInterface(ActionHelper.getJpClass(jp), INamed.class) ? ((INamed)obj).getName() : obj.toString();
        }
        catch (Throwable ex) {
            return "Can't get element locator";
        }
    }

    static String getActionNameFromTemplate(MethodSignature method, String value, MapArray<String, Object> ... args) {
        try {
            String result;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
                result = StringUtils.splitLowerCase((String)method.getMethod().getName());
                if (args[1].size() == 1) {
                    result = result + " '" + args[1].values().get(0) + "'";
                }
            } else {
                result = value;
                for (MapArray<String, Object> params : args) {
                    result = StringUtils.msgFormat((String)result, params);
                }
            }
            return result;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Surround method issue: Can't get action name", new Object[0]);
        }
    }

    public static void addFailedMethod(JoinPoint jp) {
        String[] s = jp.toString().split("\\.");
        String result = String.format("%s.%s%s", s[s.length - 2], s[s.length - 1].replaceAll("\\)\\)", ""), ActionHelper.printArgs(ActionHelper.getArgs(jp)));
        if (!failedMethods.contains(result)) {
            failedMethods.add(result);
        }
    }

    private static String printArgs(Object[] args) {
        return args.length == 0 ? ")" : String.format(":'%s')", PrintUtils.print(Arrays.asList(args), Object::toString));
    }

    public static String getExceptionAround(Throwable ex, ActionObject jInfo) {
        String result = Exceptions.safeException(ex);
        while (result.contains("\n\n")) {
            result = result.replaceFirst("\\n\\n", StringUtils.LINE_BREAK);
        }
        result = result.replace("java.lang.RuntimeException:", "").trim();
        Object[] args = jInfo.jp().getArgs();
        if (result.contains("{{VALUE}}") && args.length > 0) {
            result = result.replaceAll("\\{\\{VALUE}}", args[0].toString());
        }
        if (jInfo.topLevel()) {
            result = "[" + Timer.nowTime((String)"mm:ss.S") + "] " + result.replaceFirst("\n", "");
        }
        return result;
    }

    private static List<StackTraceElement> arounds() {
        List arounds = LinqUtils.where((Object[])Thread.currentThread().getStackTrace(), s -> s.getMethodName().equals("jdiAround"));
        Collections.reverse(arounds);
        return arounds;
    }

    public static boolean notThisAround(String name) {
        return !ActionHelper.arounds().get(0).getClassName().equals(name);
    }

    public static int aroundCount() {
        return LinqUtils.where((Object[])Thread.currentThread().getStackTrace(), s -> s.getMethodName().equals("jdiAround")).size();
    }

    static String getClassMethodName(JoinPoint jp) {
        String className = ActionHelper.getJpClass(jp).getSimpleName();
        String methodName = ActionHelper.getMethodName(jp);
        return className + "." + methodName;
    }

    public static Class<?> getJpClass(ProceedingJoinPoint jp) {
        return jp.getThis() != null ? jp.getThis().getClass() : jp.getSignature().getDeclaringType();
    }

    public static Object defaultAction(ActionObject jInfo) throws Throwable {
        WebSettings.logger.debug("defaultAction: " + ActionHelper.getClassMethodName(jInfo.jp()), new Object[0]);
        jInfo.setElementTimeout();
        return jInfo.overrideAction() != null ? jInfo.overrideAction().execute(jInfo.object()) : jInfo.execute();
    }

    public static Object stableAction(ActionObject jInfo) {
        WebSettings.logger.debug("stableAction: " + ActionHelper.getClassMethodName(jInfo.jp()), new Object[0]);
        String exceptionMsg = "";
        jInfo.setElementTimeout();
        long start = System.currentTimeMillis();
        Throwable exception = null;
        do {
            try {
                Object result;
                WebSettings.logger.debug("do-while: " + ActionHelper.getClassMethodName(jInfo.jp()), new Object[0]);
                Object object = result = jInfo.overrideAction() != null ? jInfo.overrideAction().execute(jInfo.object()) : jInfo.execute();
                if (ActionHelper.condition(jInfo.jp())) {
                    return result;
                }
            }
            catch (Throwable ex) {
                exception = ex;
                try {
                    exceptionMsg = Exceptions.safeException(ex);
                    Thread.sleep(200L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        } while (System.currentTimeMillis() - start < (long)(jInfo.timeout() * 1000));
        throw Exceptions.exception(exception, ActionHelper.getFailedMessage(jInfo, exceptionMsg), new Object[0]);
    }

    static String getFailedMessage(ActionObject jInfo, String exception) {
        MethodSignature method = ActionHelper.getJpMethod(jInfo.jp());
        try {
            String result = StringUtils.msgFormat((String)OutputTemplates.FAILED_ACTION_TEMPLATE, (MapArray)MapArray.map((Pair[])new Pair[]{Pair.$((Object)"exception", (Object)exception), Pair.$((Object)"timeout", (Object)jInfo.timeout()), Pair.$((Object)"action", (Object)ActionHelper.getClassMethodName(jInfo.jp()))}));
            return ActionHelper.fillTemplate(result, jInfo.jp(), method);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Surround method issue: Can't get failed message", new Object[0]);
        }
    }

    static String getConditionName(JoinPoint jp) {
        JDIAction ja = ActionHelper.getJdiAction(jp);
        return ja != null ? ja.condition() : "";
    }

    static boolean condition(JoinPoint jp) {
        String conditionName = ActionHelper.getConditionName(jp);
        return CONDITIONS.has((Object)conditionName) && (Boolean)((JFunc1)CONDITIONS.get((Object)conditionName)).execute((Object)jp) != false || !CONDITIONS.has((Object)conditionName);
    }

    public static ActionObject newInfo(ProceedingJoinPoint jp) {
        try {
            return ActionHelper.newInfo(new ActionObject(jp));
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "Failed to init pjp aspect: ", new Object[0]);
        }
    }

    public static ActionObject newInfo(JoinPoint jp) {
        try {
            return ActionHelper.newInfo(new ActionObject(jp));
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "Failed to init jp aspect: ", new Object[0]);
        }
    }

    public static ActionObject newInfo(ActionObject jInfo) {
        if (jInfo.topLevel()) {
            ActionProcessor.jStack.set((Object)LinqUtils.newList((Object[])new ActionObject[]{jInfo}));
        } else {
            ((List)ActionProcessor.jStack.get()).add(jInfo);
        }
        return jInfo;
    }

    public static ActionObject firstInfo(ActionObject jInfo) {
        try {
            return (ActionObject)((List)ActionProcessor.jStack.get()).get(0);
        }
        catch (Exception ignore) {
            return jInfo;
        }
    }
}

