/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table;

import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.BaseTable;
import com.epam.jdi.light.elements.complex.table.Column;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.MarkupLocator;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.func.JFunc2;
import java.util.Collection;
import org.openqa.selenium.support.ui.Quotes;

public class TableMatcher {
    public static JFunc2<BaseTable, TableMatcher[], WebList> TABLE_MATCHER = (table, matchers) -> {
        String locator = String.format("./%s/ancestor::*/td", PrintUtils.print((Collection)LinqUtils.map((Object[])matchers, m -> m.getLocator((BaseTable)table)), (String)"/ancestor::*"));
        return UIFactory.$$(locator, table);
    };
    private String locator;
    private Column column;
    private String name;

    public static TableMatcher hasValue(String value, Column column) {
        return new TableMatcher("/td[%s][normalize-space(.)=" + Quotes.escape((String)value) + "]", column, String.format("has '%s' in column '%s'", new Object[]{value, column}));
    }

    public static TableMatcher containsValue(String value, Column column) {
        return new TableMatcher("/td[%s][contains(normalize-space(.)," + Quotes.escape((String)value) + ")]", column, String.format("contains '%s' in column '%s'", new Object[]{value, column}));
    }

    public TableMatcher setColumn(Column column) {
        this.column = column;
        return this;
    }

    TableMatcher(@MarkupLocator String locator, Column column, String name) {
        this.locator = locator;
        this.column = column;
        this.name = name;
    }

    public String getLocator(BaseTable table) {
        return String.format(this.locator, this.column.getIndex(table.header()));
    }

    public String toString() {
        return this.name;
    }
}

