/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex;

import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.asserts.core.DataListAssert;
import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.common.UIUtils;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.DataList$AjcClosure1;
import com.epam.jdi.light.elements.complex.DataList$AjcClosure3;
import com.epam.jdi.light.elements.complex.ListBase;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.tools.EnumUtils;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import com.epam.jdi.tools.ReflectionUtils;
import com.epam.jdi.tools.StringUtils;
import com.epam.jdi.tools.map.MapArray;
import com.epam.jdi.tools.pairs.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.WebElement;

public class DataList<T extends ICoreElement, D>
extends ListBase<T, DataListAssert<T, D>> {
    public Class<D> dataType;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public DataList() {
    }

    public DataList(Class<T> type, Class<D> dataType) {
        this.initClass = type;
        this.dataType = dataType;
    }

    public D getData(String name) {
        return UIUtils.asEntity(this.get(name), this.dataType);
    }

    public D getData(Enum name) {
        return this.getData(EnumUtils.getEnumValue((Enum)name));
    }

    public D getData(int index) {
        return UIUtils.asEntity(this.get(index), this.dataType);
    }

    public List<D> asData() {
        block3: {
            try {
                if (this.dataType != null) break block3;
                return null;
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Can't get DataList data", new Object[0]);
            }
        }
        List elements = this.elements(0);
        return LinqUtils.map((Collection)elements, v -> UIUtils.asEntity(v, this.dataType));
    }

    @Override
    public String getValue() {
        return PrintUtils.print(this.asData(), Object::toString);
    }

    @Override
    public DataListAssert<T, D> is() {
        this.refresh();
        return (DataListAssert)new DataListAssert().set(this);
    }

    @JDIAction(value="Assert that {name} data meet condition")
    public DataListAssert<T, D> isData(Matcher<? super List<D>> condition) {
        Matcher<? super List<D>> matcher = condition;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, matcher);
        Object[] objectArray = new Object[]{this, matcher, joinPoint};
        DataList$AjcClosure1 dataList$AjcClosure1 = new DataList$AjcClosure1(objectArray);
        return (DataListAssert)ActionProcessor.aspectOf().jdiAround(dataList$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @JDIAction(value="Assert that {name} data meet condition")
    public DataListAssert<T, D> assertThat(Matcher<? super List<D>> condition) {
        Matcher<? super List<D>> matcher = condition;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, matcher);
        Object[] objectArray = new Object[]{this, matcher, joinPoint};
        DataList$AjcClosure3 dataList$AjcClosure3 = new DataList$AjcClosure3(objectArray);
        return (DataListAssert)ActionProcessor.aspectOf().jdiAround(dataList$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public DataListAssert<T, D> verify(Matcher<? super List<D>> condition) {
        SoftAssert.assertSoft();
        return this.isData(condition);
    }

    @Override
    public void setup(Field field) {
        try {
            Type[] types = ReflectionUtils.getGenericTypes((Field)field);
            if (types.length == 0) {
                throw Exceptions.exception("Can't setup DataList generic parameters for field '%s'. Actual 0 but expected 1 or 2", field.getName());
            }
            if (types.length > 2) {
                throw Exceptions.exception("Can't setup DataList generic parameters for field '%s'. Actual more than %s but expected 1 or 2", field.getName(), types.length);
            }
            this.initClass = types[0].toString().equals("?") ? null : (Class)types[0];
            this.dataType = types.length == 1 || types[1].toString().equals("?") ? null : (Class)types[1];
        }
        catch (Exception exception) {}
    }

    public int getIndex(String name) {
        int i = this.list().startIndex;
        if (this.list().map.hasValue() && this.list().isActualMap()) {
            for (Pair pair : ((MapArray)this.list().map.get()).pairs) {
                if (StringUtils.namesEqual((String)((String)pair.key), (String)name)) {
                    if (!this.list().isActual((WebElement)pair.value)) break;
                    return i;
                }
                ++i;
            }
        }
        for (UIElement element : this.list().elements(1)) {
            String title = this.elementTitle(element);
            if (StringUtils.namesEqual((String)title, (String)name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public List<String> values() {
        return LinqUtils.map(this.asData(), Object::toString);
    }

    public List<String> keys() {
        this.asData();
        return ((MapArray)this.list().map.get()).keys();
    }

    static {
        DataList.ajc$preClinit();
    }

    static final /* synthetic */ DataListAssert isData_aroundBody0(DataList ajc$this, Matcher condition, JoinPoint joinPoint) {
        MatcherAssert.assertThat(ajc$this.asData(), (Matcher)condition);
        return ajc$this.is();
    }

    static final /* synthetic */ DataListAssert assertThat_aroundBody2(DataList ajc$this, Matcher condition, JoinPoint joinPoint) {
        return ajc$this.isData(condition);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DataList.java", DataList.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isData", "com.epam.jdi.light.elements.complex.DataList", "org.hamcrest.Matcher", "condition", "", "com.epam.jdi.light.asserts.core.DataListAssert"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "assertThat", "com.epam.jdi.light.elements.complex.DataList", "org.hamcrest.Matcher", "condition", "", "com.epam.jdi.light.asserts.core.DataListAssert"), 74);
    }
}

