/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.elements.common.Keyboard;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.tools.Timer;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class Mouse {
    public static int startX = 100;
    public static int startY = 250;

    public static void mouseClick(int x, int y) {
        Mouse.mouseClick(x, y, 1024);
    }

    public static void mouseClick(WebElement element) {
        Rectangle rect = element.getRect();
        Mouse.mouseClick(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    public static void mouseClick(ICoreElement element) {
        Rectangle rect = element.core().getRect();
        Mouse.mouseClick(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    public static void mouseRightClick(int x, int y) {
        Mouse.mouseClick(x, y, 2048);
    }

    public static void mouseClickRight(WebElement element) {
        Rectangle rect = element.getRect();
        Mouse.mouseRightClick(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    public static void mouseClickRight(ICoreElement element) {
        Rectangle rect = element.core().getRect();
        Mouse.mouseRightClick(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    private static int zoomFactor(int coordinate) {
        return (int)((double)Math.round(coordinate) * WebPage.zoomLevel());
    }

    private static void mouseClick(int x, int y, int inputEvent) {
        Keyboard.getRobot().mouseMove(startX + Mouse.zoomFactor(x), startY + Mouse.zoomFactor(y));
        Keyboard.getRobot().mousePress(inputEvent);
        Keyboard.getRobot().mouseRelease(inputEvent);
    }

    public static void mouseWheel(int wheelAmt) {
        Mouse.mouseWheel(wheelAmt, 50);
    }

    public static void mouseWheel(int wheelAmt, int speed) {
        int count = Math.abs(wheelAmt);
        int step = wheelAmt > 0 ? 1 : -1;
        int i = 1;
        while (i <= count) {
            Keyboard.getRobot().mouseWheel(step);
            Timer.sleep((long)speed);
            ++i;
        }
    }
}

