/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.PathUtils;
import com.epam.jdi.tools.Timer;
import com.epam.jdi.tools.func.JFunc2;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class ScreenshotMaker {
    public static String SCREEN_NAME = "screen";
    public static String DEFAULT_DATE = "yyyy-MM-dd-HH-mm-ss";
    public static JFunc2<String, String, String> FILE_NAME = (name, dateFormat) -> String.valueOf(Timer.nowTime((String)dateFormat)) + name;
    private static final Logger LOGGER = LogManager.getLogger(ScreenshotMaker.class);

    public static String takeScreen() {
        return new ScreenshotMaker().takeScreenshot();
    }

    public static String takeScreen(String name) {
        return new ScreenshotMaker().takeScreenshot(name);
    }

    public static String getPath() {
        if (StringUtils.isBlank((CharSequence)JDISettings.SCREEN.path)) {
            return "";
        }
        String result = JDISettings.SCREEN.path.replace("/", "\\");
        return result.contains(":") ? JDISettings.SCREEN.path : PathUtils.mergePath((String)JDISettings.COMMON.projectPath, (String[])new String[]{JDISettings.SCREEN.path});
    }

    public String takeScreenshot() {
        String name = (String)WebSettings.TEST_NAME.get();
        return this.takeScreenshot(StringUtils.isNotBlank((CharSequence)name) ? name : SCREEN_NAME, DEFAULT_DATE);
    }

    public String takeScreenshot(String value) {
        return this.takeScreenshot(value, DEFAULT_DATE);
    }

    public String takeScreenshot(String name, String dateFormat) {
        if (WebDriverFactory.noRunDrivers()) {
            throw Exceptions.exception("Failed to do screenshot. No Drivers run", new Object[0]);
        }
        String screensFilePath = ScreenshotMaker.getFileName(PathUtils.mergePath((String)ScreenshotMaker.getPath(), (String[])new String[]{(String)FILE_NAME.execute((Object)name, (Object)dateFormat)}));
        new File(screensFilePath).getParentFile().mkdirs();
        File screensFile = (File)((TakesScreenshot)WebDriverFactory.getDriver()).getScreenshotAs(OutputType.FILE);
        try {
            FileUtils.copyFile((File)screensFile, (File)new File(screensFilePath));
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Failed to do screenshot", new Object[0]);
        }
        WebSettings.logger.info("Screenshot: " + screensFilePath, new Object[0]);
        LOGGER.info("RP_MESSAGE#FILE#{}#{}", (Object)screensFilePath, (Object)"Screenshot on Failure");
        return screensFilePath;
    }

    private static String getFileName(String fileName) {
        int num = 1;
        String newName = fileName;
        while (new File(String.valueOf(newName) + JDISettings.SCREEN.fileSuffix).exists()) {
            newName = String.valueOf(fileName) + "_" + num++;
        }
        return String.valueOf(newName) + "." + JDISettings.SCREEN.fileSuffix;
    }

    public static String takeRobotScreenshot() {
        String name = (String)WebSettings.TEST_NAME.get();
        return ScreenshotMaker.takeRobotScreenshot(StringUtils.isNotBlank((CharSequence)name) ? name : SCREEN_NAME, DEFAULT_DATE);
    }

    public static String takeRobotScreenshot(String name) {
        return ScreenshotMaker.takeRobotScreenshot(name, DEFAULT_DATE);
    }

    public static String takeRobotScreenshot(String name, String dateFormat) {
        if (!JDISettings.SCREEN.allowRobot) {
            return new ScreenshotMaker().takeScreenshot(name, dateFormat);
        }
        String screensFilePath = ScreenshotMaker.getFileName(PathUtils.mergePath((String)ScreenshotMaker.getPath(), (String[])new String[]{(String)FILE_NAME.execute((Object)name, (Object)dateFormat)}));
        try {
            Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            new File(screensFilePath).getParentFile().mkdirs();
            Robot robot = new Robot();
            BufferedImage img = robot.createScreenCapture(rectangle);
            ImageIO.write((RenderedImage)img, "jpg", new File(screensFilePath));
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Failed to do screenshot with robot", new Object[0]);
        }
        WebSettings.logger.info("Screenshot: " + screensFilePath, new Object[0]);
        return screensFilePath;
    }
}

