/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.tools.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UnixProcessUtils {
    public static void killProcessesTree(String rootNamePart) {
        try {
            List<String> chrome = UnixProcessUtils.getPIDsByNamePart(rootNamePart);
            for (String s : chrome) {
                int pid = Integer.parseInt(s);
                UnixProcessUtils.killChildProcesses(pid);
            }
            UnixProcessUtils.killProcessesByNamePart(rootNamePart);
        }
        catch (IOException | InterruptedException exception) {
            throw new RuntimeException("Can't kill drivers");
        }
    }

    private static List<String> getPIDsByNamePart(String value) throws IOException, InterruptedException {
        Process process = new ProcessBuilder("/usr/bin/pgrep", "-afi", value).start();
        process.waitFor();
        return StringUtils.inputStreamToList((InputStream)process.getInputStream());
    }

    private static void killChildProcesses(int pid) {
        String ppid = "-P " + pid;
        UnixProcessUtils.killProcessWithArgs(Collections.singletonList(ppid));
    }

    public static void killProcessesByNamePart(String name) {
        UnixProcessUtils.killProcessWithArgs(Arrays.asList("-aif", name));
    }

    private static void killProcessWithArgs(List<String> args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("/usr/bin/pkill");
        list.addAll(args);
        try {
            Process child = new ProcessBuilder(list.toArray(new String[0])).start();
            child.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Can't kill process: " + e.getMessage());
        }
    }
}

