/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.epam.jdi.tools.LinqUtils;
import com.epam.jdi.tools.PrintUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public class JDILocator {
    private By byLocator;
    private List<By> frames;
    public boolean isRoot = false;
    private JDIBase element;
    private Object[] args = new Object[0];

    public JDILocator() {
    }

    public JDILocator(JDIBase element) {
        this.element = element;
    }

    public JDILocator copy() {
        JDILocator locator = new JDILocator();
        locator.byLocator = this.byLocator;
        locator.isRoot = this.isRoot;
        locator.element = this.element;
        locator.frames = this.frames;
        return locator;
    }

    public By getLocator() {
        return this.byLocator;
    }

    public List<By> getFrames() {
        return this.frames;
    }

    public By getLocator(Object ... args) {
        this.args = args;
        if (args.length == 0) {
            return this.byLocator;
        }
        return args.length == 1 ? WebDriverByUtils.fillByTemplate(this.byLocator, args) : WebDriverByUtils.fillByMsgTemplate(this.byLocator, args);
    }

    public boolean isNull() {
        return this.byLocator == null;
    }

    public boolean hasFrame() {
        return this.frames != null && this.frames.size() > 0;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void add(By locator, JDIBase element) {
        this.byLocator = this.setRootLocator(locator) ? this.trimRoot(locator) : locator;
        this.element = element;
    }

    public void add(List<By> frames, JDIBase element) {
        this.frames = frames;
        this.element = element;
    }

    public boolean isTemplate() {
        return this.byLocator != null && this.byLocator.toString().contains("%s");
    }

    public boolean isXPath() {
        return this.byLocator != null && this.byLocator.toString().contains("xpath");
    }

    public String addIndex(int index) {
        String locator = WebDriverByUtils.getByLocator(this.byLocator);
        return locator.equals("..") ? "../*[" + index + "]" : String.format("(%s)[%s]", WebDriverByUtils.getByLocator(this.byLocator), index);
    }

    public String addText(String text) {
        return String.format("(%s)[.='%s']", WebDriverByUtils.getByLocator(this.byLocator), text);
    }

    public int argsCount() {
        return this.byLocator != null ? StringUtils.countMatches((CharSequence)this.byLocator.toString(), (CharSequence)"%s") : 0;
    }

    private boolean setRootLocator(By locator) {
        if (this.containsRoot(locator)) {
            this.isRoot = true;
        }
        return this.isRoot;
    }

    private boolean containsRoot(By by) {
        return by != null && by.toString().contains(": *root*");
    }

    private By trimRoot(By by) {
        String byLocator = WebDriverByUtils.getByLocator(by).replace("*root*", " ").trim();
        return WebDriverByUtils.getByFunc(by).apply(byLocator);
    }

    public String printLocator() {
        return this.toString().replaceAll("\\{\\{VALUE}}", "%s");
    }

    public String toString() {
        By locator;
        block6: {
            try {
                locator = this.getLocator(this.args);
                if (locator != null || this.element == null) break block6;
                if (this.element.webElement.hasValue() || this.element.webElements.hasValue()) {
                    return this.element.printWebElement();
                }
                if (StringUtils.isNotBlank((CharSequence)JDISettings.ELEMENT.smartTemplate)) {
                    return WebSettings.printSmartLocators(this.element);
                }
                return "";
            }
            catch (Exception exception) {
                return "Can't print locator";
            }
        }
        String hasFrame = "";
        if (this.hasFrame()) {
            hasFrame = "Frame: " + PrintUtils.print((Collection)LinqUtils.map(this.frames, WebDriverByUtils::shortBy));
        }
        return String.valueOf(hasFrame) + WebDriverByUtils.shortBy(locator, this.element).replaceAll("%s", "{{VALUE}}");
    }
}

