/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.logger;

import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.tools.LinqUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Level;

public enum LogLevels {
    OFF(0),
    FATAL(100),
    ERROR(200),
    WARNING(300),
    STEP(350),
    INFO(400),
    DEBUG(500),
    TRACE(600),
    ALL(Integer.MAX_VALUE);

    private int level;
    private static final List<Level> allLog4J2Levels;

    static {
        allLog4J2Levels = Arrays.asList(Level.OFF, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL);
    }

    private LogLevels(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equalOrLessThan(LogLevels level) {
        return this.getLevel() >= level.getLevel();
    }

    public boolean equalOrMoreThan(LogLevels level) {
        return this.getLevel() <= level.getLevel();
    }

    public static Level getLog4j2Level(LogLevels level) {
        return (Level)LinqUtils.first(allLog4J2Levels, l -> l.intLevel() >= logLevels.level);
    }

    public static LogLevels parseLogLevel(String logLevel) {
        switch (logLevel.toLowerCase()) {
            case "off": {
                JDISettings.LOGS.writeToLog = false;
                return OFF;
            }
            case "fatal": {
                return FATAL;
            }
            case "error": {
                return ERROR;
            }
            case "warning": {
                return WARNING;
            }
            case "step": {
                return STEP;
            }
            case "debug": {
                return DEBUG;
            }
            case "trace": {
                return TRACE;
            }
            case "all": {
                return ALL;
            }
        }
        return INFO;
    }
}

